/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender;

import de.lema.appender.ExceptionHelper;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;

public class LemaLoggingEvent
implements Serializable {
    private static final long serialVersionUID = 12345L;
    protected static final int MAX = 1000000;
    private final String message;
    private final HashMap<String, String> mdcMap;
    private final String traceString;
    private final Throwable trace;
    private final long datum;
    private final int level;
    private final int lineNumber;
    private final String className;
    private final String methodName;
    private final String threadName;
    private final String exceptionKlasse;
    private int failureCounter;
    private static boolean removeFirstLine = true;
    private final String exceptionMessage;

    public String getMessage() {
        return this.message;
    }

    public String getTraceString() {
        return this.traceString;
    }

    public LemaLoggingEvent(String message, HashMap<String, String> mdc, Throwable trace, String traceString, long datum, int level, int lineNumber, String className, String methodName, String threadName, String exceptionKlasse, String exceptionMessage) {
        this.message = message;
        this.mdcMap = mdc;
        this.trace = trace;
        this.datum = datum;
        this.level = level;
        this.lineNumber = lineNumber;
        this.className = className;
        this.methodName = this.setToNullIfEmpty(methodName);
        this.threadName = this.setToNullIfEmpty(threadName);
        this.exceptionKlasse = this.setToNullIfEmpty(exceptionKlasse);
        this.exceptionMessage = this.setToNullIfEmpty(exceptionMessage);
        this.traceString = this.setToNullIfEmpty(traceString);
    }

    private String setToNullIfEmpty(String s) {
        return s != null && s.length() > 0 ? s : null;
    }

    public LemaLoggingEvent(String message, int level, String className) {
        this.message = message;
        this.mdcMap = null;
        this.trace = null;
        this.datum = System.currentTimeMillis();
        this.level = level;
        this.lineNumber = 0;
        this.className = className;
        this.methodName = null;
        this.threadName = Thread.currentThread().getName();
        this.exceptionKlasse = null;
        this.exceptionMessage = null;
        this.traceString = null;
        removeFirstLine = true;
    }

    public HashMap<String, String> getMdcMap() {
        return this.mdcMap;
    }

    public Throwable getTrace() {
        return this.trace;
    }

    public long getDatum() {
        return this.datum;
    }

    public int getLevel() {
        return this.level;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getExceptionKlasse() {
        return this.exceptionKlasse;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public static String getTrace(Throwable throwable) {
        if (throwable instanceof ExceptionHelper) {
            return LemaLoggingEvent.extractStringExceptionHelper((ExceptionHelper)throwable);
        }
        try {
            TraceBuilder tb = new TraceBuilder(removeFirstLine);
            throwable.printStackTrace(tb);
            return tb.toString();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String extractStringExceptionHelper(ExceptionHelper helper) {
        StringBuilder sb = new StringBuilder();
        List<String> traceList = helper.getTrace();
        for (int i = 0; i < traceList.size() && sb.length() < 1000000; ++i) {
            sb.append(traceList.get(i));
            if (i >= traceList.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public int registerFailure() {
        return ++this.failureCounter;
    }

    public int getFailureCounter() {
        return this.failureCounter;
    }

    public static final class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 12345L;
        private transient LemaLoggingEvent event;

        public SerializationProxy(LemaLoggingEvent event) {
            this.event = event;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeInt(11);
            s.writeInt(this.event.getLevel());
            s.writeLong(this.event.getDatum());
            s.writeObject(this.event.getClassName());
            s.writeObject(this.event.getThreadName());
            s.writeObject(this.event.getMessage());
            s.writeObject(this.event.getMethodName());
            s.writeInt(this.event.getLineNumber());
            s.writeObject(this.event.getMdcMap());
            s.writeObject(this.event.getExceptionKlasse());
            s.writeObject(this.event.getExceptionMessage());
            s.writeObject(this.event.getTrace() != null ? LemaLoggingEvent.getTrace(this.event.getTrace()) : null);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            int felderImStrom = s.readInt();
            int level = this.read(s, felderImStrom, 1, 0);
            long datum = this.read(s, felderImStrom, 2, System.currentTimeMillis());
            String className = this.read(s, felderImStrom, 3, "LemaLogger");
            String threadName = this.read(s, felderImStrom, 4, null);
            String message = this.read(s, felderImStrom, 5, null);
            String methodName = this.read(s, felderImStrom, 6, null);
            int lineNumber = this.read(s, felderImStrom, 7, 0);
            HashMap mdc = this.read(s, felderImStrom, 8, (HashMap)null);
            String exceptionKlasse = this.read(s, felderImStrom, 9, null);
            String exceptionMessage = this.read(s, felderImStrom, 10, null);
            String traceString = this.read(s, felderImStrom, 11, null);
            this.event = new LemaLoggingEvent(message, mdc, null, traceString, datum, level, lineNumber, className, methodName, threadName, exceptionKlasse, exceptionMessage);
        }

        private Object readResolve() {
            return this.event;
        }

        private String read(ObjectInputStream s, int felderImStrom, int akt, String def) throws IOException, ClassNotFoundException {
            return felderImStrom >= akt ? (String)s.readObject() : def;
        }

        private int read(ObjectInputStream s, int felderImStrom, int akt, int def) throws IOException, ClassNotFoundException {
            return felderImStrom >= akt ? s.readInt() : def;
        }

        private long read(ObjectInputStream s, int felderImStrom, int akt, long def) throws IOException, ClassNotFoundException {
            return felderImStrom >= akt ? s.readLong() : def;
        }

        private <T> T read(ObjectInputStream s, int felderImStrom, int akt, T def) throws IOException, ClassNotFoundException {
            return (T)(felderImStrom >= akt ? s.readObject() : def);
        }
    }

    private static class NullWriter
    extends Writer {
        private NullWriter() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
        }
    }

    private static class TraceBuilder
    extends PrintWriter {
        private final StringBuilder v = new StringBuilder();
        boolean firstLine = true;

        public String toString() {
            return this.v.toString();
        }

        TraceBuilder(boolean removeFirstLine) {
            super(new NullWriter());
            this.firstLine = removeFirstLine;
        }

        @Override
        public void print(Object o) {
            this.handleString(o.toString());
        }

        private void handleString(String o) {
            if (this.firstLine) {
                this.firstLine = false;
            } else {
                int length = this.v.length();
                if (length < 1000000) {
                    if (this.checkLineBegin(o)) {
                        o = o.substring(1);
                    }
                    if (length + o.length() > 1000000) {
                        o = o.substring(this.checkLineBegin(o) ? 1 : 0, 1000000 - length);
                    }
                    this.v.append(o).append("\n");
                }
            }
        }

        private boolean checkLineBegin(String o) {
            return o.startsWith("\t") && o.length() > 1;
        }

        @Override
        public void print(char[] chars) {
            this.handleString(new String(chars));
        }

        @Override
        public void print(String s) {
            this.handleString(s);
        }

        @Override
        public void println(Object o) {
            this.handleString(o.toString());
        }

        @Override
        public void println(char[] chars) {
            this.handleString(new String(chars));
        }

        @Override
        public void println(String s) {
            this.handleString(s);
        }

        @Override
        public void write(char[] chars) {
            this.handleString(new String(chars));
        }

        @Override
        public void write(char[] chars, int off, int len) {
            this.handleString(new String(chars, off, len));
        }

        @Override
        public void write(String s, int off, int len) {
            this.handleString(s.substring(off, off + len));
        }

        @Override
        public void write(String s) {
            this.handleString(s);
        }
    }
}

