/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.utils;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.Repository;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

public class MavenArtifactResolver {
    private static String DEFAULT_LOCAL_REPO = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
    private final org.eclipse.aether.RepositorySystem repositorySystem = this.createRepositorySystem();
    private final List<RemoteRepository> remoteRepositories = new LinkedList<RemoteRepository>();

    public MavenArtifactResolver(List<Repository> repositories) {
        repositories.forEach(r -> {
            RemoteRepository repository = new RemoteRepository.Builder(r.getId(), "default", r.getUrl()).build();
            this.remoteRepositories.add(repository);
        });
    }

    private org.eclipse.aether.RepositorySystem createRepositorySystem() {
        DefaultServiceLocator serviceLocator = MavenRepositorySystemUtils.newServiceLocator();
        serviceLocator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        serviceLocator.addService(TransporterFactory.class, FileTransporterFactory.class);
        serviceLocator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        serviceLocator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                throw new RuntimeException(exception);
            }
        });
        return (org.eclipse.aether.RepositorySystem)serviceLocator.getService(org.eclipse.aether.RepositorySystem.class);
    }

    private DefaultRepositorySystemSession createRepositorySystemSession(org.eclipse.aether.RepositorySystem system, String localRepoPath) {
        DefaultRepositorySystemSession systemSession = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(localRepoPath);
        systemSession.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)systemSession, localRepo));
        return systemSession;
    }

    public Set<org.apache.maven.artifact.Artifact> resolve(Artifact artifact) {
        List artifactResults;
        ArtifactResult resolvedArtifact;
        DefaultRepositorySystemSession systemSession = this.createRepositorySystemSession(this.repositorySystem, DEFAULT_LOCAL_REPO);
        try {
            List<ArtifactRequest> artifactRequests = Arrays.asList(new ArtifactRequest((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier() != null ? artifact.getClassifier() : "", artifact.getExtension(), artifact.getVersion()), this.remoteRepositories, "runtime"));
            List results = this.repositorySystem.resolveArtifacts((RepositorySystemSession)systemSession, artifactRequests);
            resolvedArtifact = (ArtifactResult)results.get(results.size() - 1);
        }
        catch (ArtifactResolutionException e) {
            e.printStackTrace();
            return null;
        }
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(resolvedArtifact.getArtifact(), "compile"));
        collectRequest.setRepositories(this.remoteRepositories);
        DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{"compile"});
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, classpathFilter);
        try {
            artifactResults = this.repositorySystem.resolveDependencies((RepositorySystemSession)systemSession, dependencyRequest).getArtifactResults();
        }
        catch (DependencyResolutionException e) {
            e.printStackTrace();
            return null;
        }
        return artifactResults.stream().map(ArtifactResult::getArtifact).map(a -> {
            org.apache.maven.artifact.DefaultArtifact ar = new org.apache.maven.artifact.DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), "compile", "jar", a.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler("jar"));
            ar.setFile(a.getFile());
            return ar;
        }).collect(Collectors.toSet());
    }
}

