/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableLongBag;
import com.gs.collections.api.bag.primitive.LongBag;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongIntProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.Counter;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.SynchronizedLongBag;
import com.gs.collections.impl.bag.mutable.primitive.UnmodifiableLongBag;
import com.gs.collections.impl.factory.primitive.LongBags;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.LongIntHashMap;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class LongHashBag
implements MutableLongBag,
Externalizable {
    private static final IntToIntFunction INCREMENT = new IntToIntFunction(){

        public int valueOf(int intParameter) {
            return intParameter + 1;
        }
    };
    private static final IntToIntFunction DECREMENT = new IntToIntFunction(){

        public int valueOf(int intParameter) {
            return intParameter - 1;
        }
    };
    private static final long serialVersionUID = 1L;
    private LongIntHashMap items;
    private int size;

    public LongHashBag() {
        this.items = new LongIntHashMap();
    }

    public LongHashBag(int size) {
        this.items = new LongIntHashMap(size);
    }

    public LongHashBag(LongIterable iterable) {
        this();
        this.addAll(iterable);
    }

    public LongHashBag(LongHashBag bag) {
        this.items = new LongIntHashMap(bag.sizeDistinct());
        bag.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long item, int occurrences) {
                LongHashBag.this.addOccurrences(item, occurrences);
            }
        });
    }

    public static LongHashBag newBag(int size) {
        return new LongHashBag(size);
    }

    public static LongHashBag newBagWith(long ... source) {
        LongHashBag result = new LongHashBag();
        result.addAll(source);
        return result;
    }

    public static LongHashBag newBag(LongIterable source) {
        if (source instanceof LongHashBag) {
            return new LongHashBag((LongHashBag)source);
        }
        return new LongHashBag(source);
    }

    public static LongHashBag newBag(LongBag source) {
        final LongHashBag result = new LongHashBag();
        source.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long each, int occurrences) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean notEmpty() {
        return this.items.notEmpty();
    }

    public int size() {
        return this.size;
    }

    public int sizeDistinct() {
        return this.items.size();
    }

    public void clear() {
        this.items.clear();
        this.size = 0;
    }

    public LongHashBag with(long element) {
        this.add(element);
        return this;
    }

    public LongHashBag with(long element1, long element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public LongHashBag with(long element1, long element2, long element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    public LongHashBag withAll(LongIterable iterable) {
        this.addAll(iterable);
        return this;
    }

    public LongHashBag without(long element) {
        this.remove(element);
        return this;
    }

    public LongHashBag withoutAll(LongIterable iterable) {
        this.removeAll(iterable);
        return this;
    }

    public boolean contains(long value) {
        return this.items.containsKey(value);
    }

    public boolean containsAll(long ... source) {
        for (long each : source) {
            if (this.items.containsKey(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(LongIterable source) {
        return source.allSatisfy(new LongPredicate(){

            public boolean accept(long each) {
                return LongHashBag.this.contains(each);
            }
        });
    }

    public int occurrencesOf(long item) {
        return this.items.get(item);
    }

    public void forEachWithOccurrences(LongIntProcedure procedure) {
        this.items.forEachKeyValue(procedure);
    }

    public boolean add(long item) {
        this.items.updateValue(item, 0, INCREMENT);
        ++this.size;
        return true;
    }

    public boolean remove(long item) {
        int newValue = this.items.updateValue(item, 0, DECREMENT);
        if (newValue <= 0) {
            this.items.removeKey(item);
            if (newValue == 0) {
                --this.size;
            }
            return newValue == 0;
        }
        --this.size;
        return true;
    }

    public boolean addAll(long ... source) {
        if (source.length == 0) {
            return false;
        }
        for (long each : source) {
            this.add(each);
        }
        return true;
    }

    public boolean addAll(LongIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        if (source instanceof LongBag) {
            LongBag otherBag = (LongBag)source;
            otherBag.forEachWithOccurrences(new LongIntProcedure(){

                public void value(long each, int occurrences) {
                    LongHashBag.this.addOccurrences(each, occurrences);
                }
            });
        } else {
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                long each = iterator.next();
                this.add(each);
            }
        }
        return true;
    }

    public boolean removeAll(long ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (long each : source) {
            int occurrences = this.items.removeKeyIfAbsent(each, 0);
            this.size -= occurrences;
        }
        return this.size() != oldSize;
    }

    public boolean removeAll(LongIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof LongBag) {
            LongBag otherBag = (LongBag)source;
            otherBag.forEachWithOccurrences(new LongIntProcedure(){

                public void value(long each, int occurrences) {
                    int oldOccurrences = LongHashBag.this.items.removeKeyIfAbsent(each, 0);
                    LongHashBag.this.size -= oldOccurrences;
                }
            });
        } else {
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                long each = iterator.next();
                int occurrences = this.items.removeKeyIfAbsent(each, 0);
                this.size -= occurrences;
            }
        }
        return this.size() != oldSize;
    }

    public void addOccurrences(long item, final int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot add a negative number of occurrences");
        }
        if (occurrences > 0) {
            this.items.updateValue(item, 0, new IntToIntFunction(){

                public int valueOf(int intParameter) {
                    return intParameter + occurrences;
                }
            });
            this.size += occurrences;
        }
    }

    public boolean removeOccurrences(long item, final int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot remove a negative number of occurrences");
        }
        if (occurrences == 0) {
            return false;
        }
        int newValue = this.items.updateValue(item, 0, new IntToIntFunction(){

            public int valueOf(int intParameter) {
                return intParameter - occurrences;
            }
        });
        if (newValue <= 0) {
            this.size -= occurrences - newValue;
            this.items.removeKey(item);
            return newValue + occurrences != 0;
        }
        this.size -= occurrences;
        return true;
    }

    public void forEach(final LongProcedure procedure) {
        this.items.forEachKeyValue(new LongIntProcedure(){

            public void value(long key, int occurrences) {
                for (int i = 0; i < occurrences; ++i) {
                    procedure.value(key);
                }
            }
        });
    }

    public MutableLongBag select(final LongPredicate predicate) {
        final LongHashBag result = new LongHashBag();
        this.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long each, int occurrences) {
                if (predicate.accept(each)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result;
    }

    public MutableLongBag reject(final LongPredicate predicate) {
        final LongHashBag result = new LongHashBag();
        this.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long each, int occurrences) {
                if (!predicate.accept(each)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result;
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        LongIterator it = this.longIterator();
        while (it.hasNext()) {
            result = function.valueOf(result, it.next());
        }
        return result;
    }

    public boolean equals(Object otherBag) {
        if (otherBag == this) {
            return true;
        }
        if (!(otherBag instanceof LongBag)) {
            return false;
        }
        final LongBag bag = (LongBag)otherBag;
        if (this.sizeDistinct() != bag.sizeDistinct()) {
            return false;
        }
        return this.items.keysView().allSatisfy(new LongPredicate(){

            public boolean accept(long key) {
                return LongHashBag.this.occurrencesOf(key) == bag.occurrencesOf(key);
            }
        });
    }

    public int hashCode() {
        final Counter result = new Counter();
        this.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long eachItem, int occurrences) {
                result.add((int)(eachItem ^ eachItem >>> 32) ^ occurrences);
            }
        });
        return result.getCount();
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(final Appendable appendable, String start, final String separator, String end) {
        final boolean[] firstItem = new boolean[]{true};
        try {
            appendable.append(start);
            this.items.forEachKeyValue(new LongIntProcedure(){

                public void value(long each, int occurrences) {
                    try {
                        for (int i = 0; i < occurrences; ++i) {
                            if (!firstItem[0]) {
                                appendable.append(separator);
                            }
                            appendable.append(String.valueOf(each));
                            firstItem[0] = false;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int count(final LongPredicate predicate) {
        final Counter result = new Counter();
        this.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long each, int occurrences) {
                if (predicate.accept(each)) {
                    result.add(occurrences);
                }
            }
        });
        return result.getCount();
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.items.keysView().anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.items.keysView().allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.items.keysView().noneSatisfy(predicate);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.items.keysView().detectIfNone(predicate, ifNone);
    }

    public <V> MutableBag<V> collect(final LongToObjectFunction<? extends V> function) {
        final HashBag result = HashBag.newBag(this.items.size());
        this.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long each, int occurrences) {
                result.addOccurrences(function.valueOf(each), occurrences);
            }
        });
        return result;
    }

    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().max();
    }

    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().min();
    }

    public long sum() {
        final long[] result = new long[]{0L};
        this.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long each, int occurrences) {
                result[0] = result[0] + each * (long)occurrences;
            }
        });
        return result[0];
    }

    public long minIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public long maxIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        long[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            long first = sortedArray[middleIndex];
            long second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public long[] toArray() {
        final long[] array = new long[this.size()];
        final int[] index = new int[]{0};
        this.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long each, int occurrences) {
                for (int i = 0; i < occurrences; ++i) {
                    array[index[0]] = each;
                    index[0] = index[0] + 1;
                }
            }
        });
        return array;
    }

    public long[] toSortedArray() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableLongList toList() {
        return LongArrayList.newList((LongIterable)this);
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newList((LongIterable)this).sortThis();
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSet((LongIterable)this.items.keysView());
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBag((LongBag)this);
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public MutableLongBag asUnmodifiable() {
        return new UnmodifiableLongBag(this);
    }

    public MutableLongBag asSynchronized() {
        return new SynchronizedLongBag(this);
    }

    public ImmutableLongBag toImmutable() {
        return LongBags.immutable.withAll((LongIterable)this);
    }

    public LongIterator longIterator() {
        return new InternalIterator();
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.items.size());
        try {
            this.items.forEachKeyValue(new LongIntProcedure(){

                public void value(long each, int occurrences) {
                    try {
                        out.writeLong(each);
                        out.writeInt(occurrences);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        this.items = new LongIntHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.addOccurrences(in.readLong(), in.readInt());
        }
    }

    private class InternalIterator
    implements LongIterator {
        private final LongIterator longIterator;
        private long currentItem;
        private int occurrences;

        private InternalIterator() {
            this.longIterator = LongHashBag.this.items.keysView().longIterator();
        }

        public boolean hasNext() {
            return this.occurrences > 0 || this.longIterator.hasNext();
        }

        public long next() {
            if (this.occurrences == 0) {
                this.currentItem = this.longIterator.next();
                this.occurrences = LongHashBag.this.occurrencesOf(this.currentItem);
            }
            --this.occurrences;
            return this.currentItem;
        }
    }
}

