/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.block.factory;

import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.impl.block.function.PassThruFunction0;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Maps;
import com.gs.collections.impl.factory.Sets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Functions0 {
    private static final NewFastListFunction<?> NEW_FAST_LIST_FUNCTION = new NewFastListFunction();
    private static final NewUnifiedSetFunction<?> NEW_UNIFIED_SET_FUNCTION = new NewUnifiedSetFunction();
    private static final NewHashBagFunction<?> NEW_HASH_BAG_FUNCTION = new NewHashBagFunction();
    private static final NewUnifiedMapFunction<?, ?> NEW_UNIFIED_MAP_FUNCTION = new NewUnifiedMapFunction();
    private static final NullFunction<?> NULL_FUNCTION = new NullFunction();

    private Functions0() {
    }

    public static <T> Function0<MutableList<T>> newFastList() {
        return NEW_FAST_LIST_FUNCTION;
    }

    public static <T> Function0<MutableSet<T>> newUnifiedSet() {
        return NEW_UNIFIED_SET_FUNCTION;
    }

    public static <T> Function0<MutableBag<T>> newHashBag() {
        return NEW_HASH_BAG_FUNCTION;
    }

    public static <K, V> Function0<MutableMap<K, V>> newUnifiedMap() {
        return NEW_UNIFIED_MAP_FUNCTION;
    }

    public static <T> Function0<T> nullValue() {
        return NULL_FUNCTION;
    }

    public static <T> Function0<T> value(T t) {
        return new PassThruFunction0<T>(t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullFunction<T>
    implements Function0<T> {
        private static final long serialVersionUID = 1L;

        private NullFunction() {
        }

        public T value() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NewHashBagFunction<T>
    implements Function0<MutableBag<T>> {
        private static final long serialVersionUID = 1L;

        private NewHashBagFunction() {
        }

        public MutableBag<T> value() {
            return Bags.mutable.of();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NewUnifiedSetFunction<T>
    implements Function0<MutableSet<T>> {
        private static final long serialVersionUID = 1L;

        private NewUnifiedSetFunction() {
        }

        public MutableSet<T> value() {
            return Sets.mutable.of();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NewUnifiedMapFunction<K, V>
    implements Function0<MutableMap<K, V>> {
        private static final long serialVersionUID = 1L;

        private NewUnifiedMapFunction() {
        }

        public MutableMap<K, V> value() {
            return Maps.mutable.of();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NewFastListFunction<T>
    implements Function0<MutableList<T>> {
        private static final long serialVersionUID = 1L;

        private NewFastListFunction() {
        }

        public MutableList<T> value() {
            return Lists.mutable.of();
        }
    }
}

