/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.iterator;

import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.tuple.Tuples;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZipWithIndexIterator<T>
implements Iterator<Pair<T, Integer>> {
    private final Iterator<T> iterator;
    private int index = 0;

    public ZipWithIndexIterator(Iterable<T> iterable) {
        this.iterator = iterable.iterator();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a collect iterator");
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<T, Integer> next() {
        try {
            Pair<T, Integer> pair = Tuples.pair(this.iterator.next(), this.index);
            return pair;
        }
        finally {
            ++this.index;
        }
    }
}

