/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable;

import com.gs.collections.api.factory.map.ImmutableMapFactory;
import com.gs.collections.api.map.ImmutableMap;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.map.immutable.ImmutableDoubletonMap;
import com.gs.collections.impl.map.immutable.ImmutableEmptyMap;
import com.gs.collections.impl.map.immutable.ImmutableSingletonMap;
import com.gs.collections.impl.map.immutable.ImmutableTripletonMap;
import com.gs.collections.impl.map.immutable.ImmutableUnifiedMap;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class ImmutableMapFactoryImpl
implements ImmutableMapFactory {
    public <K, V> ImmutableMap<K, V> of() {
        return this.with();
    }

    public <K, V> ImmutableMap<K, V> with() {
        return ImmutableEmptyMap.INSTANCE;
    }

    public <K, V> ImmutableMap<K, V> of(K key, V value) {
        return this.with(key, value);
    }

    public <K, V> ImmutableMap<K, V> with(K key, V value) {
        return new ImmutableSingletonMap<K, V>(key, value);
    }

    public <K, V> ImmutableMap<K, V> of(K key1, V value1, K key2, V value2) {
        return this.with(key1, value1, key2, value2);
    }

    public <K, V> ImmutableMap<K, V> with(K key1, V value1, K key2, V value2) {
        if (Comparators.nullSafeEquals(key1, key2)) {
            return this.of(key1, value2);
        }
        return new ImmutableDoubletonMap<K, V>(key1, value1, key2, value2);
    }

    public <K, V> ImmutableMap<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3) {
        return this.with(key1, value1, key2, value2, key3, value3);
    }

    public <K, V> ImmutableMap<K, V> with(K key1, V value1, K key2, V value2, K key3, V value3) {
        if (Comparators.nullSafeEquals(key1, key2) && Comparators.nullSafeEquals(key2, key3)) {
            return this.of(key1, value3);
        }
        if (Comparators.nullSafeEquals(key1, key2)) {
            return this.of(key1, value2, key3, value3);
        }
        if (Comparators.nullSafeEquals(key1, key3)) {
            return this.of(key2, value2, key1, value3);
        }
        if (Comparators.nullSafeEquals(key2, key3)) {
            return this.of(key1, value1, key2, value3);
        }
        return new ImmutableTripletonMap<K, V>(key1, value1, key2, value2, key3, value3);
    }

    public <K, V> ImmutableMap<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        return this.with(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public <K, V> ImmutableMap<K, V> with(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        return UnifiedMap.newWithKeysValues(key1, value1, key2, value2, key3, value3, key4, value4).toImmutable();
    }

    @Deprecated
    public <K, V> ImmutableMap<K, V> ofMap(Map<K, V> map) {
        return this.ofAll(map);
    }

    public <K, V> ImmutableMap<K, V> ofAll(Map<K, V> map) {
        return this.withAll(map);
    }

    public <K, V> ImmutableMap<K, V> withAll(Map<K, V> map) {
        if (map.isEmpty()) {
            return this.of();
        }
        if (map.size() > 3) {
            return new ImmutableUnifiedMap<K, V>(map);
        }
        Map.Entry[] entries = map.entrySet().toArray(new Map.Entry[map.entrySet().size()]);
        switch (entries.length) {
            case 1: {
                return this.of(entries[0].getKey(), entries[0].getValue());
            }
            case 2: {
                return this.of(entries[0].getKey(), entries[0].getValue(), entries[1].getKey(), entries[1].getValue());
            }
            case 3: {
                return this.of(entries[0].getKey(), entries[0].getValue(), entries[1].getKey(), entries[1].getValue(), entries[2].getKey(), entries[2].getValue());
            }
        }
        throw new AssertionError();
    }
}

