/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable;

import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.map.ImmutableMap;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Maps;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.map.immutable.AbstractImmutableMap;
import com.gs.collections.impl.tuple.Tuples;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableSingletonMap<K, V>
extends AbstractImmutableMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final K key1;
    private final V value1;

    ImmutableSingletonMap(K key1, V value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public int size() {
        return 1;
    }

    public RichIterable<K> keysView() {
        return Lists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<V> valuesView() {
        return Lists.immutable.of(this.value1).asLazy();
    }

    public RichIterable<Pair<K, V>> keyValuesView() {
        return Lists.immutable.of(Tuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public boolean containsKey(Object key) {
        return Comparators.nullSafeEquals(this.key1, key);
    }

    @Override
    public boolean containsValue(Object value) {
        return Comparators.nullSafeEquals(this.value1, value);
    }

    @Override
    public V get(Object key) {
        if (Comparators.nullSafeEquals(this.key1, key)) {
            return this.value1;
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        return Sets.immutable.of(this.key1).castToSet();
    }

    @Override
    public Collection<V> values() {
        return Lists.immutable.of(this.value1).castToList();
    }

    public String toString() {
        return "{" + this.key1 + '=' + this.value1 + '}';
    }

    @Override
    public int hashCode() {
        return this.keyAndValueHashCode(this.key1, this.value1);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Map)) {
            return false;
        }
        Map that = (Map)other;
        return that.size() == this.size() && this.keyAndValueEquals(this.key1, this.value1, that);
    }

    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure) {
        procedure.value(this.key1, this.value1);
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachValue(Procedure<? super V> procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        objectIntProcedure.value(this.value1, 0);
    }

    @Override
    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        procedure.value(this.value1, parameter);
    }

    @Override
    public ImmutableMap<K, V> select(Predicate2<? super K, ? super V> predicate) {
        if (predicate.accept(this.key1, this.value1)) {
            return this;
        }
        return Maps.immutable.of();
    }

    @Override
    public ImmutableMap<K, V> reject(Predicate2<? super K, ? super V> predicate) {
        if (predicate.accept(this.key1, this.value1)) {
            return Maps.immutable.of();
        }
        return this;
    }

    @Override
    public <K2, V2> ImmutableMap<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        Pair pair = (Pair)function.value(this.key1, this.value1);
        return Maps.immutable.of(pair.getOne(), pair.getTwo());
    }

    @Override
    public <R> ImmutableMap<K, R> collectValues(Function2<? super K, ? super V, ? extends R> function) {
        return Maps.immutable.of(this.key1, function.value(this.key1, this.value1));
    }

    @Override
    public Pair<K, V> detect(Predicate2<? super K, ? super V> predicate) {
        if (predicate.accept(this.key1, this.value1)) {
            return Tuples.pair(this.key1, this.value1);
        }
        return null;
    }

    private Object writeReplace() {
        return new AbstractImmutableMap.ImmutableMapSerializationProxy(this);
    }
}

