/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.DoubleBooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.map.primitive.DoubleBooleanMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleBooleanMap;
import com.gs.collections.api.map.primitive.MutableDoubleBooleanMap;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedDoubleBooleanProcedure;
import com.gs.collections.impl.map.mutable.primitive.DoubleBooleanHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableDoubleBooleanHashMap
implements ImmutableDoubleBooleanMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleBooleanMap delegate;

    ImmutableDoubleBooleanHashMap(DoubleBooleanMap delegate) {
        this.delegate = new DoubleBooleanHashMap(delegate);
    }

    public boolean get(double key) {
        return this.delegate.get(key);
    }

    public boolean getIfAbsent(double key, boolean ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean getOrThrow(double key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(double key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(boolean value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(BooleanProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleBooleanProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyDoubleIterable keysView() {
        return this.delegate.keysView();
    }

    public ImmutableDoubleBooleanMap select(DoubleBooleanPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleBooleanMap reject(DoubleBooleanPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public ImmutableDoubleBooleanMap toImmutable() {
        return this;
    }

    public BooleanIterator booleanIterator() {
        return this.delegate.booleanIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(BooleanPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableBooleanCollection select(BooleanPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableBooleanCollection reject(BooleanPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public boolean[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(boolean value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(boolean ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(BooleanIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableBooleanList toList() {
        return this.delegate.toList();
    }

    public MutableBooleanSet toSet() {
        return this.delegate.toSet();
    }

    public MutableBooleanBag toBag() {
        return this.delegate.toBag();
    }

    public LazyBooleanIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableDoubleBooleanMap newWithKeyValue(double key, boolean value) {
        DoubleBooleanHashMap map = new DoubleBooleanHashMap(this.size() + 1);
        map.putAll((DoubleBooleanMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableDoubleBooleanMap newWithoutKey(double key) {
        DoubleBooleanHashMap map = new DoubleBooleanHashMap(this.size());
        map.putAll((DoubleBooleanMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableDoubleBooleanMap newWithoutAllKeys(DoubleIterable keys) {
        DoubleBooleanHashMap map = new DoubleBooleanHashMap(this.size());
        map.putAll((DoubleBooleanMap)this);
        DoubleIterator iterator = keys.doubleIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableDoubleSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableBooleanCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableDoubleBooleanMapSerializationProxy((DoubleBooleanMap)this);
    }

    protected static class ImmutableDoubleBooleanMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private DoubleBooleanMap map;

        public ImmutableDoubleBooleanMapSerializationProxy() {
        }

        protected ImmutableDoubleBooleanMapSerializationProxy(DoubleBooleanMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((DoubleBooleanProcedure)new CheckedDoubleBooleanProcedure(){

                    public void safeValue(double key, boolean value) throws IOException {
                        out.writeDouble(key);
                        out.writeBoolean(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            DoubleBooleanHashMap deserializedMap = new DoubleBooleanHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readDouble(), in.readBoolean());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

