/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.LongCharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.LongCharProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.ImmutableLongCharMap;
import com.gs.collections.api.map.primitive.LongCharMap;
import com.gs.collections.api.map.primitive.MutableLongCharMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedLongCharProcedure;
import com.gs.collections.impl.map.mutable.primitive.LongCharHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableLongCharHashMap
implements ImmutableLongCharMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongCharMap delegate;

    ImmutableLongCharHashMap(LongCharMap delegate) {
        this.delegate = new LongCharHashMap(delegate);
    }

    public char get(long key) {
        return this.delegate.get(key);
    }

    public char getIfAbsent(long key, char ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public char getOrThrow(long key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(char value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(CharProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(LongCharProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyLongIterable keysView() {
        return this.delegate.keysView();
    }

    public ImmutableLongCharMap select(LongCharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongCharMap reject(LongCharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public ImmutableLongCharMap toImmutable() {
        return this;
    }

    public CharIterator charIterator() {
        return this.delegate.charIterator();
    }

    public void forEach(CharProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(CharPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableCharCollection select(CharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableCharCollection reject(CharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum() {
        return this.delegate.sum();
    }

    public char max() {
        return this.delegate.max();
    }

    public char maxIfEmpty(char defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public char min() {
        return this.delegate.min();
    }

    public char minIfEmpty(char defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public char[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableCharList toSortedList() {
        return this.delegate.toSortedList();
    }

    public char[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(char value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(char ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(CharIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableCharList toList() {
        return this.delegate.toList();
    }

    public MutableCharSet toSet() {
        return this.delegate.toSet();
    }

    public MutableCharBag toBag() {
        return this.delegate.toBag();
    }

    public LazyCharIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableLongCharMap newWithKeyValue(long key, char value) {
        LongCharHashMap map = new LongCharHashMap(this.size() + 1);
        map.putAll((LongCharMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableLongCharMap newWithoutKey(long key) {
        LongCharHashMap map = new LongCharHashMap(this.size());
        map.putAll((LongCharMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableLongCharMap newWithoutAllKeys(LongIterable keys) {
        LongCharHashMap map = new LongCharHashMap(this.size());
        map.putAll((LongCharMap)this);
        LongIterator iterator = keys.longIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableLongSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableCharCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableLongCharMapSerializationProxy((LongCharMap)this);
    }

    protected static class ImmutableLongCharMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private LongCharMap map;

        public ImmutableLongCharMapSerializationProxy() {
        }

        protected ImmutableLongCharMapSerializationProxy(LongCharMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((LongCharProcedure)new CheckedLongCharProcedure(){

                    public void safeValue(long key, char value) throws IOException {
                        out.writeLong(key);
                        out.writeChar(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            LongCharHashMap deserializedMap = new LongCharHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readLong(), in.readChar());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

