/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectIntPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.ImmutableObjectIntMap;
import com.gs.collections.api.map.primitive.MutableObjectIntMap;
import com.gs.collections.api.map.primitive.ObjectIntMap;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.map.immutable.primitive.AbstractImmutableObjectIntMap;
import com.gs.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableObjectIntHashMap<K>
extends AbstractImmutableObjectIntMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectIntMap<K> delegate;

    ImmutableObjectIntHashMap(ObjectIntMap<? extends K> delegate) {
        this.delegate = new ObjectIntHashMap<K>(delegate);
    }

    public IntIterator intIterator() {
        return this.delegate.intIterator();
    }

    public void forEach(IntProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(IntPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableIntCollection select(IntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntCollection reject(IntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum() {
        return this.delegate.sum();
    }

    public int max() {
        return this.delegate.max();
    }

    public int maxIfEmpty(int defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public int min() {
        return this.delegate.min();
    }

    public int minIfEmpty(int defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public int[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableIntList toSortedList() {
        return this.delegate.toSortedList();
    }

    public int[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(int value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableIntList toList() {
        return this.delegate.toList();
    }

    public MutableIntSet toSet() {
        return this.delegate.toSet();
    }

    public MutableIntBag toBag() {
        return this.delegate.toBag();
    }

    public LazyIntIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableObjectIntMap<K> newWithKeyValue(K key, int value) {
        ObjectIntHashMap<K> map = ObjectIntHashMap.newMap();
        map.putAll((ObjectIntMap<K>)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableObjectIntMap<K> newWithoutKey(K key) {
        ObjectIntHashMap<K> map = ObjectIntHashMap.newMap();
        map.putAll((ObjectIntMap<K>)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableObjectIntMap<K> newWithoutAllKeys(Iterable<? extends K> keys) {
        ObjectIntHashMap<K> map = ObjectIntHashMap.newMap();
        map.putAll((ObjectIntMap<K>)this);
        Iterator<K> iterator = keys.iterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int get(Object key) {
        return this.delegate.get(key);
    }

    public int getOrThrow(Object key) {
        return this.delegate.getOrThrow(key);
    }

    public int getIfAbsent(Object key, int ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(int value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(IntProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectIntProcedure<? super K> objectIntProcedure) {
        this.delegate.forEachKeyValue(objectIntProcedure);
    }

    public ImmutableObjectIntMap<K> select(ObjectIntPredicate<? super K> objectIntPredicate) {
        return this.delegate.select(objectIntPredicate).toImmutable();
    }

    public ImmutableObjectIntMap<K> reject(ObjectIntPredicate<? super K> objectIntPredicate) {
        return this.delegate.reject(objectIntPredicate).toImmutable();
    }

    public ImmutableObjectIntMap<K> toImmutable() {
        return this;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public Set<K> keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableIntCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectIntMap.ImmutableObjectIntMapSerializationProxy(this);
    }
}

