/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToFloatFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortFloatPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.ImmutableShortFloatMap;
import com.gs.collections.api.map.primitive.MutableShortFloatMap;
import com.gs.collections.api.map.primitive.ShortFloatMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableShortSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.block.factory.primitive.ShortPredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedFloatCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.factory.primitive.ShortFloatMaps;
import com.gs.collections.impl.factory.primitive.ShortSets;
import com.gs.collections.impl.lazy.primitive.CollectShortToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectShortIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedShortFloatMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableShortFloatMap;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedShortSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortFloatHashMap
implements MutableShortFloatMap,
Externalizable {
    static final float EMPTY_VALUE = 0.0f;
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_KEY = 0;
    private static final short REMOVED_KEY = 1;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private short[] keys;
    private float[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public ShortFloatHashMap() {
        this.allocateTable(16);
    }

    public ShortFloatHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public ShortFloatHashMap(ShortFloatMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static ShortFloatHashMap newWithKeysValues(short key1, float value1) {
        return new ShortFloatHashMap(1).withKeyValue(key1, value1);
    }

    public static ShortFloatHashMap newWithKeysValues(short key1, float value1, short key2, float value2) {
        return new ShortFloatHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ShortFloatHashMap newWithKeysValues(short key1, float value1, short key2, float value2, short key3, float value3) {
        return new ShortFloatHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ShortFloatHashMap newWithKeysValues(short key1, float value1, short key2, float value2, short key3, float value3, short key4, float value4) {
        return new ShortFloatHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortFloatMap)) {
            return false;
        }
        ShortFloatMap other = (ShortFloatMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((short)0) || other.containsKey((short)1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey((short)0) || Float.compare(this.sentinelValues.zeroValue, other.getOrThrow((short)0)) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey((short)1) || Float.compare(this.sentinelValues.oneValue, other.getOrThrow((short)1)) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            short key = this.keys[i];
            if (!ShortFloatHashMap.isNonSentinel(key) || other.containsKey(key) && Float.compare(this.values[i], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ Float.floatToIntBits(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ Float.floatToIntBits(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ Float.floatToIntBits(this.values[i]);
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                short key = this.keys[i];
                if (!ShortFloatHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FloatIterator floatIterator() {
        return new InternalFloatIterator();
    }

    public float[] toArray() {
        float[] array = new float[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(float value) {
        return this.containsValue(value);
    }

    public boolean containsAll(float ... source) {
        for (float each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(FloatIterable source) {
        return source.allSatisfy(new FloatPredicate(){

            public boolean accept(float value) {
                return ShortFloatHashMap.this.contains(value);
            }
        });
    }

    public void forEach(FloatProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableFloatCollection select(FloatPredicate predicate) {
        FloatArrayList result = new FloatArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableFloatCollection reject(FloatPredicate predicate) {
        FloatArrayList result = new FloatArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public float detectIfNone(FloatPredicate predicate, float value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(FloatPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectFloatToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableFloatList toList() {
        return FloatArrayList.newList((FloatIterable)this);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSet((FloatIterable)this);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBag((FloatIterable)this);
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, (short)0);
        Arrays.fill(this.values, 0.0f);
    }

    public void put(short key, float value) {
        if (ShortFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (ShortFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(ShortFloatMap map) {
        map.forEachKeyValue(new ShortFloatProcedure(){

            public void value(short key, float value) {
                ShortFloatHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(short key) {
        if (ShortFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0.0f;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (ShortFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0.0f;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            this.values[index] = 0.0f;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(short key) {
        this.removeKey(key);
    }

    public float removeKeyIfAbsent(short key, float value) {
        if (ShortFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            float oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0.0f;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (ShortFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            float oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0.0f;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            float oldValue = this.values[index];
            this.values[index] = 0.0f;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public float getIfAbsentPut(short key, float value) {
        if (ShortFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (ShortFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public float getIfAbsentPut(short key, FloatFunction0 function) {
        float value;
        if (ShortFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ShortFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> float getIfAbsentPutWith(short key, FloatFunction<? super P> function, P parameter) {
        float value;
        if (ShortFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value2 = function.floatValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value3 = function.floatValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ShortFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value4 = function.floatValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value5 = function.floatValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.floatValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public float getIfAbsentPutWithKey(short key, ShortToFloatFunction function) {
        float value;
        if (ShortFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ShortFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public float updateValue(short key, float initialValueIfAbsent, FloatToFloatFunction function) {
        float value;
        if (ShortFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public ShortFloatHashMap withKeyValue(short key1, float value1) {
        this.put(key1, value1);
        return this;
    }

    public ShortFloatHashMap withKeysValues(short key1, float value1, short key2, float value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ShortFloatHashMap withKeysValues(short key1, float value1, short key2, float value2, short key3, float value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ShortFloatHashMap withKeysValues(short key1, float value1, short key2, float value2, short key3, float value3, short key4, float value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ShortFloatHashMap withoutKey(short key) {
        this.removeKey(key);
        return this;
    }

    public ShortFloatHashMap withoutAllKeys(ShortIterable keys) {
        keys.forEach(new ShortProcedure(){

            public void value(short key) {
                ShortFloatHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableShortFloatMap asUnmodifiable() {
        return new UnmodifiableShortFloatMap(this);
    }

    public MutableShortFloatMap asSynchronized() {
        return new SynchronizedShortFloatMap(this);
    }

    public ImmutableShortFloatMap toImmutable() {
        return ShortFloatMaps.immutable.ofAll((ShortFloatMap)this);
    }

    public float get(short key) {
        return this.getIfAbsent(key, 0.0f);
    }

    public float getIfAbsent(short key, float ifAbsent) {
        if (ShortFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public float getOrThrow(short key) {
        if (ShortFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (ShortFloatHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(short key) {
        if (ShortFloatHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (ShortFloatHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(float value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i]) || Float.compare(this.values[i], value) != 0) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(FloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(ShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1);
            }
        }
        for (short key : this.keys) {
            if (!ShortFloatHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(ShortFloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyShortIterable keysView() {
        return new KeysView();
    }

    public ShortFloatHashMap select(ShortFloatPredicate predicate) {
        ShortFloatHashMap result = new ShortFloatHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public ShortFloatHashMap reject(ShortFloatPredicate predicate) {
        ShortFloatHashMap result = new ShortFloatHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public double sum() {
        double result = 0.0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (double)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (double)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result += (double)this.values[i];
        }
        return result;
    }

    public float max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        FloatIterator iterator = this.floatIterator();
        float max = iterator.next();
        while (iterator.hasNext()) {
            float value = iterator.next();
            if (Float.compare(max, value) >= 0) continue;
            max = value;
        }
        return max;
    }

    public float maxIfEmpty(float defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public float min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        FloatIterator iterator = this.floatIterator();
        float min = iterator.next();
        while (iterator.hasNext()) {
            float value = iterator.next();
            if (Float.compare(value, min) >= 0) continue;
            min = value;
        }
        return min;
    }

    public float minIfEmpty(float defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        float[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            float first = sortedArray[middleIndex];
            float second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public float[] toSortedArray() {
        float[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newList((FloatIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeShort(0);
                out.writeFloat(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeShort(1);
                out.writeFloat(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeShort(this.keys[i]);
            out.writeFloat(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readShort(), in.readFloat());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        short[] old = this.keys;
        float[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ShortFloatHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(short element) {
        int index = this.spread(element);
        short keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(short element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new short[sizeToAllocate];
        this.values = new float[sizeToAllocate];
    }

    private static boolean isEmptyKey(short key) {
        return key == 0;
    }

    private static boolean isRemovedKey(short key) {
        return key == 1;
    }

    private static boolean isNonSentinel(short key) {
        return !ShortFloatHashMap.isEmptyKey(key) && !ShortFloatHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableShortSet keySet() {
        return new KeySet();
    }

    public MutableFloatCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableFloatCollection {
        private ValuesCollection() {
        }

        public void clear() {
            ShortFloatHashMap.this.clear();
        }

        public MutableFloatCollection select(FloatPredicate predicate) {
            return ShortFloatHashMap.this.select(predicate);
        }

        public MutableFloatCollection reject(FloatPredicate predicate) {
            return ShortFloatHashMap.this.reject(predicate);
        }

        public float detectIfNone(FloatPredicate predicate, float ifNone) {
            return ShortFloatHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
            return ShortFloatHashMap.this.collect(function);
        }

        public double sum() {
            return ShortFloatHashMap.this.sum();
        }

        public float max() {
            return ShortFloatHashMap.this.max();
        }

        public float maxIfEmpty(float defaultValue) {
            return ShortFloatHashMap.this.maxIfEmpty(defaultValue);
        }

        public float min() {
            return ShortFloatHashMap.this.min();
        }

        public float minIfEmpty(float defaultValue) {
            return ShortFloatHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return ShortFloatHashMap.this.average();
        }

        public double median() {
            return ShortFloatHashMap.this.median();
        }

        public float[] toSortedArray() {
            return ShortFloatHashMap.this.toSortedArray();
        }

        public MutableFloatList toSortedList() {
            return ShortFloatHashMap.this.toSortedList();
        }

        public MutableFloatCollection with(float element) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatCollection without(float element) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatCollection withAll(FloatIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatCollection withoutAll(FloatIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatCollection asUnmodifiable() {
            return UnmodifiableFloatCollection.of(this);
        }

        public MutableFloatCollection asSynchronized() {
            return SynchronizedFloatCollection.of(this);
        }

        public ImmutableFloatCollection toImmutable() {
            return FloatLists.immutable.withAll((FloatIterable)this);
        }

        public boolean contains(float value) {
            return ShortFloatHashMap.this.containsValue(value);
        }

        public boolean containsAll(float ... source) {
            return ShortFloatHashMap.this.containsAll(source);
        }

        public boolean containsAll(FloatIterable source) {
            return ShortFloatHashMap.this.containsAll(source);
        }

        public MutableFloatList toList() {
            return ShortFloatHashMap.this.toList();
        }

        public MutableFloatSet toSet() {
            return ShortFloatHashMap.this.toSet();
        }

        public MutableFloatBag toBag() {
            return ShortFloatHashMap.this.toBag();
        }

        public LazyFloatIterable asLazy() {
            return new LazyFloatIterableAdapter((FloatIterable)this);
        }

        public boolean isEmpty() {
            return ShortFloatHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ShortFloatHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ShortFloatHashMap.this.sentinelValues != null) {
                    if (ShortFloatHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(ShortFloatHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (ShortFloatHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(ShortFloatHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < ShortFloatHashMap.this.keys.length; ++i) {
                    short key = ShortFloatHashMap.this.keys[i];
                    if (!ShortFloatHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ShortFloatHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public FloatIterator floatIterator() {
            return ShortFloatHashMap.this.floatIterator();
        }

        public void forEach(FloatProcedure procedure) {
            ShortFloatHashMap.this.forEach(procedure);
        }

        public int count(FloatPredicate predicate) {
            return ShortFloatHashMap.this.count(predicate);
        }

        public boolean anySatisfy(FloatPredicate predicate) {
            return ShortFloatHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(FloatPredicate predicate) {
            return ShortFloatHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(FloatPredicate predicate) {
            return ShortFloatHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(float element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(float ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(FloatIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(float item) {
            int oldSize = ShortFloatHashMap.this.size();
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey && Float.compare(item, ShortFloatHashMap.this.sentinelValues.zeroValue) == 0) {
                    ShortFloatHashMap.this.removeKey((short)0);
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && Float.compare(item, ShortFloatHashMap.this.sentinelValues.oneValue) == 0) {
                    ShortFloatHashMap.this.removeKey((short)1);
                }
            }
            for (int i = 0; i < ShortFloatHashMap.this.keys.length; ++i) {
                if (!ShortFloatHashMap.isNonSentinel(ShortFloatHashMap.this.keys[i]) || Float.compare(item, ShortFloatHashMap.this.values[i]) != 0) continue;
                ShortFloatHashMap.this.removeKey(ShortFloatHashMap.this.keys[i]);
            }
            return oldSize != ShortFloatHashMap.this.size();
        }

        public boolean removeAll(FloatIterable source) {
            int oldSize = ShortFloatHashMap.this.size();
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ShortFloatHashMap.this.size();
        }

        public boolean removeAll(float ... source) {
            int oldSize = ShortFloatHashMap.this.size();
            for (float item : source) {
                this.remove(item);
            }
            return oldSize != ShortFloatHashMap.this.size();
        }

        public int size() {
            return ShortFloatHashMap.this.size();
        }

        public float[] toArray() {
            return ShortFloatHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableShortSet {
        private KeySet() {
        }

        public ShortIterator shortIterator() {
            return new KeySetIterator();
        }

        public void forEach(ShortProcedure procedure) {
            ShortFloatHashMap.this.forEachKey(procedure);
        }

        public int count(ShortPredicate predicate) {
            int count = 0;
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    ++count;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    ++count;
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(ShortPredicate predicate) {
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return true;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return true;
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(ShortPredicate predicate) {
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((short)0)) {
                    return false;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && !predicate.accept((short)1)) {
                    return false;
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(ShortPredicate predicate) {
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return false;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return false;
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(short element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(short ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ShortIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(short key) {
            int oldSize = ShortFloatHashMap.this.size();
            ShortFloatHashMap.this.removeKey(key);
            return oldSize != ShortFloatHashMap.this.size();
        }

        public boolean removeAll(ShortIterable source) {
            int oldSize = ShortFloatHashMap.this.size();
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                ShortFloatHashMap.this.removeKey(iterator.next());
            }
            return oldSize != ShortFloatHashMap.this.size();
        }

        public boolean removeAll(short ... source) {
            int oldSize = ShortFloatHashMap.this.size();
            for (short item : source) {
                ShortFloatHashMap.this.removeKey(item);
            }
            return oldSize != ShortFloatHashMap.this.size();
        }

        public void clear() {
            ShortFloatHashMap.this.clear();
        }

        public MutableShortSet select(ShortPredicate predicate) {
            ShortHashSet result = new ShortHashSet();
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    result.add((short)0);
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    result.add((short)1);
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableShortSet reject(ShortPredicate predicate) {
            ShortHashSet result = new ShortHashSet();
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((short)0)) {
                    result.add((short)0);
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && !predicate.accept((short)1)) {
                    result.add((short)1);
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableShortSet with(short element) {
            throw new UnsupportedOperationException();
        }

        public MutableShortSet without(short element) {
            throw new UnsupportedOperationException();
        }

        public MutableShortSet withAll(ShortIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableShortSet withoutAll(ShortIterable elements) {
            throw new UnsupportedOperationException();
        }

        public short detectIfNone(ShortPredicate predicate, short ifNone) {
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return 0;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return 1;
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf((short)0));
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf((short)1));
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableShortSet asUnmodifiable() {
            return UnmodifiableShortSet.of(this);
        }

        public MutableShortSet asSynchronized() {
            return SynchronizedShortSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public short max() {
            if (ShortFloatHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            short max = 0;
            boolean isMaxSet = false;
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0;
                    isMaxSet = true;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1)) {
                    max = 1;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < ShortFloatHashMap.this.keys.length; ++i) {
                if (!ShortFloatHashMap.isNonSentinel(ShortFloatHashMap.this.keys[i]) || isMaxSet && max >= ShortFloatHashMap.this.keys[i]) continue;
                max = ShortFloatHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public short maxIfEmpty(short defaultValue) {
            if (ShortFloatHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public short min() {
            if (ShortFloatHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            short min = 0;
            boolean isMinSet = false;
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0;
                    isMinSet = true;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1 < min)) {
                    min = 1;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < ShortFloatHashMap.this.keys.length; ++i) {
                if (!ShortFloatHashMap.isNonSentinel(ShortFloatHashMap.this.keys[i]) || isMinSet && ShortFloatHashMap.this.keys[i] >= min) continue;
                min = ShortFloatHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public short minIfEmpty(short defaultValue) {
            if (ShortFloatHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            short[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                short first = sortedArray[middleIndex];
                short second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public short[] toSortedArray() {
            short[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableShortList toSortedList() {
            return ShortArrayList.newList((ShortIterable)this).sortThis();
        }

        public short[] toArray() {
            int size = ShortFloatHashMap.this.size();
            final short[] result = new short[size];
            ShortFloatHashMap.this.forEachKey(new ShortProcedure(){
                private int index;

                public void value(short each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(short value) {
            return ShortFloatHashMap.this.containsKey(value);
        }

        public boolean containsAll(short ... source) {
            for (short item : source) {
                if (ShortFloatHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ShortIterable source) {
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                if (ShortFloatHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableShortList toList() {
            return ShortArrayList.newList((ShortIterable)this);
        }

        public MutableShortSet toSet() {
            return ShortHashSet.newSet((ShortIterable)this);
        }

        public MutableShortBag toBag() {
            return ShortHashBag.newBag((ShortIterable)this);
        }

        public LazyShortIterable asLazy() {
            return new LazyShortIterableAdapter((ShortIterable)this);
        }

        public ShortSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableShortSet toImmutable() {
            return ShortSets.immutable.withAll((ShortIterable)this);
        }

        public int size() {
            return ShortFloatHashMap.this.size();
        }

        public boolean isEmpty() {
            return ShortFloatHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ShortFloatHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ShortSet)) {
                return false;
            }
            ShortSet other = (ShortSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < ShortFloatHashMap.this.keys.length; ++i) {
                if (!ShortFloatHashMap.isNonSentinel(ShortFloatHashMap.this.keys[i])) continue;
                result += ShortFloatHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ShortFloatHashMap.this.sentinelValues != null) {
                    if (ShortFloatHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ShortFloatHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (short key : ShortFloatHashMap.this.keys) {
                    if (!ShortFloatHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements ShortIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < ShortFloatHashMap.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortFloatHashMap.this.containsKey((short)0)) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortFloatHashMap.this.containsKey((short)1)) {
                    return 1;
                }
            }
            short[] keys = ShortFloatHashMap.this.keys;
            while (!ShortFloatHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            short result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyShortIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return ShortFloatHashMap.this.size();
        }

        public boolean isEmpty() {
            return ShortFloatHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ShortFloatHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ShortFloatHashMap.this.sentinelValues != null) {
                    if (ShortFloatHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ShortFloatHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (short key : ShortFloatHashMap.this.keys) {
                    if (!ShortFloatHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ShortIterator shortIterator() {
            return new KeySetIterator();
        }

        public boolean contains(short key) {
            return ShortFloatHashMap.this.containsKey(key);
        }

        public boolean containsAll(short ... keys) {
            for (short key : keys) {
                if (ShortFloatHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ShortIterable source) {
            return source.allSatisfy(new ShortPredicate(){

                public boolean accept(short key) {
                    return ShortFloatHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(ShortProcedure procedure) {
            ShortFloatHashMap.this.forEachKey(procedure);
        }

        public int count(ShortPredicate predicate) {
            int count = 0;
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    ++count;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    ++count;
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(ShortPredicate predicate) {
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return true;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return true;
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(ShortPredicate predicate) {
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((short)0)) {
                    return false;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && !predicate.accept((short)1)) {
                    return false;
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(ShortPredicate predicate) {
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return false;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return false;
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyShortIterable select(ShortPredicate predicate) {
            return new SelectShortIterable((ShortIterable)this, predicate);
        }

        public LazyShortIterable reject(ShortPredicate predicate) {
            return new SelectShortIterable((ShortIterable)this, ShortPredicates.not(predicate));
        }

        public short detectIfNone(ShortPredicate predicate, short value) {
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return 0;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return 1;
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(ShortToObjectFunction<? extends V> function) {
            return new CollectShortToObjectIterable<V>((ShortIterable)this, function);
        }

        public long sum() {
            long result = 0L;
            if (ShortFloatHashMap.this.sentinelValues != null) {
                if (ShortFloatHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (ShortFloatHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (short key : ShortFloatHashMap.this.keys) {
                if (!ShortFloatHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        public short max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            ShortIterator iterator = this.shortIterator();
            short max = iterator.next();
            while (iterator.hasNext()) {
                short value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        public short min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            ShortIterator iterator = this.shortIterator();
            short min = iterator.next();
            while (iterator.hasNext()) {
                short value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        public short minIfEmpty(short defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public short maxIfEmpty(short defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            short[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                short first = sortedArray[middleIndex];
                short second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public short[] toSortedArray() {
            short[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public short[] toArray() {
            int size = ShortFloatHashMap.this.size();
            final short[] result = new short[size];
            ShortFloatHashMap.this.forEachKey(new ShortProcedure(){
                private int index;

                public void value(short each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public MutableShortList toList() {
            return ShortArrayList.newList((ShortIterable)this);
        }

        public MutableShortList toSortedList() {
            return ShortArrayList.newList((ShortIterable)this).sortThis();
        }

        public MutableShortSet toSet() {
            return ShortHashSet.newSet((ShortIterable)this);
        }

        public MutableShortBag toBag() {
            return ShortHashBag.newBag((ShortIterable)this);
        }

        public LazyShortIterable asLazy() {
            return this;
        }
    }

    private class InternalFloatIterator
    implements FloatIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalFloatIterator() {
        }

        public boolean hasNext() {
            return this.count < ShortFloatHashMap.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortFloatHashMap.this.containsKey((short)0)) {
                    return ShortFloatHashMap.this.get((short)0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortFloatHashMap.this.containsKey((short)1)) {
                    return ShortFloatHashMap.this.get((short)1);
                }
            }
            short[] keys = ShortFloatHashMap.this.keys;
            while (!ShortFloatHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            float result = ShortFloatHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private float zeroValue;
        private float oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(float value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && Float.compare(this.zeroValue, value) == 0;
            boolean valueEqualsOneValue = this.containsOneKey && Float.compare(this.oneValue, value) == 0;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

