/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToLongFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortLongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortLongProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ImmutableShortLongMap;
import com.gs.collections.api.map.primitive.MutableShortLongMap;
import com.gs.collections.api.map.primitive.ShortLongMap;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.factory.primitive.ShortLongMaps;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedShortLongMap;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableShortLongMap
implements MutableShortLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableShortLongMap map;

    UnmodifiableShortLongMap(MutableShortLongMap map) {
        this.map = map;
    }

    private boolean isAbsent(long result, short key) {
        return result == 0L && !this.containsKey(key);
    }

    private long getIfAbsentThrow(short key) {
        long result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(short key, long value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(ShortLongMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(short key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(short key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public long removeKeyIfAbsent(short key, long value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public long getIfAbsentPut(short key, long value) {
        return this.getIfAbsentThrow(key);
    }

    public long getIfAbsentPut(short key, LongFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    public long getIfAbsentPutWithKey(short key, ShortToLongFunction function) {
        return this.getIfAbsentThrow(key);
    }

    public <P> long getIfAbsentPutWith(short key, LongFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    public long updateValue(short key, long initialValueIfAbsent, LongToLongFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public long get(short key) {
        return this.map.get(key);
    }

    public long getIfAbsent(short key, long ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(short key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(short key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(long value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(ShortProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ShortLongProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyShortIterable keysView() {
        return this.map.keysView();
    }

    public MutableShortLongMap select(ShortLongPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableShortLongMap reject(ShortLongPredicate predicate) {
        return this.map.reject(predicate);
    }

    public LongIterator longIterator() {
        return this.map.longIterator();
    }

    public void forEach(LongProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(LongPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableLongCollection select(LongPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableLongCollection reject(LongPredicate predicate) {
        return this.map.reject(predicate);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public long sum() {
        return this.map.sum();
    }

    public long max() {
        return this.map.max();
    }

    public long maxIfEmpty(long defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public long min() {
        return this.map.min();
    }

    public long minIfEmpty(long defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public long[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableLongList toSortedList() {
        return this.map.toSortedList();
    }

    public long[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(long value) {
        return this.map.contains(value);
    }

    public boolean containsAll(long ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(LongIterable source) {
        return this.map.containsAll(source);
    }

    public MutableLongList toList() {
        return this.map.toList();
    }

    public MutableLongSet toSet() {
        return this.map.toSet();
    }

    public MutableLongBag toBag() {
        return this.map.toBag();
    }

    public LazyLongIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableShortLongMap withKeyValue(short key, long value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableShortLongMap withoutKey(short key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableShortLongMap withoutAllKeys(ShortIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableShortLongMap asUnmodifiable() {
        return this;
    }

    public MutableShortLongMap asSynchronized() {
        return new SynchronizedShortLongMap(this);
    }

    public ImmutableShortLongMap toImmutable() {
        return ShortLongMaps.immutable.withAll((ShortLongMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableShortSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableLongCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }
}

