/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.sorted.mutable;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.multimap.sortedset.MutableSortedSetMultimap;
import com.gs.collections.api.partition.set.sorted.PartitionMutableSortedSet;
import com.gs.collections.api.set.SetIterable;
import com.gs.collections.api.set.sorted.ImmutableSortedSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.set.sorted.SortedSetIterable;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.collection.mutable.SynchronizedMutableCollection;
import com.gs.collections.impl.factory.SortedSets;
import com.gs.collections.impl.set.sorted.mutable.SortedSetAdapter;
import com.gs.collections.impl.set.sorted.mutable.UnmodifiableSortedSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class SynchronizedSortedSet<T>
extends SynchronizedMutableCollection<T>
implements MutableSortedSet<T> {
    private static final long serialVersionUID = 1L;

    public SynchronizedSortedSet(MutableSortedSet<T> set) {
        super(set);
    }

    public SynchronizedSortedSet(MutableSortedSet<T> set, Object newLock) {
        super(set, newLock);
    }

    public static <E, S extends SortedSet<E>> SynchronizedSortedSet<E> of(S set) {
        return new SynchronizedSortedSet(SortedSetAdapter.adapt(set));
    }

    public static <E, S extends SortedSet<E>> MutableSortedSet<E> of(S set, Object lock) {
        return new SynchronizedSortedSet(SortedSetAdapter.adapt(set), lock);
    }

    @GuardedBy(value="getLock()")
    private MutableSortedSet<T> getSortedSet() {
        return (MutableSortedSet)this.getCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return UnmodifiableSortedSet.of(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableSortedSet<T> toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return SortedSets.immutable.ofSortedSet(this.getSortedSet());
        }
    }

    @Override
    public MutableSortedSet<T> asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<T> clone() {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedSortedSet.of(this.getSortedSet().clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableList<V> collect(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().collectBoolean(booleanFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteList collectByte(ByteFunction<? super T> byteFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().collectByte(byteFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharList collectChar(CharFunction<? super T> charFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().collectChar(charFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().collectDouble(doubleFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().collectFloat(floatFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntList collectInt(IntFunction<? super T> intFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().collectInt(intFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongList collectLong(LongFunction<? super T> longFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().collectLong(longFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableShortList collectShort(ShortFunction<? super T> shortFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().collectShort(shortFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().flatCollect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().collectIf(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P, V> MutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().collectWith(function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableSortedSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().groupBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableSortedSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().groupByEach(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().newEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> reject(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> MutableSortedSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().rejectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> select(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> MutableSortedSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().selectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionMutableSortedSet<T> partition(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().partition(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S> MutableSortedSet<S> selectInstancesOf(Class<S> clazz) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().selectInstancesOf(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().equals(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S> MutableSortedSet<Pair<T, S>> zip(Iterable<S> that) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().zip(that);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getSortedSet().zip(that, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<Pair<T, Integer>> zipWithIndex() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().zipWithIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getSortedSet().zipWithIndex(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comparator<? super T> comparator() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().comparator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<T> union(SetIterable<? extends T> set) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().union(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getSortedSet().unionInto(set, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<T> intersect(SetIterable<? extends T> set) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().intersect(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getSortedSet().intersectInto(set, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<T> difference(SetIterable<? extends T> subtrahendSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().difference(subtrahendSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getSortedSet().differenceInto(subtrahendSet, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<T> symmetricDifference(SetIterable<? extends T> setB) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().symmetricDifference(setB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getSortedSet().symmetricDifferenceInto(set, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().isSubsetOf(candidateSuperset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().isProperSubsetOf(candidateSuperset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<SortedSetIterable<T>> powerSet() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().powerSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().cartesianProduct(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<T> subSet(T fromElement, T toElement) {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedSortedSet.of(this.getSortedSet().subSet(fromElement, toElement), this.getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<T> headSet(T toElement) {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedSortedSet.of(this.getSortedSet().headSet(toElement), this.getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<T> tailSet(T fromElement) {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedSortedSet.of(this.getSortedSet().tailSet(fromElement), this.getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T first() {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getSortedSet().first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T last() {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getSortedSet().last();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compareTo(SortedSetIterable<T> o) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSortedSet().compareTo(o);
        }
    }

    @Override
    public MutableSortedSet<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    public MutableSortedSet<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    public MutableSortedSet<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    public MutableSortedSet<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }
}

