/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.ByteList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.ByteStack;
import com.gs.collections.api.stack.primitive.ImmutableByteStack;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedByteProcedure;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.ByteStacks;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class ImmutableByteArrayStack
implements ImmutableByteStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ByteArrayList delegate;

    private ImmutableByteArrayStack(byte[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = new ByteArrayList(newElements);
    }

    private ImmutableByteArrayStack(ByteArrayList newElements) {
        this.checkOptimizedSize(newElements.size());
        this.delegate = newElements;
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use ByteStacks.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableByteArrayStack newStack(ByteIterable iterable) {
        return new ImmutableByteArrayStack(iterable.toArray());
    }

    public static ImmutableByteArrayStack newStackWith(byte ... elements) {
        byte[] newArray = new byte[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableByteArrayStack(newArray);
    }

    public static ImmutableByteArrayStack newStackFromTopToBottom(byte ... items) {
        return new ImmutableByteArrayStack(ByteArrayList.newListWith(items).reverseThis());
    }

    public static ImmutableByteArrayStack newStackFromTopToBottom(ByteIterable items) {
        return new ImmutableByteArrayStack(ByteArrayList.newList(items).reverseThis());
    }

    public ImmutableByteStack push(byte item) {
        ByteArrayList newDelegate = ByteArrayList.newList((ByteIterable)this.delegate);
        newDelegate.add(item);
        return new ImmutableByteArrayStack(newDelegate);
    }

    public ImmutableByteStack pop() {
        ByteArrayList newDelegate = ByteArrayList.newList((ByteIterable)this.delegate);
        newDelegate.removeAtIndex(this.delegate.size() - 1);
        return ByteStacks.immutable.with(newDelegate.toArray());
    }

    public ImmutableByteStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        this.checkSizeLessThanCount(count);
        ByteArrayList newDelegate = ByteArrayList.newList((ByteIterable)this.delegate);
        while (count > 0) {
            newDelegate.removeAtIndex(newDelegate.size() - 1);
            --count;
        }
        return ByteStacks.immutable.with(newDelegate.toArray());
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public byte peek() {
        return this.delegate.getLast();
    }

    public ByteList peek(int count) {
        this.checkNegativeCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new ByteArrayList();
        }
        ByteArrayList subList = new ByteArrayList(count);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    public byte peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    public ByteIterator byteIterator() {
        return this.delegate.asReversed().byteIterator();
    }

    public void forEach(ByteProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    public int count(BytePredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    public ImmutableByteStack select(BytePredicate predicate) {
        return ByteStacks.immutable.withAllReversed(this.delegate.asReversed().select(predicate));
    }

    public ImmutableByteStack reject(BytePredicate predicate) {
        return ByteStacks.immutable.withAllReversed(this.delegate.asReversed().reject(predicate));
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableStack<V> collect(ByteToObjectFunction<? extends V> function) {
        return Stacks.immutable.withAllReversed((Iterable)this.delegate.asReversed().collect(function));
    }

    public long sum() {
        return this.delegate.sum();
    }

    public byte max() {
        return this.delegate.max();
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.max();
    }

    public byte min() {
        return this.delegate.min();
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.min();
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public byte[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newList((ByteIterable)this).sortThis();
    }

    public byte[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    public boolean contains(byte value) {
        return this.delegate.asReversed().contains(value);
    }

    public boolean containsAll(byte ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public boolean containsAll(ByteIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public MutableByteList toList() {
        return ByteArrayList.newList((ByteIterable)this);
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSet((ByteIterable)this);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBag((ByteIterable)this);
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public ImmutableByteStack toImmutable() {
        return this;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof ByteStack)) {
            return false;
        }
        ByteStack stack = (ByteStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        ByteIterable iterable = this.delegate.asReversed();
        ByteIterator iterator = iterable.byteIterator();
        while (iterator.hasNext()) {
            byte item = iterator.next();
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    public String toString() {
        return this.delegate.asReversed().toString();
    }

    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    private void checkSizeLessThanCount(int count) {
        if (this.delegate.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.delegate.size());
        }
    }

    private Object writeReplace() {
        return new ImmutableByteStackSerializationProxy((ByteStack)this);
    }

    private static class ImmutableByteStackSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ByteStack stack;

        public ImmutableByteStackSerializationProxy() {
        }

        protected ImmutableByteStackSerializationProxy(ByteStack stack) {
            this.stack = stack;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.stack.size());
            try {
                this.stack.forEach((ByteProcedure)new CheckedByteProcedure(){

                    public void safeValue(byte item) throws IOException {
                        out.writeByte(item);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ByteArrayList deserializedDelegate = new ByteArrayList(size);
            for (int i = 0; i < size; ++i) {
                deserializedDelegate.add(in.readByte());
            }
            this.stack = ImmutableByteArrayStack.newStackFromTopToBottom((ByteIterable)deserializedDelegate);
        }

        protected Object readResolve() {
            return this.stack;
        }
    }
}

