/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.UnsortedMapIterable;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.procedure.CollectProcedure;
import com.gs.collections.impl.block.procedure.CollectionAddProcedure;
import com.gs.collections.impl.block.procedure.CountProcedure;
import com.gs.collections.impl.block.procedure.MapEntryToProcedure2;
import com.gs.collections.impl.block.procedure.MapPutProcedure;
import com.gs.collections.impl.block.procedure.RejectProcedure;
import com.gs.collections.impl.block.procedure.SelectProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectByteProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectCharProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectIntProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectLongProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectShortProcedure;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.MapAdapter;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.tuple.Tuples;
import com.gs.collections.impl.utility.Iterate;
import com.gs.collections.impl.utility.internal.IterableIterate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapIterate {
    private MapIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean notEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static <K, V> V getIfAbsentPut(Map<K, V> map, K key, Function0<? extends V> instanceBlock) {
        if (map instanceof MutableMap) {
            return (V)((MutableMap)map).getIfAbsentPut(key, instanceBlock);
        }
        Object result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = instanceBlock.value();
            map.put(key, result);
        }
        return result;
    }

    public static <K, V, P> V getIfAbsentPutWith(Map<K, V> map, K key, Function<? super P, ? extends V> function, P parameter) {
        Object result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = function.valueOf(parameter);
            map.put(key, result);
        }
        return result;
    }

    public static <K, V> V getIfAbsent(Map<K, V> map, K key, Function0<? extends V> instanceBlock) {
        if (map instanceof UnsortedMapIterable) {
            return (V)((MapIterable)map).getIfAbsent(key, instanceBlock);
        }
        Object result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = instanceBlock.value();
        }
        return result;
    }

    public static <K, V, P> V getIfAbsentWith(Map<K, V> map, K key, Function<? super P, ? extends V> function, P parameter) {
        if (map instanceof UnsortedMapIterable) {
            return (V)((MapIterable)map).getIfAbsentWith(key, function, parameter);
        }
        Object result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = function.valueOf(parameter);
        }
        return result;
    }

    public static <K, V> V getIfAbsentDefault(Map<K, V> map, K key, V defaultValue) {
        V result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = defaultValue;
        }
        return result;
    }

    private static <K, V> boolean isAbsent(V result, Map<K, V> map, K key) {
        return result == null && !map.containsKey(key);
    }

    public static <K, V, A> A ifPresentApply(Map<K, V> map, K key, Function<? super V, ? extends A> function) {
        if (map instanceof UnsortedMapIterable) {
            return (A)((MapIterable)map).ifPresentApply(key, function);
        }
        V result = map.get(key);
        return (A)(MapIterate.isAbsent(result, map, key) ? null : function.valueOf(result));
    }

    public static <K, V> MutableList<V> select(Map<K, V> map, Predicate<? super V> predicate) {
        return MapIterate.select(map, predicate, FastList.newList());
    }

    public static <K, V, R extends Collection<V>> R select(Map<K, V> map, Predicate<? super V> predicate, R targetCollection) {
        SelectProcedure<? super V> procedure = new SelectProcedure<V>(predicate, targetCollection);
        MapIterate.forEachValue(map, procedure);
        return targetCollection;
    }

    public static <K, V> int count(Map<K, V> map, Predicate<? super V> predicate) {
        CountProcedure<V> procedure = new CountProcedure<V>(predicate);
        MapIterate.forEachValue(map, procedure);
        return procedure.getCount();
    }

    public static <K, V> MutableMap<K, V> selectMapOnEntry(Map<K, V> map, Predicate2<? super K, ? super V> predicate) {
        return MapIterate.selectMapOnEntry(map, predicate, UnifiedMap.newMap());
    }

    public static <K, V, R extends Map<K, V>> R selectMapOnEntry(Map<K, V> map, final Predicate2<? super K, ? super V> predicate, R target) {
        final MapPutProcedure mapTransferProcedure = new MapPutProcedure(target);
        Procedure2 procedure = new Procedure2<K, V>(){

            public void value(K key, V value) {
                if (predicate.accept(key, value)) {
                    mapTransferProcedure.value(key, value);
                }
            }
        };
        MapIterate.forEachKeyValue(map, procedure);
        return target;
    }

    public static <K, V> MutableMap<K, V> selectMapOnKey(Map<K, V> map, final Predicate<? super K> predicate) {
        UnifiedMap resultMap = UnifiedMap.newMap();
        final MapPutProcedure mapTransferProcedure = new MapPutProcedure(resultMap);
        Procedure2 procedure = new Procedure2<K, V>(){

            public void value(K key, V value) {
                if (predicate.accept(key)) {
                    mapTransferProcedure.value(key, value);
                }
            }
        };
        MapIterate.forEachKeyValue(map, procedure);
        return resultMap;
    }

    public static <K, V> MutableMap<K, V> selectMapOnValue(Map<K, V> map, final Predicate<? super V> predicate) {
        UnifiedMap resultMap = UnifiedMap.newMap();
        final MapPutProcedure mapTransferProcedure = new MapPutProcedure(resultMap);
        Procedure2 procedure = new Procedure2<K, V>(){

            public void value(K key, V value) {
                if (predicate.accept(value)) {
                    mapTransferProcedure.value(key, value);
                }
            }
        };
        MapIterate.forEachKeyValue(map, procedure);
        return resultMap;
    }

    public static <K, V> MutableList<V> reject(Map<K, V> map, Predicate<? super V> predicate) {
        return MapIterate.reject(map, predicate, FastList.newList());
    }

    public static <K, V, R extends Collection<V>> R reject(Map<K, V> map, Predicate<? super V> predicate, R targetCollection) {
        RejectProcedure<? super V> procedure = new RejectProcedure<V>(predicate, targetCollection);
        MapIterate.forEachValue(map, procedure);
        return targetCollection;
    }

    public static <K, V> MutableMap<K, V> rejectMapOnEntry(Map<K, V> map, Predicate2<? super K, ? super V> predicate) {
        return MapIterate.rejectMapOnEntry(map, predicate, UnifiedMap.newMap());
    }

    public static <K, V, R extends Map<K, V>> R rejectMapOnEntry(Map<K, V> map, final Predicate2<? super K, ? super V> predicate, final R target) {
        MapIterate.forEachKeyValue(map, new Procedure2<K, V>(){

            public void value(K argument1, V argument2) {
                if (!predicate.accept(argument1, argument2)) {
                    target.put(argument1, argument2);
                }
            }
        });
        return target;
    }

    public static <K, V> Collection<K> addAllKeysTo(Map<K, V> map, Collection<K> targetCollection) {
        MapIterate.forEachKey(map, CollectionAddProcedure.on(targetCollection));
        return targetCollection;
    }

    public static <K, V> Collection<V> addAllValuesTo(Map<K, V> map, Collection<V> targetCollection) {
        MapIterate.forEachValue(map, CollectionAddProcedure.on(targetCollection));
        return targetCollection;
    }

    public static <K, V, A> MutableList<A> collect(Map<K, V> map, Function<? super V, ? extends A> function) {
        return MapIterate.collect(map, function, FastList.newList(map.size()));
    }

    public static <K, V> MutableBooleanCollection collectBoolean(Map<K, V> map, BooleanFunction<? super V> booleanFunction) {
        BooleanArrayList result = new BooleanArrayList(map.size());
        MapIterate.forEachValue(map, new CollectBooleanProcedure<V>(booleanFunction, (MutableBooleanCollection)result));
        return result;
    }

    public static <K, V> MutableByteCollection collectByte(Map<K, V> map, ByteFunction<? super V> byteFunction) {
        ByteArrayList result = new ByteArrayList(map.size());
        MapIterate.forEachValue(map, new CollectByteProcedure<V>(byteFunction, (MutableByteCollection)result));
        return result;
    }

    public static <K, V> MutableCharCollection collectChar(Map<K, V> map, CharFunction<? super V> charFunction) {
        CharArrayList result = new CharArrayList(map.size());
        MapIterate.forEachValue(map, new CollectCharProcedure<V>(charFunction, (MutableCharCollection)result));
        return result;
    }

    public static <K, V> MutableDoubleCollection collectDouble(Map<K, V> map, DoubleFunction<? super V> doubleFunction) {
        DoubleArrayList result = new DoubleArrayList(map.size());
        MapIterate.forEachValue(map, new CollectDoubleProcedure<V>(doubleFunction, (MutableDoubleCollection)result));
        return result;
    }

    public static <K, V> MutableFloatCollection collectFloat(Map<K, V> map, FloatFunction<? super V> floatFunction) {
        FloatArrayList result = new FloatArrayList(map.size());
        MapIterate.forEachValue(map, new CollectFloatProcedure<V>(floatFunction, (MutableFloatCollection)result));
        return result;
    }

    public static <K, V> MutableIntCollection collectInt(Map<K, V> map, IntFunction<? super V> intFunction) {
        IntArrayList result = new IntArrayList(map.size());
        MapIterate.forEachValue(map, new CollectIntProcedure<V>(intFunction, (MutableIntCollection)result));
        return result;
    }

    public static <K, V> MutableLongCollection collectLong(Map<K, V> map, LongFunction<? super V> longFunction) {
        LongArrayList result = new LongArrayList(map.size());
        MapIterate.forEachValue(map, new CollectLongProcedure<V>(longFunction, (MutableLongCollection)result));
        return result;
    }

    public static <K, V> MutableShortCollection collectShort(Map<K, V> map, ShortFunction<? super V> shortFunction) {
        ShortArrayList result = new ShortArrayList(map.size());
        MapIterate.forEachValue(map, new CollectShortProcedure<V>(shortFunction, (MutableShortCollection)result));
        return result;
    }

    public static <K, V, K2, V2> MutableMap<K2, V2> collect(Map<K, V> map, Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return MapIterate.collect(map, function, UnifiedMap.newMap(map.size()));
    }

    public static <K1, V1, K2, V2, R extends Map<K2, V2>> R collect(Map<K1, V1> map, final Function2<? super K1, ? super V1, Pair<K2, V2>> function, final R target) {
        MapIterate.forEachKeyValue(map, new Procedure2<K1, V1>(){

            public void value(K1 key, V1 value) {
                Pair pair = (Pair)function.value(key, value);
                target.put(pair.getOne(), pair.getTwo());
            }
        });
        return target;
    }

    public static <K, V, V2> MutableMap<K, V2> collectValues(Map<K, V> map, Function2<? super K, ? super V, ? extends V2> function) {
        return MapIterate.collectValues(map, function, UnifiedMap.newMap(map.size()));
    }

    public static <K, V, V2, R extends Map<K, V2>> R collectValues(Map<K, V> map, final Function2<? super K, ? super V, ? extends V2> function, final R target) {
        MapIterate.forEachKeyValue(map, new Procedure2<K, V>(){

            public void value(K key, V value) {
                target.put(key, function.value(key, value));
            }
        });
        return target;
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collectIf(Map<K1, V1> map, Function2<? super K1, ? super V1, Pair<K2, V2>> function, Predicate2<? super K1, ? super V1> predicate) {
        return MapIterate.collectIf(map, function, predicate, UnifiedMap.newMap());
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collectIf(Map<K1, V1> map, final Function2<? super K1, ? super V1, Pair<K2, V2>> function, final Predicate2<? super K1, ? super V1> predicate, Map<K2, V2> target) {
        final MutableMap<K2, V2> result = MapAdapter.adapt(target);
        MapIterate.forEachKeyValue(map, new Procedure2<K1, V1>(){

            public void value(K1 key, V1 value) {
                if (predicate.accept(key, value)) {
                    Pair pair = (Pair)function.value(key, value);
                    result.put(pair.getOne(), pair.getTwo());
                }
            }
        });
        return result;
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collect(Map<K1, V1> map, Function<? super K1, ? extends K2> keyFunction, Function<? super V1, ? extends V2> valueFunction) {
        return MapIterate.collect(map, keyFunction, valueFunction, UnifiedMap.newMap());
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collect(Map<K1, V1> map, final Function<? super K1, ? extends K2> keyFunction, final Function<? super V1, ? extends V2> valueFunction, Map<K2, V2> target) {
        return MapIterate.collect(map, new Function2<K1, V1, Pair<K2, V2>>(){

            public Pair<K2, V2> value(K1 key, V1 value) {
                return Tuples.pair(keyFunction.valueOf(key), valueFunction.valueOf(value));
            }
        }, MapAdapter.adapt(target));
    }

    public static <K, V, A, R extends Collection<A>> R collect(Map<K, V> map, Function<? super V, ? extends A> function, R targetCollection) {
        CollectProcedure<? super V, ? extends A> procedure = new CollectProcedure<V, A>(function, targetCollection);
        MapIterate.forEachValue(map, procedure);
        return targetCollection;
    }

    public static <K, V> void forEachValue(Map<K, V> map, Procedure<? super V> procedure) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot perform a forEachValue on null");
        }
        if (MapIterate.notEmpty(map)) {
            if (map instanceof UnsortedMapIterable) {
                ((MapIterable)map).forEachValue(procedure);
            } else {
                IterableIterate.forEach(map.values(), procedure);
            }
        }
    }

    public static <K, V> void forEachKey(Map<K, V> map, Procedure<? super K> procedure) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot perform a forEachKey on null");
        }
        if (MapIterate.notEmpty(map)) {
            if (map instanceof UnsortedMapIterable) {
                ((MapIterable)map).forEachKey(procedure);
            } else {
                IterableIterate.forEach(map.keySet(), procedure);
            }
        }
    }

    public static <K, V> void forEachKeyValue(Map<K, V> map, Procedure2<? super K, ? super V> procedure) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot perform a forEachKeyValue on null");
        }
        if (MapIterate.notEmpty(map)) {
            if (map instanceof UnsortedMapIterable) {
                ((MapIterable)map).forEachKeyValue(procedure);
            } else {
                IterableIterate.forEach(map.entrySet(), new MapEntryToProcedure2<K, V>(procedure));
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static <K, V> Pair<K, V> detect(Map<K, V> map, Predicate2<? super K, ? super V> predicate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.TernaryExpression.applyExpressionRewriter(TernaryExpression.java:106)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <K, V> V detect(Map<K, V> map, Predicate<? super V> predicate) {
        return IterableIterate.detect(map.values(), predicate);
    }

    public static <K, V> V detectIfNone(Map<K, V> map, Predicate<? super V> predicate, V ifNone) {
        return Iterate.detectIfNone(map.values(), predicate, ifNone);
    }

    public static <K, V, IV> IV injectInto(IV injectValue, Map<K, V> map, Function2<? super IV, ? super V, ? extends IV> function) {
        return Iterate.injectInto(injectValue, map.values(), function);
    }

    public static <IV, K, V> IV injectIntoIf(IV initialValue, Map<K, V> map, final Predicate<? super V> predicate, final Function2<? super IV, ? super V, ? extends IV> function) {
        Function2 ifFunction = new Function2<IV, V, IV>(){

            public IV value(IV accumulator, V item) {
                if (predicate.accept(item)) {
                    return function.value(accumulator, item);
                }
                return accumulator;
            }
        };
        return Iterate.injectInto(initialValue, map.values(), ifFunction);
    }

    public static <K, V> boolean anySatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        return IterableIterate.anySatisfy(map.values(), predicate);
    }

    public static <K, V> boolean allSatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        return IterableIterate.allSatisfy(map.values(), predicate);
    }

    public static <K, V> boolean noneSatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        return IterableIterate.noneSatisfy(map.values(), predicate);
    }

    public static <K, V> MutableList<Pair<K, V>> toListOfPairs(Map<K, V> map) {
        final FastList<Pair<K, V>> pairs = FastList.newList(map.size());
        MapIterate.forEachKeyValue(map, new Procedure2<K, V>(){

            public void value(K key, V value) {
                pairs.add(Tuples.pair(key, value));
            }
        });
        return pairs;
    }

    public static <K, V> MutableList<V> toSortedList(Map<K, V> map, Comparator<? super V> comparator) {
        return Iterate.toSortedList(map.values(), comparator);
    }

    public static <K, V> MutableMap<V, K> reverseMapping(Map<K, V> map) {
        final UnifiedMap reverseMap = UnifiedMap.newMap(map.size());
        MapIterate.forEachKeyValue(map, new Procedure2<K, V>(){

            public void value(K sourceKey, V sourceValue) {
                reverseMap.put(sourceValue, sourceKey);
            }
        });
        return reverseMap;
    }

    public static <K, V> int occurrencesOf(Map<K, V> map, V object) {
        return Iterate.count(map.values(), Predicates.equal(object));
    }

    public static <K, V, A> int occurrencesOfAttribute(Map<K, V> map, Function<? super V, ? extends A> function, A object) {
        return Iterate.count(map.values(), Predicates.attributeEqual(function, object));
    }
}

