/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableLongStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableLongStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableLongArrayStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableLongEmptyStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableLongSingletonStack;

public class ImmutableLongStackFactoryImpl
implements ImmutableLongStackFactory {
    public ImmutableLongStack of() {
        return this.with();
    }

    public ImmutableLongStack with() {
        return ImmutableLongEmptyStack.INSTANCE;
    }

    public ImmutableLongStack of(long one) {
        return this.with(one);
    }

    public ImmutableLongStack with(long one) {
        return new ImmutableLongSingletonStack(one);
    }

    public ImmutableLongStack of(long ... items) {
        return this.with(items);
    }

    public ImmutableLongStack with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableLongArrayStack.newStackWith(items);
    }

    public ImmutableLongStack ofAll(LongIterable items) {
        return this.withAll(items);
    }

    public ImmutableLongStack withAll(LongIterable items) {
        if (items instanceof ImmutableLongStack) {
            return (ImmutableLongStack)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableLongStack ofAllReversed(LongIterable items) {
        return this.withAllReversed(items);
    }

    public ImmutableLongStack withAllReversed(LongIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableLongArrayStack.newStackFromTopToBottom(items);
    }
}

