/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility.internal;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.Function3;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.list.PartitionMutableList;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.api.tuple.Twin;
import com.gs.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.multimap.list.FastListMultimap;
import com.gs.collections.impl.partition.list.PartitionFastList;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.tuple.Tuples;
import com.gs.collections.impl.utility.Iterate;
import com.gs.collections.impl.utility.internal.IterableIterate;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RandomAccessListIterate {
    private RandomAccessListIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> void toArray(List<T> list, T[] target, int startIndex, int sourceSize) {
        for (int i = 0; i < sourceSize; ++i) {
            target[startIndex + i] = list.get(i);
        }
    }

    public static <T> MutableList<T> select(List<T> list, Predicate<? super T> predicate) {
        return RandomAccessListIterate.select(list, predicate, FastList.newList());
    }

    public static <T, IV> MutableList<T> selectWith(List<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        return RandomAccessListIterate.selectWith(list, predicate, injectedValue, FastList.newList());
    }

    public static <T, R extends Collection<T>> R select(List<T> list, Predicate<? super T> predicate, R targetCollection) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T item = list.get(i);
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T, P, R extends Collection<T>> R selectWith(List<T> list, Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T item = list.get(i);
            if (!predicate.accept(item, parameter)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T> MutableList<T> selectInstancesOf(List<?> list, Class<T> clazz) {
        int size = list.size();
        FastList result = FastList.newList(size);
        for (int i = 0; i < size; ++i) {
            Object item = list.get(i);
            if (!clazz.isInstance(item)) continue;
            result.add(item);
        }
        result.trimToSize();
        return result;
    }

    public static <T> int count(List<T> list, Predicate<? super T> predicate) {
        int count = 0;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(list.get(i))) continue;
            ++count;
        }
        return count;
    }

    public static <T, IV> int countWith(List<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        int count = 0;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(list.get(i), injectedValue)) continue;
            ++count;
        }
        return count;
    }

    public static <T, A> MutableList<A> collectIf(List<T> list, Predicate<? super T> predicate, Function<? super T, ? extends A> function) {
        return RandomAccessListIterate.collectIf(list, predicate, function, FastList.newList());
    }

    public static <T, A, R extends Collection<A>> R collectIf(List<T> list, Predicate<? super T> predicate, Function<? super T, ? extends A> function, R targetCollection) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T item = list.get(i);
            if (!predicate.accept(item)) continue;
            targetCollection.add((Object)function.valueOf(item));
        }
        return targetCollection;
    }

    public static <T> MutableList<T> reject(List<T> list, Predicate<? super T> predicate) {
        return RandomAccessListIterate.reject(list, predicate, FastList.newList());
    }

    public static <T, IV> MutableList<T> rejectWith(List<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        return RandomAccessListIterate.rejectWith(list, predicate, injectedValue, FastList.newList());
    }

    public static <T, R extends Collection<T>> R reject(List<T> list, Predicate<? super T> predicate, R targetCollection) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T item = list.get(i);
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T, P, R extends Collection<T>> R rejectWith(List<T> list, Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T item = list.get(i);
            if (predicate.accept(item, parameter)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T, A> MutableList<A> collect(List<T> list, Function<? super T, ? extends A> function) {
        return RandomAccessListIterate.collect(list, function, FastList.newList(list.size()));
    }

    public static <T, A, R extends Collection<A>> R collect(List<T> list, Function<? super T, ? extends A> function, R targetCollection) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            targetCollection.add((Object)function.valueOf(list.get(i)));
        }
        return targetCollection;
    }

    public static <T> MutableBooleanList collectBoolean(List<T> list, BooleanFunction<? super T> booleanFunction) {
        return RandomAccessListIterate.collectBoolean(list, booleanFunction, new BooleanArrayList(list.size()));
    }

    public static <T, R extends MutableBooleanCollection> R collectBoolean(List<T> list, BooleanFunction<? super T> booleanFunction, R target) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            target.add(booleanFunction.booleanValueOf(list.get(i)));
        }
        return target;
    }

    public static <T> MutableByteList collectByte(List<T> list, ByteFunction<? super T> byteFunction) {
        return RandomAccessListIterate.collectByte(list, byteFunction, new ByteArrayList(list.size()));
    }

    public static <T, R extends MutableByteCollection> R collectByte(List<T> list, ByteFunction<? super T> byteFunction, R target) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            target.add(byteFunction.byteValueOf(list.get(i)));
        }
        return target;
    }

    public static <T> MutableCharList collectChar(List<T> list, CharFunction<? super T> charFunction) {
        return RandomAccessListIterate.collectChar(list, charFunction, new CharArrayList(list.size()));
    }

    public static <T, R extends MutableCharCollection> R collectChar(List<T> list, CharFunction<? super T> charFunction, R target) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            target.add(charFunction.charValueOf(list.get(i)));
        }
        return target;
    }

    public static <T> MutableDoubleList collectDouble(List<T> list, DoubleFunction<? super T> doubleFunction) {
        return RandomAccessListIterate.collectDouble(list, doubleFunction, new DoubleArrayList(list.size()));
    }

    public static <T, R extends MutableDoubleCollection> R collectDouble(List<T> list, DoubleFunction<? super T> doubleFunction, R target) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            target.add(doubleFunction.doubleValueOf(list.get(i)));
        }
        return target;
    }

    public static <T> MutableFloatList collectFloat(List<T> list, FloatFunction<? super T> floatFunction) {
        return RandomAccessListIterate.collectFloat(list, floatFunction, new FloatArrayList(list.size()));
    }

    public static <T, R extends MutableFloatCollection> R collectFloat(List<T> list, FloatFunction<? super T> floatFunction, R target) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            target.add(floatFunction.floatValueOf(list.get(i)));
        }
        return target;
    }

    public static <T> MutableIntList collectInt(List<T> list, IntFunction<? super T> intFunction) {
        return RandomAccessListIterate.collectInt(list, intFunction, new IntArrayList(list.size()));
    }

    public static <T, R extends MutableIntCollection> R collectInt(List<T> list, IntFunction<? super T> intFunction, R target) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            target.add(intFunction.intValueOf(list.get(i)));
        }
        return target;
    }

    public static <T> MutableLongList collectLong(List<T> list, LongFunction<? super T> longFunction) {
        return RandomAccessListIterate.collectLong(list, longFunction, new LongArrayList(list.size()));
    }

    public static <T, R extends MutableLongCollection> R collectLong(List<T> list, LongFunction<? super T> longFunction, R target) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            target.add(longFunction.longValueOf(list.get(i)));
        }
        return target;
    }

    public static <T> MutableShortList collectShort(List<T> list, ShortFunction<? super T> shortFunction) {
        return RandomAccessListIterate.collectShort(list, shortFunction, new ShortArrayList(list.size()));
    }

    public static <T, R extends MutableShortCollection> R collectShort(List<T> list, ShortFunction<? super T> shortFunction, R target) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            target.add(shortFunction.shortValueOf(list.get(i)));
        }
        return target;
    }

    public static <T, A> MutableList<A> flatCollect(List<T> list, Function<? super T, ? extends Iterable<A>> function) {
        return RandomAccessListIterate.flatCollect(list, function, FastList.newList(list.size()));
    }

    public static <T, A, R extends Collection<A>> R flatCollect(List<T> list, Function<? super T, ? extends Iterable<A>> function, R targetCollection) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Iterate.addAllTo((Iterable)function.valueOf(list.get(i)), targetCollection);
        }
        return targetCollection;
    }

    public static <T> T getLast(List<T> collection) {
        return Iterate.isEmpty(collection) ? null : (T)collection.get(collection.size() - 1);
    }

    public static <T> void forEach(List<T> list, Procedure<? super T> procedure) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            procedure.value(list.get(i));
        }
    }

    public static <T> void forEach(List<T> list, int from, int to, Procedure<? super T> procedure) {
        if (from < 0 || to < 0) {
            throw new IllegalArgumentException("Neither from nor to may be negative.");
        }
        if (from <= to) {
            for (int i = from; i <= to; ++i) {
                procedure.value(list.get(i));
            }
        } else {
            for (int i = from; i >= to; --i) {
                procedure.value(list.get(i));
            }
        }
    }

    public static <T> void forEachWithIndex(List<T> list, int from, int to, ObjectIntProcedure<? super T> objectIntProcedure) {
        if (from < 0 || to < 0) {
            throw new IllegalArgumentException("Neither from nor to may be negative.");
        }
        if (from <= to) {
            for (int i = from; i <= to; ++i) {
                objectIntProcedure.value(list.get(i), i);
            }
        } else {
            for (int i = from; i >= to; --i) {
                objectIntProcedure.value(list.get(i), i);
            }
        }
    }

    public static <T1, T2> void forEachInBoth(List<T1> list1, List<T2> list2, Procedure2<? super T1, ? super T2> procedure) {
        if (list1 != null && list2 != null) {
            int size2;
            int size1 = list1.size();
            if (size1 == (size2 = list2.size())) {
                for (int i = 0; i < size1; ++i) {
                    procedure.value(list1.get(i), list2.get(i));
                }
            } else {
                throw new IllegalArgumentException("Attempt to call forEachInBoth with two Lists of different sizes :" + size1 + ':' + size2);
            }
        }
    }

    public static <T> void forEachWithIndex(List<T> list, ObjectIntProcedure<? super T> objectIntProcedure) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            objectIntProcedure.value(list.get(i), i);
        }
    }

    public static <T> T detect(List<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T item = list.get(i);
            if (!predicate.accept(item)) continue;
            return item;
        }
        return null;
    }

    public static <T, IV> T detectWith(List<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T item = list.get(i);
            if (!predicate.accept(item, injectedValue)) continue;
            return item;
        }
        return null;
    }

    public static <T, IV> IV injectInto(IV injectValue, List<T> list, Function2<? super IV, ? super T, ? extends IV> function) {
        Object result = injectValue;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            result = function.value(result, list.get(i));
        }
        return result;
    }

    public static <T> int injectInto(int injectValue, List<T> list, IntObjectToIntFunction<? super T> function) {
        int result = injectValue;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            result = function.intValueOf(result, list.get(i));
        }
        return result;
    }

    public static <T> long injectInto(long injectValue, List<T> list, LongObjectToLongFunction<? super T> function) {
        long result = injectValue;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            result = function.longValueOf(result, list.get(i));
        }
        return result;
    }

    public static <T> double injectInto(double injectValue, List<T> list, DoubleObjectToDoubleFunction<? super T> function) {
        double result = injectValue;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            result = function.doubleValueOf(result, list.get(i));
        }
        return result;
    }

    public static <T> float injectInto(float injectValue, List<T> list, FloatObjectToFloatFunction<? super T> function) {
        float result = injectValue;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            result = function.floatValueOf(result, list.get(i));
        }
        return result;
    }

    public static <T> long sumOfInt(List<T> list, IntFunction<? super T> function) {
        long result = 0L;
        for (int i = 0; i < list.size(); ++i) {
            result += (long)function.intValueOf(list.get(i));
        }
        return result;
    }

    public static <T> long sumOfLong(List<T> list, LongFunction<? super T> function) {
        long result = 0L;
        for (int i = 0; i < list.size(); ++i) {
            result += function.longValueOf(list.get(i));
        }
        return result;
    }

    public static <T> double sumOfFloat(List<T> list, FloatFunction<? super T> function) {
        double result = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            result += (double)function.floatValueOf(list.get(i));
        }
        return result;
    }

    public static <T> double sumOfDouble(List<T> list, DoubleFunction<? super T> function) {
        double result = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            result += function.doubleValueOf(list.get(i));
        }
        return result;
    }

    public static <T> boolean anySatisfy(List<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(list.get(i))) continue;
            return true;
        }
        return false;
    }

    public static <T, IV> boolean anySatisfyWith(List<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(list.get(i), injectedValue)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean allSatisfy(List<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (predicate.accept(list.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T, IV> boolean allSatisfyWith(List<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (predicate.accept(list.get(i), injectedValue)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean noneSatisfy(List<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(list.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T, P> boolean noneSatisfyWith(List<T> list, Predicate2<? super T, ? super P> predicate, P injectedValue) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(list.get(i), injectedValue)) continue;
            return false;
        }
        return true;
    }

    public static <T, IV> Twin<MutableList<T>> selectAndRejectWith(List<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        MutableList positiveResult = Lists.mutable.of();
        MutableList negativeResult = Lists.mutable.of();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T item = list.get(i);
            (predicate.accept(item, injectedValue) ? positiveResult : negativeResult).add(item);
        }
        return Tuples.twin(positiveResult, negativeResult);
    }

    public static <T> PartitionMutableList<T> partition(List<T> list, Predicate<? super T> predicate) {
        PartitionFastList partitionFastList = new PartitionFastList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T each = list.get(i);
            MutableList bucket = predicate.accept(each) ? partitionFastList.getSelected() : partitionFastList.getRejected();
            bucket.add(each);
        }
        return partitionFastList;
    }

    public static <T, P> PartitionMutableList<T> partitionWith(List<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionFastList partitionFastList = new PartitionFastList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T each = list.get(i);
            MutableList bucket = predicate.accept(each, parameter) ? partitionFastList.getSelected() : partitionFastList.getRejected();
            bucket.add(each);
        }
        return partitionFastList;
    }

    public static <T> List<T> removeIf(List<T> list, Predicate<? super T> predicate) {
        for (int i = 0; i < list.size(); ++i) {
            T each = list.get(i);
            if (!predicate.accept(each)) continue;
            list.remove(i--);
        }
        return list;
    }

    public static <T, P> List<T> removeIfWith(List<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        for (int i = 0; i < list.size(); ++i) {
            T each = list.get(i);
            if (!predicate.accept(each, parameter)) continue;
            list.remove(i--);
        }
        return list;
    }

    public static <T> List<T> removeIf(List<T> list, Predicate<? super T> predicate, Procedure<? super T> procedure) {
        for (int i = 0; i < list.size(); ++i) {
            T each = list.get(i);
            if (!predicate.accept(each)) continue;
            procedure.value(each);
            list.remove(i--);
        }
        return list;
    }

    public static <T> int detectIndex(List<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <T, IV> int detectIndexWith(List<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!predicate.accept(list.get(i), injectedValue)) continue;
            return i;
        }
        return -1;
    }

    public static <T, IV, P> IV injectIntoWith(IV injectedValue, List<T> list, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        Object result = injectedValue;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            result = function.value(result, list.get(i), parameter);
        }
        return result;
    }

    public static <T, P> void forEachWith(List<T> list, Procedure2<? super T, ? super P> procedure, P parameter) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            procedure.value(list.get(i), parameter);
        }
    }

    public static <T, P, A, R extends Collection<A>> R collectWith(List<T> list, Function2<? super T, ? super P, ? extends A> function, P parameter, R targetCollection) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            targetCollection.add((Object)function.value(list.get(i), parameter));
        }
        return targetCollection;
    }

    public static <T, R extends Collection<T>> R distinct(List<T> list, R targetCollection) {
        UnifiedSet seenSoFar = UnifiedSet.newSet();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T item = list.get(i);
            if (!seenSoFar.add(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T> MutableList<T> take(List<T> list, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        return RandomAccessListIterate.take(list, count, FastList.newList(Math.min(list.size(), count)));
    }

    public static <T, R extends Collection<T>> R take(List<T> list, int count, R targetList) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        int end = Math.min(list.size(), count);
        for (int i = 0; i < end; ++i) {
            targetList.add(list.get(i));
        }
        return targetList;
    }

    public static <T> MutableList<T> drop(List<T> list, int count) {
        return RandomAccessListIterate.drop(list, count, FastList.newList(list.size() - Math.min(list.size(), count)));
    }

    public static <T, R extends Collection<T>> R drop(List<T> list, int count, R targetList) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        int start = Math.min(list.size(), count);
        targetList.addAll(list.subList(start, list.size()));
        return targetList;
    }

    public static <T> void appendString(List<T> list, Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            if (Iterate.notEmpty(list)) {
                appendable.append(IterableIterate.stringValueOfItem(list, list.get(0)));
                int size = list.size();
                for (int i = 1; i < size; ++i) {
                    appendable.append(separator);
                    appendable.append(IterableIterate.stringValueOfItem(list, list.get(i)));
                }
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, V> FastListMultimap<V, T> groupBy(List<T> list, Function<? super T, ? extends V> function) {
        return RandomAccessListIterate.groupBy(list, function, FastListMultimap.newMultimap());
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupBy(List<T> list, Function<? super T, ? extends V> function, R target) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T item = list.get(i);
            target.put(function.valueOf(item), item);
        }
        return target;
    }

    public static <T, V> FastListMultimap<V, T> groupByEach(List<T> list, Function<? super T, ? extends Iterable<V>> function) {
        return RandomAccessListIterate.groupByEach(list, function, FastListMultimap.newMultimap());
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupByEach(List<T> list, Function<? super T, ? extends Iterable<V>> function, R target) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T item = list.get(i);
            Iterable iterable = (Iterable)function.valueOf(item);
            for (Object key : iterable) {
                target.put(key, item);
            }
        }
        return target;
    }

    public static <T, V extends Comparable<? super V>> T minBy(List<T> list, Function<? super T, ? extends V> function) {
        if (list.isEmpty()) {
            throw new NoSuchElementException();
        }
        T min = list.get(0);
        Comparable minValue = (Comparable)function.valueOf(min);
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            T next = list.get(i);
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (nextValue.compareTo(minValue) >= 0) continue;
            min = next;
            minValue = nextValue;
        }
        return min;
    }

    public static <T, V extends Comparable<? super V>> T maxBy(List<T> list, Function<? super T, ? extends V> function) {
        if (list.isEmpty()) {
            throw new NoSuchElementException();
        }
        T max = list.get(0);
        Comparable maxValue = (Comparable)function.valueOf(max);
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            T next = list.get(i);
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (nextValue.compareTo(maxValue) <= 0) continue;
            max = next;
            maxValue = nextValue;
        }
        return max;
    }

    public static <T> T min(List<T> list, Comparator<? super T> comparator) {
        if (list.isEmpty()) {
            throw new NoSuchElementException();
        }
        T candidate = list.get(0);
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            T next = list.get(i);
            if (comparator.compare(next, candidate) >= 0) continue;
            candidate = next;
        }
        return candidate;
    }

    public static <T> T max(List<T> list, Comparator<? super T> comparator) {
        if (list.isEmpty()) {
            throw new NoSuchElementException();
        }
        T candidate = list.get(0);
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            T next = list.get(i);
            if (comparator.compare(next, candidate) <= 0) continue;
            candidate = next;
        }
        return candidate;
    }

    public static <T> T min(List<T> list) {
        if (list.isEmpty()) {
            throw new NoSuchElementException();
        }
        T candidate = list.get(0);
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            T next = list.get(i);
            if (((Comparable)next).compareTo(candidate) >= 0) continue;
            candidate = next;
        }
        return candidate;
    }

    public static <T> T max(List<T> list) {
        if (list.isEmpty()) {
            throw new NoSuchElementException();
        }
        T candidate = list.get(0);
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            T next = list.get(i);
            if (((Comparable)next).compareTo(candidate) <= 0) continue;
            candidate = next;
        }
        return candidate;
    }

    public static <X, Y> MutableList<Pair<X, Y>> zip(List<X> list, Iterable<Y> iterable) {
        return RandomAccessListIterate.zip(list, iterable, FastList.newList());
    }

    public static <X, Y, R extends Collection<Pair<X, Y>>> R zip(List<X> list, Iterable<Y> iterable, R target) {
        Iterator<Y> yIterator = iterable.iterator();
        int size = list.size();
        for (int i = 0; i < size && yIterator.hasNext(); ++i) {
            target.add(Tuples.pair(list.get(i), yIterator.next()));
        }
        return target;
    }

    public static <T> MutableList<Pair<T, Integer>> zipWithIndex(List<T> list) {
        return RandomAccessListIterate.zipWithIndex(list, FastList.newList());
    }

    public static <T, R extends Collection<Pair<T, Integer>>> R zipWithIndex(List<T> list, R target) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            target.add(Tuples.pair(list.get(i), i));
        }
        return target;
    }

    public static <T, K, V> MutableMap<K, V> aggregateInPlaceBy(List<T> list, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        RandomAccessListIterate.forEach(list, new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(List<T> list, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        RandomAccessListIterate.forEach(list, new NonMutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    public static <T> MutableList<T> takeWhile(List<T> list, Predicate<? super T> predicate) {
        FastList result = FastList.newList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T each = list.get(i);
            if (!predicate.accept(each)) {
                return result;
            }
            result.add(each);
        }
        return result;
    }

    public static <T> MutableList<T> dropWhile(List<T> list, Predicate<? super T> predicate) {
        FastList result = FastList.newList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T each = list.get(i);
            if (predicate.accept(each)) continue;
            result.add(each);
            for (int j = i + 1; j < size; ++j) {
                T eachNotDropped = list.get(j);
                result.add(eachNotDropped);
            }
            return result;
        }
        return result;
    }

    public static <T> PartitionMutableList<T> partitionWhile(List<T> list, Predicate<? super T> predicate) {
        PartitionFastList result = new PartitionFastList();
        MutableList selected = result.getSelected();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T each = list.get(i);
            if (!predicate.accept(each)) {
                MutableList rejected = result.getRejected();
                rejected.add(each);
                for (int j = i + 1; j < size; ++j) {
                    T eachRejected = list.get(j);
                    rejected.add(eachRejected);
                }
                return result;
            }
            selected.add(each);
        }
        return result;
    }
}

