/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.bag.primitive.ImmutableFloatBag;
import com.gs.collections.api.factory.bag.primitive.ImmutableFloatBagFactory;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableFloatEmptyBag;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableFloatHashBag;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableFloatSingletonBag;

public class ImmutableFloatBagFactoryImpl
implements ImmutableFloatBagFactory {
    public ImmutableFloatBag empty() {
        return ImmutableFloatEmptyBag.INSTANCE;
    }

    public ImmutableFloatBag of() {
        return this.empty();
    }

    public ImmutableFloatBag with() {
        return this.empty();
    }

    public ImmutableFloatBag of(float one) {
        return this.with(one);
    }

    public ImmutableFloatBag with(float one) {
        return new ImmutableFloatSingletonBag(one);
    }

    public ImmutableFloatBag of(float ... items) {
        return this.with(items);
    }

    public ImmutableFloatBag with(float ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableFloatHashBag.newBagWith(items);
    }

    public ImmutableFloatBag ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    public ImmutableFloatBag withAll(FloatIterable items) {
        if (items instanceof ImmutableFloatBag) {
            return (ImmutableFloatBag)items;
        }
        return this.with(items.toArray());
    }
}

