/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy;

import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.iterator.TapIterator;
import com.gs.collections.impl.utility.Iterate;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class TapIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;
    private final Procedure<? super T> procedure;

    public TapIterable(Iterable<T> newAdapted, Procedure<? super T> procedure) {
        this.adapted = newAdapted;
        this.procedure = procedure;
    }

    public void each(final Procedure<? super T> procedure) {
        Iterate.forEach(this.adapted, new Procedure<T>(){

            public void value(T each) {
                TapIterable.this.procedure.value(each);
                procedure.value(each);
            }
        });
    }

    @Override
    public void forEachWithIndex(final ObjectIntProcedure<? super T> objectIntProcedure) {
        Iterate.forEachWithIndex(this.adapted, new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                TapIterable.this.procedure.value(each);
                objectIntProcedure.value(each, index);
            }
        });
    }

    @Override
    public <P> void forEachWith(final Procedure2<? super T, ? super P> procedure, P parameter) {
        Iterate.forEachWith(this.adapted, new Procedure2<T, P>(){

            public void value(T each, P aParameter) {
                TapIterable.this.procedure.value(each);
                procedure.value(each, aParameter);
            }
        }, parameter);
    }

    @Override
    public boolean anySatisfy(final Predicate<? super T> predicate) {
        return Iterate.anySatisfy(this.adapted, new Predicate<T>(){

            public boolean accept(T each) {
                TapIterable.this.procedure.value(each);
                return predicate.accept(each);
            }
        });
    }

    @Override
    public boolean allSatisfy(final Predicate<? super T> predicate) {
        return Iterate.allSatisfy(this.adapted, new Predicate<T>(){

            public boolean accept(T each) {
                TapIterable.this.procedure.value(each);
                return predicate.accept(each);
            }
        });
    }

    @Override
    public boolean noneSatisfy(final Predicate<? super T> predicate) {
        return Iterate.noneSatisfy(this.adapted, new Predicate<T>(){

            public boolean accept(T each) {
                TapIterable.this.procedure.value(each);
                return predicate.accept(each);
            }
        });
    }

    @Override
    public T getFirst() {
        return Iterate.detect(this.adapted, new Predicate<T>(){

            public boolean accept(T each) {
                TapIterable.this.procedure.value(each);
                return true;
            }
        });
    }

    @Override
    public T detect(final Predicate<? super T> predicate) {
        return Iterate.detect(this.adapted, new Predicate<T>(){

            public boolean accept(T each) {
                TapIterable.this.procedure.value(each);
                return predicate.accept(each);
            }
        });
    }

    public Iterator<T> iterator() {
        return new TapIterator<T>(this.adapted, this.procedure);
    }
}

