/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.ParallelIterable;
import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.sorted.MutableSortedBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.impl.Counter;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.sorted.mutable.TreeBag;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.block.factory.Functions2;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.factory.Procedures;
import com.gs.collections.impl.block.procedure.CollectionAddProcedure;
import com.gs.collections.impl.block.procedure.DoubleSumResultHolder;
import com.gs.collections.impl.block.procedure.MapCollectProcedure;
import com.gs.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.checked.CheckedProcedure2;
import com.gs.collections.impl.lazy.parallel.Batch;
import com.gs.collections.impl.lazy.parallel.RootBatch;
import com.gs.collections.impl.list.mutable.CompositeFastList;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.map.mutable.ConcurrentHashMap;
import com.gs.collections.impl.map.mutable.ConcurrentHashMapUnsafe;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.map.sorted.mutable.TreeSortedMap;
import com.gs.collections.impl.set.mutable.SetAdapter;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.sorted.mutable.TreeSortedSet;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class AbstractParallelIterable<T, B extends Batch<T>>
implements ParallelIterable<T> {
    protected static <T> void forEach(final AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, final Procedure<? super T> procedure) {
        LazyIterable futures = parallelIterable.split().collect(new Function<RootBatch<T>, Future<?>>(){

            public Future<?> valueOf(final RootBatch<T> chunk) {
                return parallelIterable.getExecutorService().submit(new Runnable(){

                    public void run() {
                        chunk.forEach(procedure);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        for (Future future : futuresList) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static <T> boolean anySatisfy(AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, final Predicate<? super T> predicate) {
        final ExecutorCompletionService completionService = new ExecutorCompletionService(parallelIterable.getExecutorService());
        MutableSet futures = (MutableSet)parallelIterable.split().collect(new Function<RootBatch<T>, Future<Boolean>>(){

            public Future<Boolean> valueOf(final RootBatch<T> batch) {
                return completionService.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return batch.anySatisfy(predicate);
                    }
                });
            }
        }, UnifiedSet.newSet());
        while (futures.notEmpty()) {
            try {
                Future future = completionService.take();
                if (((Boolean)future.get()).booleanValue()) {
                    for (Future eachFuture : futures) {
                        eachFuture.cancel(true);
                    }
                    return true;
                }
                futures.remove(future);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    protected static <T> boolean allSatisfy(AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, final Predicate<? super T> predicate) {
        final ExecutorCompletionService completionService = new ExecutorCompletionService(parallelIterable.getExecutorService());
        MutableSet futures = (MutableSet)parallelIterable.split().collect(new Function<RootBatch<T>, Future<Boolean>>(){

            public Future<Boolean> valueOf(final RootBatch<T> batch) {
                return completionService.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return batch.allSatisfy(predicate);
                    }
                });
            }
        }, UnifiedSet.newSet());
        while (futures.notEmpty()) {
            try {
                Future future = completionService.take();
                if (!((Boolean)future.get()).booleanValue()) {
                    for (Future eachFuture : futures) {
                        eachFuture.cancel(true);
                    }
                    return false;
                }
                futures.remove(future);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    protected static <T> T detect(final AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, final Predicate<? super T> predicate) {
        LazyIterable<? extends RootBatch<T>> chunks = parallelIterable.split();
        LazyIterable futures = chunks.collect(new Function<RootBatch<T>, Future<T>>(){

            public Future<T> valueOf(final RootBatch<T> chunk) {
                return parallelIterable.getExecutorService().submit(new Callable<T>(){

                    @Override
                    public T call() {
                        return chunk.detect(predicate);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        for (Future future : futuresList) {
            try {
                Object eachResult = future.get();
                if (eachResult == null) continue;
                for (Future eachFutureToCancel : futuresList) {
                    eachFutureToCancel.cancel(true);
                }
                return (T)eachResult;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public abstract ExecutorService getExecutorService();

    public abstract int getBatchSize();

    public abstract LazyIterable<B> split();

    protected abstract boolean isOrdered();

    protected <S, V> void collectCombine(Function<Batch<T>, V> function, Procedure2<S, V> combineProcedure, S state) {
        if (this.isOrdered()) {
            this.collectCombineOrdered(function, combineProcedure, state);
        } else {
            this.collectCombineUnordered(function, combineProcedure, state);
        }
    }

    private <S, V> void collectCombineOrdered(final Function<Batch<T>, V> function, Procedure2<S, V> combineProcedure, S state) {
        LazyIterable<B> chunks = this.split();
        LazyIterable futures = chunks.collect(new Function<Batch<T>, Future<V>>(){

            public Future<V> valueOf(final Batch<T> chunk) {
                return AbstractParallelIterable.this.getExecutorService().submit(new Callable<V>(){

                    @Override
                    public V call() {
                        return function.valueOf((Object)chunk);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        for (Future future : futuresList) {
            try {
                combineProcedure.value(state, future.get());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private <S, V> void collectCombineUnordered(final Function<Batch<T>, V> function, Procedure2<S, V> combineProcedure, S state) {
        LazyIterable<B> chunks = this.split();
        MutableList callables = chunks.collect(new Function<Batch<T>, Callable<V>>(){

            public Callable<V> valueOf(final Batch<T> chunk) {
                return new Callable<V>(){

                    @Override
                    public V call() {
                        return function.valueOf((Object)chunk);
                    }
                };
            }
        }).toList();
        final ExecutorCompletionService completionService = new ExecutorCompletionService(this.getExecutorService());
        callables.forEach(new Procedure<Callable<V>>(){

            public void value(Callable<V> callable) {
                completionService.submit(callable);
            }
        });
        for (int numTasks = callables.size(); numTasks > 0; --numTasks) {
            try {
                Future future = completionService.take();
                combineProcedure.value(state, future.get());
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private T collectReduce(Function<Batch<T>, T> map, Function2<T, T, T> function2) {
        return this.isOrdered() ? this.collectReduceOrdered(map, function2) : this.collectReduceUnordered(map, function2);
    }

    private T collectReduceOrdered(final Function<Batch<T>, T> map, Function2<T, T, T> function2) {
        LazyIterable<B> chunks = this.split();
        LazyIterable futures = chunks.collect(new Function<Batch<T>, Future<T>>(){

            public Future<T> valueOf(final Batch<T> chunk) {
                return AbstractParallelIterable.this.getExecutorService().submit(new Callable<T>(){

                    @Override
                    public T call() {
                        return map.valueOf((Object)chunk);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        try {
            Object result = ((Future)futuresList.getFirst()).get();
            for (int i = 1; i < futuresList.size(); ++i) {
                Object next = ((Future)futuresList.get(i)).get();
                if (next == null) continue;
                result = result == null ? next : function2.value(result, next);
            }
            if (result == null) {
                throw new NoSuchElementException();
            }
            return (T)result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NullPointerException) {
                throw (NullPointerException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private T collectReduceUnordered(final Function<Batch<T>, T> map, Function2<T, T, T> function2) {
        LazyIterable<B> chunks = this.split();
        MutableList callables = chunks.collect(new Function<Batch<T>, Callable<T>>(){

            public Callable<T> valueOf(final Batch<T> chunk) {
                return new Callable<T>(){

                    @Override
                    public T call() {
                        return map.valueOf((Object)chunk);
                    }
                };
            }
        }).toList();
        final ExecutorCompletionService completionService = new ExecutorCompletionService(this.getExecutorService());
        callables.forEach(new Procedure<Callable<T>>(){

            public void value(Callable<T> callable) {
                completionService.submit(callable);
            }
        });
        try {
            Object result = completionService.take().get();
            for (int numTasks = callables.size() - 1; numTasks > 0; --numTasks) {
                Object next = completionService.take().get();
                if (next == null) continue;
                result = result == null ? next : function2.value(result, next);
            }
            if (result == null) {
                throw new NoSuchElementException();
            }
            return (T)result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NullPointerException) {
                throw (NullPointerException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(final Appendable appendable, String start, final String separator, String end) {
        try {
            appendable.append(start);
            Function map = new Function<Batch<T>, String>(){

                public String valueOf(Batch<T> batch) {
                    return batch.makeString(separator);
                }
            };
            CheckedProcedure2<Appendable, String> reduce = new CheckedProcedure2<Appendable, String>(){
                private boolean first = true;

                @Override
                public void safeValue(Appendable accumulator, String each) throws IOException {
                    if ("".equals(each)) {
                        return;
                    }
                    if (this.first) {
                        this.first = false;
                    } else {
                        appendable.append(separator);
                    }
                    appendable.append(each);
                }
            };
            this.collectCombine(map, reduce, appendable);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        this.forEach(Procedures.bind(procedure, parameter));
    }

    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.anySatisfy(Predicates.bind(predicate, parameter));
    }

    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.allSatisfy(Predicates.bind(predicate, parameter));
    }

    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return this.allSatisfy(Predicates.not(predicate));
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.noneSatisfy(Predicates.bind(predicate, parameter));
    }

    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (T)this.detect(Predicates.bind(predicate, parameter));
    }

    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        Object result = this.detect(predicate);
        return (T)(result == null ? function.value() : result);
    }

    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
        return this.detectIfNone(Predicates.bind(predicate, parameter), function);
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toArray() not implemented yet");
    }

    public <E> E[] toArray(E[] array) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toArray() not implemented yet");
    }

    public MutableList<T> toList() {
        Function map = new Function<Batch<T>, FastList<T>>(){

            public FastList<T> valueOf(Batch<T> batch) {
                FastList list = FastList.newList();
                batch.forEach(CollectionAddProcedure.on(list));
                return list;
            }
        };
        Procedure2 reduce = new Procedure2<MutableList<T>, FastList<T>>(){

            public void value(MutableList<T> accumulator, FastList<T> each) {
                accumulator.addAll(each);
            }
        };
        CompositeFastList state = new CompositeFastList();
        this.collectCombine(map, reduce, state);
        return state;
    }

    public MutableList<T> toSortedList() {
        return this.toList().toSortedList();
    }

    public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        return this.toList().toSortedList(comparator);
    }

    public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
        return this.toSortedList((Comparator<? super T>)Comparators.byFunction(function));
    }

    public MutableSet<T> toSet() {
        ConcurrentHashMapUnsafe map = ConcurrentHashMapUnsafe.newMap();
        Set result = Collections.newSetFromMap(map);
        this.forEach(CollectionAddProcedure.on(result));
        return SetAdapter.adapt(map.keySet());
    }

    public MutableSortedSet<T> toSortedSet() {
        MutableSortedSet result = TreeSortedSet.newSet().asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
        return this.toSortedSet((Comparator<? super T>)Comparators.byFunction(function));
    }

    public MutableBag<T> toBag() {
        MutableCollection result = HashBag.newBag().asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    public MutableSortedBag<T> toSortedBag() {
        MutableSortedBag result = TreeBag.newBag().asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
        MutableSortedBag result = TreeBag.newBag(comparator).asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    public <V extends Comparable<? super V>> MutableSortedBag<T> toSortedBagBy(Function<? super T, ? extends V> function) {
        return this.toSortedBag((Comparator<? super T>)Comparators.byFunction(function));
    }

    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        MutableSortedSet<? super T> result = TreeSortedSet.newSet(comparator).asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        MutableMap map = UnifiedMap.newMap().asSynchronized();
        this.forEach(new MapCollectProcedure<T, NK, NV>(map, keyFunction, valueFunction));
        return map;
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        MutableSortedMap sortedMap = TreeSortedMap.newMap().asSynchronized();
        this.forEach(new MapCollectProcedure<T, NK, NV>(sortedMap, keyFunction, valueFunction));
        return sortedMap;
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        MutableSortedMap sortedMap = TreeSortedMap.newMap(comparator).asSynchronized();
        this.forEach(new MapCollectProcedure<T, NK, NV>(sortedMap, keyFunction, valueFunction));
        return sortedMap;
    }

    public <K, V> MapIterable<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        ConcurrentHashMapUnsafe map = ConcurrentHashMapUnsafe.newMap();
        this.forEach(new NonMutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    public <K, V> MapIterable<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        ConcurrentHashMapUnsafe map = ConcurrentHashMapUnsafe.newMap();
        this.forEach(new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public int count(final Predicate<? super T> predicate) {
        Function map = new Function<Batch<T>, Integer>(){

            public Integer valueOf(Batch<T> batch) {
                return batch.count(predicate);
            }
        };
        Procedure2<Counter, Integer> combineProcedure = new Procedure2<Counter, Integer>(){

            public void value(Counter counter, Integer eachCount) {
                counter.add(eachCount);
            }
        };
        Counter state = new Counter();
        this.collectCombineUnordered(map, combineProcedure, state);
        return state.getCount();
    }

    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.count(Predicates.bind(predicate, parameter));
    }

    public T min(final Comparator<? super T> comparator) {
        Function map = new Function<Batch<T>, T>(){

            public T valueOf(Batch<T> batch) {
                return batch.min(comparator);
            }
        };
        return this.collectReduce(map, Functions2.min(comparator));
    }

    public T max(final Comparator<? super T> comparator) {
        Function map = new Function<Batch<T>, T>(){

            public T valueOf(Batch<T> batch) {
                return batch.max(comparator);
            }
        };
        return this.collectReduce(map, Functions2.max(comparator));
    }

    /*
     * Exception decompiling
     */
    public T min() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public T max() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <V extends Comparable<? super V>> T minBy(final Function<? super T, ? extends V> function) {
        Function map = new Function<Batch<T>, T>(){

            public T valueOf(Batch<T> batch) {
                return batch.minBy(function);
            }
        };
        return this.collectReduce(map, Functions2.minBy(function));
    }

    public <V extends Comparable<? super V>> T maxBy(final Function<? super T, ? extends V> function) {
        Function map = new Function<Batch<T>, T>(){

            public T valueOf(Batch<T> batch) {
                return batch.maxBy(function);
            }
        };
        return this.collectReduce(map, Functions2.maxBy(function));
    }

    public long sumOfInt(final IntFunction<? super T> function) {
        LongFunction map = new LongFunction<Batch<T>>(){

            public long longValueOf(Batch<T> batch) {
                return batch.sumOfInt(function);
            }
        };
        return this.sumOfLongOrdered(map);
    }

    public double sumOfFloat(final FloatFunction<? super T> function) {
        Function map = new Function<Batch<T>, DoubleSumResultHolder>(){

            public DoubleSumResultHolder valueOf(Batch<T> batch) {
                return batch.sumOfFloat(function);
            }
        };
        return this.sumOfDoubleOrdered(map);
    }

    public long sumOfLong(final LongFunction<? super T> function) {
        LongFunction map = new LongFunction<Batch<T>>(){

            public long longValueOf(Batch<T> batch) {
                return batch.sumOfLong(function);
            }
        };
        return this.sumOfLongOrdered(map);
    }

    public double sumOfDouble(final DoubleFunction<? super T> function) {
        Function map = new Function<Batch<T>, DoubleSumResultHolder>(){

            public DoubleSumResultHolder valueOf(Batch<T> batch) {
                return batch.sumOfDouble(function);
            }
        };
        return this.sumOfDoubleOrdered(map);
    }

    private long sumOfLongOrdered(final LongFunction<Batch<T>> map) {
        LazyIterable<B> chunks = this.split();
        LazyIterable futures = chunks.collect(new Function<Batch<T>, Future<Long>>(){

            public Future<Long> valueOf(final Batch<T> chunk) {
                return AbstractParallelIterable.this.getExecutorService().submit(new Callable<Long>(){

                    @Override
                    public Long call() {
                        return map.longValueOf((Object)chunk);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        try {
            long result = 0L;
            for (int i = 0; i < futuresList.size(); ++i) {
                result += ((Long)((Future)futuresList.get(i)).get()).longValue();
            }
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private double sumOfDoubleOrdered(final Function<Batch<T>, DoubleSumResultHolder> map) {
        LazyIterable<B> chunks = this.split();
        LazyIterable futures = chunks.collect(new Function<Batch<T>, Future<DoubleSumResultHolder>>(){

            public Future<DoubleSumResultHolder> valueOf(final Batch<T> chunk) {
                return AbstractParallelIterable.this.getExecutorService().submit(new Callable<DoubleSumResultHolder>(){

                    @Override
                    public DoubleSumResultHolder call() {
                        return (DoubleSumResultHolder)map.valueOf((Object)chunk);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        try {
            double sum = 0.0;
            double compensation = 0.0;
            for (int i = 0; i < futuresList.size(); ++i) {
                double adjustedValue = ((DoubleSumResultHolder)((Future)futuresList.get(i)).get()).getResult() - (compensation += ((DoubleSumResultHolder)((Future)futuresList.get(i)).get()).getCompensation());
                double nextSum = sum + adjustedValue;
                compensation = nextSum - sum - adjustedValue;
                sum = nextSum;
            }
            return sum;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public <V> MapIterable<V, T> groupByUniqueKey(final Function<? super T, ? extends V> function) {
        final ConcurrentHashMap result = ConcurrentHashMap.newMap();
        this.forEach(new Procedure<T>(){

            public void value(T value) {
                Object key = function.valueOf(value);
                if (result.put(key, value) != null) {
                    throw new IllegalStateException("Key " + key + " already exists in map!");
                }
            }
        });
        return result;
    }
}

