/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.set.sorted;

import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.list.ParallelListIterable;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.multimap.sortedset.SortedSetMultimap;
import com.gs.collections.api.set.sorted.ParallelSortedSetIterable;
import com.gs.collections.impl.block.factory.Functions;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.lazy.parallel.AbstractParallelIterable;
import com.gs.collections.impl.lazy.parallel.list.ParallelCollectListIterable;
import com.gs.collections.impl.lazy.parallel.list.ParallelFlatCollectListIterable;
import com.gs.collections.impl.lazy.parallel.set.sorted.ParallelSelectSortedSetIterable;
import com.gs.collections.impl.lazy.parallel.set.sorted.SortedSetBatch;
import com.gs.collections.impl.multimap.set.sorted.SynchronizedPutTreeSortedSetMultimap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class AbstractParallelSortedSetIterable<T, B extends SortedSetBatch<T>>
extends AbstractParallelIterable<T, B>
implements ParallelSortedSetIterable<T> {
    @Override
    protected boolean isOrdered() {
        return true;
    }

    public ParallelSortedSetIterable<T> asUnique() {
        return this;
    }

    public ParallelSortedSetIterable<T> select(Predicate<? super T> predicate) {
        return new ParallelSelectSortedSetIterable<T>(this, predicate);
    }

    public <P> ParallelSortedSetIterable<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select(Predicates.bind(predicate, parameter));
    }

    public <S> ParallelSortedSetIterable<S> selectInstancesOf(Class<S> clazz) {
        return this.select((Predicate<? super T>)Predicates.instanceOf(clazz));
    }

    public ParallelSortedSetIterable<T> reject(Predicate<? super T> predicate) {
        return this.select((Predicate<? super T>)Predicates.not(predicate));
    }

    public <P> ParallelSortedSetIterable<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject(Predicates.bind(predicate, parameter));
    }

    public <V> ParallelListIterable<V> collect(Function<? super T, ? extends V> function) {
        return new ParallelCollectListIterable<T, V>(this, function);
    }

    public <P, V> ParallelListIterable<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collect(Functions.bind(function, parameter));
    }

    public <V> ParallelListIterable<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.select(predicate).collect(function);
    }

    public <V> ParallelListIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return new ParallelFlatCollectListIterable(this, function);
    }

    public <V> SortedSetMultimap<V, T> groupBy(final Function<? super T, ? extends V> function) {
        final SynchronizedPutTreeSortedSetMultimap result = SynchronizedPutTreeSortedSetMultimap.newMultimap();
        this.forEach(new Procedure<T>(){

            public void value(T each) {
                Object key = function.valueOf(each);
                result.put(key, each);
            }
        });
        return result;
    }

    public <V> SortedSetMultimap<V, T> groupByEach(final Function<? super T, ? extends Iterable<V>> function) {
        final SynchronizedPutTreeSortedSetMultimap result = SynchronizedPutTreeSortedSetMultimap.newMultimap();
        this.forEach(new Procedure<T>(){

            public void value(T each) {
                Iterable keys = (Iterable)function.valueOf(each);
                for (Object key : keys) {
                    result.put(key, each);
                }
            }
        });
        return result;
    }

    @Override
    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.toList().groupByUniqueKey(function);
    }

    @Override
    public Object[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.toList().toArray((Object[])array);
    }
}

