/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatIntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatIntProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.primitive.FloatList;
import com.gs.collections.api.list.primitive.ImmutableFloatList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.iterator.UnmodifiableFloatIterator;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseFloatIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableFloatSingletonList
implements ImmutableFloatList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final float element1;

    ImmutableFloatSingletonList(float element) {
        this.element1 = element;
    }

    public float get(int index) {
        if (index == 0) {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
    }

    public float getFirst() {
        return this.element1;
    }

    public float getLast() {
        return this.element1;
    }

    public int indexOf(float value) {
        return Float.compare(this.element1, value) == 0 ? 0 : -1;
    }

    public int lastIndexOf(float value) {
        return Float.compare(this.element1, value) == 0 ? 0 : -1;
    }

    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator((FloatIterator)FloatArrayList.newListWith(this.element1).floatIterator());
    }

    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    public void each(FloatProcedure procedure) {
        procedure.value(this.element1);
    }

    public void forEachWithIndex(FloatIntProcedure procedure) {
        procedure.value(this.element1, 0);
    }

    public int count(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public ImmutableFloatList select(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? FloatArrayList.newListWith(this.element1).toImmutable() : new FloatArrayList().toImmutable();
    }

    public ImmutableFloatList reject(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? new FloatArrayList().toImmutable() : FloatArrayList.newListWith(this.element1).toImmutable();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableList<V> collect(FloatToObjectFunction<? extends V> function) {
        return FastList.newListWith(function.valueOf(this.element1)).toImmutable();
    }

    public double sum() {
        return this.element1;
    }

    public float max() {
        return this.element1;
    }

    public float maxIfEmpty(float defaultValue) {
        return this.element1;
    }

    public float min() {
        return this.element1;
    }

    public float minIfEmpty(float defaultValue) {
        return this.element1;
    }

    public double average() {
        return this.element1;
    }

    public double median() {
        return this.element1;
    }

    public float[] toSortedArray() {
        return new float[]{this.element1};
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newListWith(this.element1);
    }

    public int binarySearch(float value) {
        if (Float.compare(this.element1, value) == 0) {
            return 0;
        }
        if (Float.compare(this.element1, value) < 0) {
            return -2;
        }
        return -1;
    }

    public double dotProduct(FloatList list) {
        if (list.size() != 1) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return (double)this.element1 * (double)list.getFirst();
    }

    public float[] toArray() {
        return new float[]{this.element1};
    }

    public boolean contains(float value) {
        return Float.compare(this.element1, value) == 0;
    }

    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (Float.compare(this.element1, value) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (Float.compare(this.element1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public LazyFloatIterable asReversed() {
        return ReverseFloatIterable.adapt((FloatList)this);
    }

    public MutableFloatList toList() {
        return FloatArrayList.newListWith(this.element1);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSetWith(this.element1);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBagWith(this.element1);
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public ImmutableFloatList toImmutable() {
        return this;
    }

    public ImmutableFloatSingletonList toReversed() {
        return this;
    }

    public ImmutableFloatList newWith(float element) {
        return FloatLists.immutable.with(new float[]{this.element1, element});
    }

    public ImmutableFloatList newWithout(float element) {
        return Float.compare(this.element1, element) == 0 ? FloatLists.immutable.with() : this;
    }

    public ImmutableFloatList newWithAll(FloatIterable elements) {
        FloatArrayList arrayList = FloatArrayList.newListWith(this.element1);
        arrayList.addAll(elements);
        return arrayList.toImmutable();
    }

    public ImmutableFloatList newWithoutAll(FloatIterable elements) {
        return elements.contains(this.element1) ? FloatLists.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectFloatIntToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1, 0);
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof FloatList)) {
            return false;
        }
        FloatList list = (FloatList)otherList;
        if (list.size() != 1) {
            return false;
        }
        return Float.compare(this.element1, list.get(0)) == 0;
    }

    public int hashCode() {
        return 31 + Float.floatToIntBits(this.element1);
    }

    public String toString() {
        return "[" + this.element1 + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ImmutableFloatList distinct() {
        return this;
    }

    public ImmutableFloatList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}

