/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.HashingStrategy;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.predicate.primitive.ObjectShortPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectShortProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.MutableShortIterator;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.ImmutableObjectShortMap;
import com.gs.collections.api.map.primitive.MutableObjectShortMap;
import com.gs.collections.api.map.primitive.ObjectShortMap;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.api.tuple.primitive.ObjectShortPair;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedShortCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import com.gs.collections.impl.factory.primitive.ObjectShortMaps;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedObjectShortMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableObjectShortMap;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectShortHashMapWithHashingStrategy<K>
implements MutableObjectShortMap<K>,
Externalizable {
    public static final short EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectShortHashMapWithHashingStrategy.NULL_KEY";
        }
    };
    private static final Object REMOVED_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectShortHashMapWithHashingStrategy.REMOVED_KEY";
        }
    };
    private Object[] keys;
    private short[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private HashingStrategy<? super K> hashingStrategy;

    @Deprecated
    public ObjectShortHashMapWithHashingStrategy() {
    }

    public ObjectShortHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy) {
        this.hashingStrategy = hashingStrategy;
        this.allocateTable(16);
    }

    public ObjectShortHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        this.hashingStrategy = hashingStrategy;
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    public ObjectShortHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, ObjectShortMap<? extends K> map) {
        this(hashingStrategy, Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static <K> ObjectShortHashMapWithHashingStrategy<K> newMap(HashingStrategy<? super K> hashingStrategy) {
        return new ObjectShortHashMapWithHashingStrategy<K>(hashingStrategy);
    }

    public static <K> ObjectShortHashMapWithHashingStrategy<K> newMap(HashingStrategy<? super K> hashingStrategy, ObjectShortMap<K> map) {
        return new ObjectShortHashMapWithHashingStrategy<K>(hashingStrategy, map);
    }

    public static <K> ObjectShortHashMapWithHashingStrategy<K> newMap(ObjectShortHashMapWithHashingStrategy<K> map) {
        return new ObjectShortHashMapWithHashingStrategy<K>(map.hashingStrategy, map);
    }

    public static <K> ObjectShortHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, short value1) {
        return new ObjectShortHashMapWithHashingStrategy<K>(hashingStrategy, 1).withKeyValue((Object)key1, value1);
    }

    public static <K> ObjectShortHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, short value1, K key2, short value2) {
        return new ObjectShortHashMapWithHashingStrategy<K>(hashingStrategy, 2).withKeysValues(key1, value1, key2, value2);
    }

    public static <K> ObjectShortHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, short value1, K key2, short value2, K key3, short value3) {
        return new ObjectShortHashMapWithHashingStrategy<K>(hashingStrategy, 3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <K> ObjectShortHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, short value1, K key2, short value2, K key3, short value3, K key4, short value4) {
        return new ObjectShortHashMapWithHashingStrategy<K>(hashingStrategy, 4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectShortMap)) {
            return false;
        }
        ObjectShortMap other = (ObjectShortMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || other.containsKey(this.toNonSentinel(this.keys[i])) && this.values[i] == other.getOrThrow(this.toNonSentinel(this.keys[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result += this.hashingStrategy.computeHashCode(this.toNonSentinel(this.keys[i])) ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.toNonSentinel(key)).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(String.valueOf(this.values[i])));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    public short[] toArray() {
        short[] result = new short[this.size()];
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values[i];
            ++index;
        }
        return result;
    }

    public boolean contains(short value) {
        return this.containsValue(value);
    }

    public boolean containsAll(short ... source) {
        for (short item : source) {
            if (this.containsValue(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        return this.containsAll(source.toArray());
    }

    public void clear() {
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, (short)0);
    }

    public void put(K key, short value) {
        int index = this.probe(key);
        if (ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(ObjectShortMap<? extends K> map) {
        map.forEachKeyValue(new ObjectShortProcedure<K>(){

            public void value(K key, short value) {
                ObjectShortHashMapWithHashingStrategy.this.put(key, value);
            }
        });
    }

    public void removeKey(K key) {
        int index = this.probe(key);
        this.removeKeyAtIndex(key, index);
    }

    public void removeKeyAtIndex(K key, int index) {
        if (ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
        }
    }

    public void remove(Object key) {
        this.removeKey(key);
    }

    public short removeKeyIfAbsent(K key, short value) {
        int index = this.probe(key);
        if (ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            short oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return oldValue;
        }
        return value;
    }

    public short getIfAbsentPut(K key, short value) {
        int index = this.probe(key);
        if (ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short getIfAbsentPut(K key, ShortFunction0 function) {
        int index = this.probe(key);
        if (ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        short value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> short getIfAbsentPutWith(K key, ShortFunction<? super P> function, P parameter) {
        int index = this.probe(key);
        if (ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        short value = function.shortValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short getIfAbsentPutWithKey(K key, ShortFunction<? super K> function) {
        int index = this.probe(key);
        if (ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        short value = function.shortValueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short updateValue(K key, short initialValueIfAbsent, ShortToShortFunction function) {
        int index = this.probe(key);
        if (ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        short value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(K key, short value, int index) {
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectShortHashMapWithHashingStrategy.toSentinelIfNull(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public short addToValue(K key, short toBeAdded) {
        int index = this.probe(key);
        if (ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            int n = index;
            this.values[n] = (short)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    public ObjectShortHashMapWithHashingStrategy<K> withKeyValue(K key1, short value1) {
        this.put(key1, value1);
        return this;
    }

    public ObjectShortHashMapWithHashingStrategy<K> withKeysValues(K key1, short value1, K key2, short value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ObjectShortHashMapWithHashingStrategy<K> withKeysValues(K key1, short value1, K key2, short value2, K key3, short value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ObjectShortHashMapWithHashingStrategy<K> withKeysValues(K key1, short value1, K key2, short value2, K key3, short value3, K key4, short value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ObjectShortHashMapWithHashingStrategy<K> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    public ObjectShortHashMapWithHashingStrategy<K> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    public MutableObjectShortMap<K> asUnmodifiable() {
        return new UnmodifiableObjectShortMap(this);
    }

    public MutableObjectShortMap<K> asSynchronized() {
        return new SynchronizedObjectShortMap(this);
    }

    public ImmutableObjectShortMap<K> toImmutable() {
        return ObjectShortMaps.immutable.withAll((ObjectShortMap)this);
    }

    public short get(Object key) {
        return this.getIfAbsent(key, (short)0);
    }

    public short getOrThrow(Object key) {
        int index = this.probe(key);
        if (ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public short getIfAbsent(Object key, short ifAbsent) {
        int index = this.probe(key);
        if (ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public boolean containsKey(Object key) {
        int index = this.probe(key);
        return ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key);
    }

    public boolean containsValue(short value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public void each(ShortProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void forEachValue(ShortProcedure procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(Procedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]));
        }
    }

    public void forEachKeyValue(ObjectShortProcedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    public ObjectShortHashMapWithHashingStrategy<K> select(ObjectShortPredicate<? super K> predicate) {
        ObjectShortHashMapWithHashingStrategy<K> result = ObjectShortHashMapWithHashingStrategy.newMap(this.hashingStrategy);
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    public ObjectShortHashMapWithHashingStrategy<K> reject(ObjectShortPredicate<? super K> predicate) {
        ObjectShortHashMapWithHashingStrategy<K> result = ObjectShortHashMapWithHashingStrategy.newMap(this.hashingStrategy);
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    public MutableShortCollection select(ShortPredicate predicate) {
        ShortArrayList result = new ShortArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableShortCollection reject(ShortPredicate predicate) {
        ShortArrayList result = new ShortArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return ifNone;
    }

    public <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
        FastList result = FastList.newList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(function.valueOf(this.values[i]));
        }
        return result;
    }

    public int count(ShortPredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectShortToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public short max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        short max = 0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.values[i]) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    public short min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        short min = 0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    public short maxIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        short max = 0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.values[i]) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    public short minIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        short min = 0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        short[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            short first = sortedArray[middleIndex];
            short second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public MutableShortList toList() {
        ShortArrayList result = new ShortArrayList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableShortSet toSet() {
        ShortHashSet result = new ShortHashSet(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableShortBag toBag() {
        ShortHashBag result = new ShortHashBag(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public short[] toSortedArray() {
        short[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableShortList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.hashingStrategy);
        out.writeInt(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            out.writeObject(this.toNonSentinel(this.keys[i]));
            out.writeShort(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.hashingStrategy = (HashingStrategy)in.readObject();
        int size = in.readInt();
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(size * 2));
        this.allocateTable(capacity);
        for (int i = 0; i < size; ++i) {
            this.put(in.readObject(), in.readShort());
        }
    }

    public LazyIterable<K> keysView() {
        return new KeysView();
    }

    public RichIterable<ObjectShortPair<K>> keyValuesView() {
        return new KeyValuesView();
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        Object[] old = this.keys;
        short[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(old[i])) continue;
            this.put(this.toNonSentinel(old[i]), oldValues[i]);
        }
    }

    int probe(Object element) {
        int index = this.spread(element);
        int removedIndex = -1;
        if (ObjectShortHashMapWithHashingStrategy.isRemovedKey(this.keys[index])) {
            removedIndex = index;
        } else if (this.keys[index] == null || this.nullSafeEquals(this.toNonSentinel(this.keys[index]), element)) {
            return index;
        }
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (ObjectShortHashMapWithHashingStrategy.isRemovedKey(this.keys[nextIndex &= this.keys.length - 1])) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.nullSafeEquals(this.toNonSentinel(this.keys[nextIndex]), element)) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == null) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(Object element) {
        K nonSentinelKey = this.toNonSentinel(element);
        int h = nonSentinelKey == null ? 0 : this.hashingStrategy.computeHashCode(nonSentinelKey);
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.keys.length - 1;
    }

    private boolean nullSafeEquals(K value, Object other) {
        return value == null ? other == null : value != NULL_KEY && other != null && this.hashingStrategy.equals(value, this.toNonSentinel(other));
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new Object[sizeToAllocate];
        this.values = new short[sizeToAllocate];
    }

    private static boolean isRemovedKey(Object key) {
        return key == REMOVED_KEY;
    }

    private static <K> boolean isNonSentinel(K key) {
        return key != null && !ObjectShortHashMapWithHashingStrategy.isRemovedKey(key);
    }

    private K toNonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public Set<K> keySet() {
        return new KeySet();
    }

    public MutableShortCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ Object[] access$302(ObjectShortHashMapWithHashingStrategy x0, Object[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ short[] access$502(ObjectShortHashMapWithHashingStrategy x0, short[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<ObjectShortPair<K>> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super ObjectShortPair<K>> procedure) {
            for (int i = 0; i < ObjectShortHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(ObjectShortHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectShortHashMapWithHashingStrategy.this.toNonSentinel(ObjectShortHashMapWithHashingStrategy.this.keys[i]), ObjectShortHashMapWithHashingStrategy.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ObjectShortPair<K>> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectShortHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(ObjectShortHashMapWithHashingStrategy.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ObjectShortHashMapWithHashingStrategy.this.toNonSentinel(ObjectShortHashMapWithHashingStrategy.this.keys[i]), ObjectShortHashMapWithHashingStrategy.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ObjectShortPair<K>, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectShortHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(ObjectShortHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectShortHashMapWithHashingStrategy.this.toNonSentinel(ObjectShortHashMapWithHashingStrategy.this.keys[i]), ObjectShortHashMapWithHashingStrategy.this.values[i]), parameter);
            }
        }

        public Iterator<ObjectShortPair<K>> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<ObjectShortPair<K>> {
            private int count;
            private int position;

            @Override
            public ObjectShortPair<K> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectShortHashMapWithHashingStrategy.this.keys;
                while (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ObjectShortPair<Object> result = PrimitiveTuples.pair(ObjectShortHashMapWithHashingStrategy.this.toNonSentinel(ObjectShortHashMapWithHashingStrategy.this.keys[this.position]), ObjectShortHashMapWithHashingStrategy.this.values[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectShortHashMapWithHashingStrategy.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    extends AbstractLazyIterable<K> {
        private KeysView() {
        }

        public void each(Procedure<? super K> procedure) {
            ObjectShortHashMapWithHashingStrategy.this.forEachKey(procedure);
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super K> objectShortProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectShortHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(ObjectShortHashMapWithHashingStrategy.this.keys[i])) continue;
                objectShortProcedure.value(ObjectShortHashMapWithHashingStrategy.this.toNonSentinel(ObjectShortHashMapWithHashingStrategy.this.keys[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super K, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectShortHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(ObjectShortHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(ObjectShortHashMapWithHashingStrategy.this.toNonSentinel(ObjectShortHashMapWithHashingStrategy.this.keys[i]), parameter);
            }
        }

        public Iterator<K> iterator() {
            return new InternalKeysViewIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeysViewIterator
        implements Iterator<K> {
            private int count;
            private int position;

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectShortHashMapWithHashingStrategy.this.keys;
                while (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                Object result = ObjectShortHashMapWithHashingStrategy.this.toNonSentinel(ObjectShortHashMapWithHashingStrategy.this.keys[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectShortHashMapWithHashingStrategy.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableShortCollection {
        private ValuesCollection() {
        }

        public int size() {
            return ObjectShortHashMapWithHashingStrategy.this.size();
        }

        public boolean isEmpty() {
            return ObjectShortHashMapWithHashingStrategy.this.isEmpty();
        }

        public boolean notEmpty() {
            return ObjectShortHashMapWithHashingStrategy.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                for (int i = 0; i < ObjectShortHashMapWithHashingStrategy.this.keys.length; ++i) {
                    Object key = ObjectShortHashMapWithHashingStrategy.this.keys[i];
                    if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ObjectShortHashMapWithHashingStrategy.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean add(short element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(short ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(ShortIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(short item) {
            int oldSize = ObjectShortHashMapWithHashingStrategy.this.size();
            for (int i = 0; i < ObjectShortHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(ObjectShortHashMapWithHashingStrategy.this.keys[i]) || item != ObjectShortHashMapWithHashingStrategy.this.values[i]) continue;
                ObjectShortHashMapWithHashingStrategy.this.removeKey(ObjectShortHashMapWithHashingStrategy.this.keys[i]);
            }
            return oldSize != ObjectShortHashMapWithHashingStrategy.this.size();
        }

        public boolean removeAll(ShortIterable source) {
            int oldSize = ObjectShortHashMapWithHashingStrategy.this.size();
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ObjectShortHashMapWithHashingStrategy.this.size();
        }

        public boolean removeAll(short ... source) {
            int oldSize = ObjectShortHashMapWithHashingStrategy.this.size();
            for (short item : source) {
                this.remove(item);
            }
            return oldSize != ObjectShortHashMapWithHashingStrategy.this.size();
        }

        public boolean retainAll(ShortIterable source) {
            int oldSize = ObjectShortHashMapWithHashingStrategy.this.size();
            Object sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
            MutableObjectShortMap retained = ObjectShortHashMapWithHashingStrategy.this.select(new ObjectShortPredicate<K>((ShortSet)sourceSet){
                final /* synthetic */ ShortSet val$sourceSet;
                {
                    this.val$sourceSet = shortSet;
                }

                public boolean accept(K object, short value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                ObjectShortHashMapWithHashingStrategy.access$302(ObjectShortHashMapWithHashingStrategy.this, ((ObjectShortHashMapWithHashingStrategy)retained).keys);
                ObjectShortHashMapWithHashingStrategy.access$502(ObjectShortHashMapWithHashingStrategy.this, ((ObjectShortHashMapWithHashingStrategy)retained).values);
                ObjectShortHashMapWithHashingStrategy.this.occupiedWithData = ((ObjectShortHashMapWithHashingStrategy)retained).occupiedWithData;
                ObjectShortHashMapWithHashingStrategy.this.occupiedWithSentinels = ((ObjectShortHashMapWithHashingStrategy)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(short ... source) {
            return this.retainAll(ShortHashSet.newSetWith(source));
        }

        public void clear() {
            ObjectShortHashMapWithHashingStrategy.this.clear();
        }

        public MutableShortCollection with(short element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection without(short element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection withAll(ShortIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection withoutAll(ShortIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection asUnmodifiable() {
            return UnmodifiableShortCollection.of(this);
        }

        public MutableShortCollection asSynchronized() {
            return SynchronizedShortCollection.of(this);
        }

        public ImmutableShortCollection toImmutable() {
            return ShortLists.immutable.withAll((ShortIterable)this);
        }

        public MutableShortIterator shortIterator() {
            return ObjectShortHashMapWithHashingStrategy.this.shortIterator();
        }

        public short[] toArray() {
            return ObjectShortHashMapWithHashingStrategy.this.toArray();
        }

        public boolean contains(short value) {
            return ObjectShortHashMapWithHashingStrategy.this.containsValue(value);
        }

        public boolean containsAll(short ... source) {
            return ObjectShortHashMapWithHashingStrategy.this.containsAll(source);
        }

        public boolean containsAll(ShortIterable source) {
            return ObjectShortHashMapWithHashingStrategy.this.containsAll(source);
        }

        public void forEach(ShortProcedure procedure) {
            ObjectShortHashMapWithHashingStrategy.this.forEach(procedure);
        }

        public void each(ShortProcedure procedure) {
            this.forEach(procedure);
        }

        public MutableShortCollection select(ShortPredicate predicate) {
            return ObjectShortHashMapWithHashingStrategy.this.select(predicate);
        }

        public MutableShortCollection reject(ShortPredicate predicate) {
            return ObjectShortHashMapWithHashingStrategy.this.reject(predicate);
        }

        public <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
            return ObjectShortHashMapWithHashingStrategy.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
            return ObjectShortHashMapWithHashingStrategy.this.injectInto(injectedValue, function);
        }

        public short detectIfNone(ShortPredicate predicate, short ifNone) {
            return ObjectShortHashMapWithHashingStrategy.this.detectIfNone(predicate, ifNone);
        }

        public int count(ShortPredicate predicate) {
            return ObjectShortHashMapWithHashingStrategy.this.count(predicate);
        }

        public boolean anySatisfy(ShortPredicate predicate) {
            return ObjectShortHashMapWithHashingStrategy.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(ShortPredicate predicate) {
            return ObjectShortHashMapWithHashingStrategy.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(ShortPredicate predicate) {
            return ObjectShortHashMapWithHashingStrategy.this.noneSatisfy(predicate);
        }

        public MutableShortList toList() {
            return ObjectShortHashMapWithHashingStrategy.this.toList();
        }

        public MutableShortSet toSet() {
            return ObjectShortHashMapWithHashingStrategy.this.toSet();
        }

        public MutableShortBag toBag() {
            return ObjectShortHashMapWithHashingStrategy.this.toBag();
        }

        public LazyShortIterable asLazy() {
            return new LazyShortIterableAdapter((ShortIterable)this);
        }

        public short[] toSortedArray() {
            return ObjectShortHashMapWithHashingStrategy.this.toSortedArray();
        }

        public MutableShortList toSortedList() {
            return ObjectShortHashMapWithHashingStrategy.this.toSortedList();
        }

        public long sum() {
            return ObjectShortHashMapWithHashingStrategy.this.sum();
        }

        public short max() {
            return ObjectShortHashMapWithHashingStrategy.this.max();
        }

        public short maxIfEmpty(short defaultValue) {
            return ObjectShortHashMapWithHashingStrategy.this.maxIfEmpty(defaultValue);
        }

        public short min() {
            return ObjectShortHashMapWithHashingStrategy.this.min();
        }

        public short minIfEmpty(short defaultValue) {
            return ObjectShortHashMapWithHashingStrategy.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return ObjectShortHashMapWithHashingStrategy.this.average();
        }

        public double median() {
            return ObjectShortHashMapWithHashingStrategy.this.median();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySetIterator
    implements Iterator<K> {
        private int count;
        private int position;
        private K currentKey;
        private boolean isCurrentKeySet;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ObjectShortHashMapWithHashingStrategy.this.size();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Object[] keys = ObjectShortHashMapWithHashingStrategy.this.keys;
            while (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = ObjectShortHashMapWithHashingStrategy.this.keys[this.position];
            this.isCurrentKeySet = true;
            ++this.position;
            return ObjectShortHashMapWithHashingStrategy.this.toNonSentinel(this.currentKey);
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ObjectShortHashMapWithHashingStrategy.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ObjectShortHashMapWithHashingStrategy.this.removeKeyAtIndex(ObjectShortHashMapWithHashingStrategy.this.toNonSentinel(this.currentKey), index);
            } else {
                ObjectShortHashMapWithHashingStrategy.this.removeKey(this.currentKey);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public boolean equals(Object obj) {
            Set other;
            if (obj instanceof Set && (other = (Set)obj).size() == this.size()) {
                return this.containsAll(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            Object[] table = ObjectShortHashMapWithHashingStrategy.this.keys;
            for (int i = 0; i < table.length; ++i) {
                Object key = table[i];
                if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                Object nonSentinelKey = ObjectShortHashMapWithHashingStrategy.this.toNonSentinel(key);
                hashCode += nonSentinelKey == null ? 0 : ObjectShortHashMapWithHashingStrategy.this.hashingStrategy.computeHashCode(nonSentinelKey);
            }
            return hashCode;
        }

        @Override
        public int size() {
            return ObjectShortHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectShortHashMapWithHashingStrategy.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObjectShortHashMapWithHashingStrategy.this.containsKey(o);
        }

        @Override
        public Object[] toArray() {
            int size = ObjectShortHashMapWithHashingStrategy.this.size();
            Object[] result = new Object[size];
            this.copyKeys(result);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] result) {
            int size = ObjectShortHashMapWithHashingStrategy.this.size();
            if (result.length < size) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), size);
            }
            this.copyKeys(result);
            if (size < result.length) {
                result[size] = null;
            }
            return result;
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(Object key) {
            int oldSize = ObjectShortHashMapWithHashingStrategy.this.size();
            ObjectShortHashMapWithHashingStrategy.this.removeKey(key);
            return oldSize != ObjectShortHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object aCollection : collection) {
                if (ObjectShortHashMapWithHashingStrategy.this.containsKey(aCollection)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = ObjectShortHashMapWithHashingStrategy.this.size();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (collection.contains(next)) continue;
                iterator.remove();
            }
            return oldSize != ObjectShortHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = ObjectShortHashMapWithHashingStrategy.this.size();
            for (Object object : collection) {
                ObjectShortHashMapWithHashingStrategy.this.removeKey(object);
            }
            return oldSize != ObjectShortHashMapWithHashingStrategy.this.size();
        }

        @Override
        public void clear() {
            ObjectShortHashMapWithHashingStrategy.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        private void copyKeys(Object[] result) {
            int count = 0;
            for (int i = 0; i < ObjectShortHashMapWithHashingStrategy.this.keys.length; ++i) {
                Object key = ObjectShortHashMapWithHashingStrategy.this.keys[i];
                if (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                result[count++] = ObjectShortHashMapWithHashingStrategy.this.keys[i];
            }
        }
    }

    private class InternalShortIterator
    implements MutableShortIterator {
        private int count;
        private int position;

        private InternalShortIterator() {
        }

        public boolean hasNext() {
            return this.count != ObjectShortHashMapWithHashingStrategy.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] keys = ObjectShortHashMapWithHashingStrategy.this.keys;
            while (!ObjectShortHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            short result = ObjectShortHashMapWithHashingStrategy.this.values[this.position];
            ++this.count;
            ++this.position;
            return result;
        }

        public void remove() {
            if (this.position == 0 || !ObjectShortHashMapWithHashingStrategy.isNonSentinel(ObjectShortHashMapWithHashingStrategy.this.keys[this.position - 1])) {
                throw new IllegalStateException();
            }
            ObjectShortHashMapWithHashingStrategy.this.remove(ObjectShortHashMapWithHashingStrategy.this.keys[this.position - 1]);
            --this.count;
        }
    }
}

