/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.sorted.mutable;

import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.partition.list.PartitionMutableList;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.collection.mutable.CollectionAdapter;
import com.gs.collections.impl.factory.SortedMaps;
import com.gs.collections.impl.map.sorted.mutable.AbstractMutableSortedMap;
import com.gs.collections.impl.map.sorted.mutable.TreeSortedMap;
import com.gs.collections.impl.set.mutable.SetAdapter;
import com.gs.collections.impl.utility.MapIterate;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedMapAdapter<K, V>
extends AbstractMutableSortedMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SortedMap<K, V> delegate;

    protected SortedMapAdapter(SortedMap<K, V> newDelegate) {
        if (newDelegate == null) {
            throw new NullPointerException("SortedMapAdapter may not wrap null");
        }
        this.delegate = newDelegate;
    }

    public static <K, V> MutableSortedMap<K, V> adapt(SortedMap<K, V> map) {
        return map instanceof MutableSortedMap ? (MutableSortedMap)map : new SortedMapAdapter<K, V>(map);
    }

    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure) {
        MapIterate.forEachKeyValue(this.delegate, procedure);
    }

    @Deprecated
    public MutableSortedMap<K, V> newEmpty() {
        return TreeSortedMap.newMap(this.delegate.comparator());
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public Comparator<? super K> comparator() {
        return this.delegate.comparator();
    }

    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<V> iterator() {
        return this.delegate.values().iterator();
    }

    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.delegate.putAll(map);
    }

    public MutableCollection<V> values() {
        return CollectionAdapter.adapt(this.delegate.values());
    }

    public MutableSet<Map.Entry<K, V>> entrySet() {
        return SetAdapter.adapt(this.delegate.entrySet());
    }

    public MutableSet<K> keySet() {
        return SetAdapter.adapt(this.delegate.keySet());
    }

    public K firstKey() {
        return this.delegate.firstKey();
    }

    public K lastKey() {
        return this.delegate.lastKey();
    }

    public MutableSortedMap<K, V> headMap(K toKey) {
        return SortedMapAdapter.adapt(this.delegate.headMap(toKey));
    }

    public MutableSortedMap<K, V> tailMap(K fromKey) {
        return SortedMapAdapter.adapt(this.delegate.tailMap(fromKey));
    }

    public MutableSortedMap<K, V> subMap(K fromKey, K toKey) {
        return SortedMapAdapter.adapt(this.delegate.subMap(fromKey, toKey));
    }

    public void clear() {
        this.delegate.clear();
    }

    public V get(Object key) {
        return this.delegate.get(key);
    }

    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    public V removeKey(K key) {
        return this.delegate.remove(key);
    }

    /*
     * Exception decompiling
     */
    @Override
    public MutableSortedMap<K, V> with(Pair<K, V> ... pairs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public MutableSortedMap<K, V> clone() {
        return TreeSortedMap.newMap(this.delegate);
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MutableSortedMap<K, V> toReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toReversed() not implemented yet");
    }

    public MutableSortedMap<K, V> take(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        MutableSortedMap output = SortedMaps.mutable.of(this.comparator());
        Iterator<Map.Entry<K, V>> iterator = this.delegate.entrySet().iterator();
        int countCopy = count;
        while (iterator.hasNext() && countCopy-- > 0) {
            Map.Entry<K, V> next = iterator.next();
            output.put(next.getKey(), next.getValue());
        }
        return output;
    }

    public MutableSortedMap<K, V> takeWhile(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".takeWhile() not implemented yet");
    }

    public MutableSortedMap<K, V> drop(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        MutableSortedMap output = SortedMaps.mutable.of(this.comparator());
        Iterator<Map.Entry<K, V>> iterator = this.delegate.entrySet().iterator();
        int start = Math.min(count, this.size());
        if (start == this.size()) {
            return output;
        }
        int i = 0;
        while (iterator.hasNext()) {
            if (i >= start) {
                Map.Entry<K, V> next = iterator.next();
                output.put(next.getKey(), next.getValue());
            } else {
                iterator.next();
            }
            ++i;
        }
        return output;
    }

    public MutableSortedMap<K, V> dropWhile(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".dropWhile() not implemented yet");
    }

    public PartitionMutableList<V> partitionWhile(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".partitionWhile() not implemented yet");
    }

    public MutableList<V> distinct() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".distinct() not implemented yet");
    }
}

