/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.impl.block.procedure.checked.CheckedProcedure;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImmutableSetSerializationProxy<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ImmutableSet<T> set;

    public ImmutableSetSerializationProxy() {
    }

    ImmutableSetSerializationProxy(ImmutableSet<T> set) {
        this.set = set;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach((Procedure)new CheckedProcedure<T>(){

                @Override
                public void safeValue(T value) throws IOException {
                    out.writeObject(value);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        UnifiedSet deserializedSet = UnifiedSet.newSet(size);
        for (int i = 0; i < size; ++i) {
            deserializedSet.add(in.readObject());
        }
        this.set = deserializedSet.toImmutable();
    }

    protected Object readResolve() {
        return this.set;
    }
}

