/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.api.set.primitive.ImmutableFloatSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedFloatCollection;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedFloatSet
extends AbstractSynchronizedFloatCollection
implements MutableFloatSet {
    private static final long serialVersionUID = 1L;

    SynchronizedFloatSet(MutableFloatSet set) {
        super((MutableFloatCollection)set);
    }

    SynchronizedFloatSet(MutableFloatSet set, Object newLock) {
        super((MutableFloatCollection)set, newLock);
    }

    public static SynchronizedFloatSet of(MutableFloatSet set) {
        return new SynchronizedFloatSet(set);
    }

    public static SynchronizedFloatSet of(MutableFloatSet set, Object lock) {
        return new SynchronizedFloatSet(set, lock);
    }

    @GuardedBy(value="getLock()")
    private MutableFloatSet getMutableFloatSet() {
        return (MutableFloatSet)this.getFloatCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatSet without(float element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatSet().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatSet with(float element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatSet().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatSet withAll(FloatIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatSet().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatSet withoutAll(FloatIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatSet().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatSet select(FloatPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatSet reject(FloatPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatSet().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatSet().equals(otherSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyFloatIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyFloatIterableAdapter((FloatIterable)this);
        }
    }

    public MutableFloatSet asUnmodifiable() {
        return new UnmodifiableFloatSet(this);
    }

    public MutableFloatSet asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FloatSet freeze() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatSet().freeze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableFloatSet toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatSet().toImmutable();
        }
    }
}

