/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.list.primitive.ShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.ImmutableShortStack;
import com.gs.collections.api.stack.primitive.ShortStack;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.ShortStacks;
import com.gs.collections.impl.iterator.UnmodifiableShortIterator;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.stack.mutable.primitive.ShortArrayStack;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableShortSingletonStack
implements ImmutableShortStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final short element1;

    ImmutableShortSingletonStack(short element) {
        this.element1 = element;
    }

    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator(ShortArrayStack.newStackWith(this.element1).shortIterator());
    }

    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public void each(ShortProcedure procedure) {
        procedure.value(this.element1);
    }

    public int count(ShortPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public short peek() {
        return this.element1;
    }

    public ShortList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new ShortArrayList(0);
        }
        if (count == 1) {
            return ShortArrayList.newListWith(this.element1);
        }
        throw new IllegalArgumentException("Count must be less than or equal to size: Count = " + count + " Size = 1");
    }

    public short peekAt(int index) {
        this.checkNegativeCount(index);
        if (index == 0) {
            return this.element1;
        }
        throw new IllegalArgumentException("Index must be less than size: Index = " + index + " Size = 1");
    }

    public ImmutableShortStack select(ShortPredicate predicate) {
        return predicate.accept(this.element1) ? ShortStacks.immutable.with(this.element1) : ShortStacks.immutable.with();
    }

    public ImmutableShortStack reject(ShortPredicate predicate) {
        return predicate.accept(this.element1) ? ShortStacks.immutable.with() : ShortStacks.immutable.with(this.element1);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableStack<V> collect(ShortToObjectFunction<? extends V> function) {
        return Stacks.immutable.with(function.valueOf(this.element1));
    }

    public long sum() {
        return this.element1;
    }

    public short max() {
        return this.element1;
    }

    public short maxIfEmpty(short defaultValue) {
        return this.element1;
    }

    public short min() {
        return this.element1;
    }

    public short minIfEmpty(short defaultValue) {
        return this.element1;
    }

    public double average() {
        return this.element1;
    }

    public double median() {
        return this.element1;
    }

    public short[] toSortedArray() {
        return new short[]{this.element1};
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newListWith(this.element1);
    }

    public short[] toArray() {
        return new short[]{this.element1};
    }

    public boolean contains(short value) {
        return this.element1 == value;
    }

    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableShortList toList() {
        return ShortArrayList.newListWith(this.element1);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSetWith(this.element1);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBagWith(this.element1);
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public ImmutableShortStack toImmutable() {
        return this;
    }

    public ImmutableShortStack push(short element) {
        return ShortStacks.immutable.with(new short[]{this.element1, element});
    }

    public ImmutableShortStack pop() {
        return ShortStacks.immutable.with();
    }

    public ImmutableShortStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        if (count == 1) {
            return ShortStacks.immutable.with();
        }
        throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = 1");
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1);
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof ShortStack)) {
            return false;
        }
        ShortStack stack = (ShortStack)otherStack;
        if (stack.size() != 1) {
            return false;
        }
        return this.element1 == stack.peek();
    }

    public int hashCode() {
        return 31 + this.element1;
    }

    public String toString() {
        return "[" + this.element1 + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

