/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.factory.stack.primitive.MutableShortStackFactory;
import com.gs.collections.api.stack.primitive.MutableShortStack;
import com.gs.collections.impl.stack.mutable.primitive.ShortArrayStack;

public class MutableShortStackFactoryImpl
implements MutableShortStackFactory {
    public MutableShortStack empty() {
        return new ShortArrayStack();
    }

    public MutableShortStack of() {
        return this.empty();
    }

    public MutableShortStack with() {
        return this.empty();
    }

    public MutableShortStack of(short ... items) {
        return this.with(items);
    }

    public MutableShortStack with(short ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return ShortArrayStack.newStackWith(items);
    }

    public MutableShortStack ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    public MutableShortStack withAll(ShortIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return ShortArrayStack.newStack(items);
    }

    public MutableShortStack ofAllReversed(ShortIterable items) {
        return this.withAllReversed(items);
    }

    public MutableShortStack withAllReversed(ShortIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return ShortArrayStack.newStackFromTopToBottom(items);
    }
}

