/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.flows.llmflows;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.LlmAgent;
import com.google.adk.codeexecutors.BaseCodeExecutor;
import com.google.adk.codeexecutors.BuiltInCodeExecutor;
import com.google.adk.codeexecutors.CodeExecutionUtils;
import com.google.adk.codeexecutors.CodeExecutorContext;
import com.google.adk.events.Event;
import com.google.adk.events.EventActions;
import com.google.adk.flows.llmflows.RequestProcessor;
import com.google.adk.flows.llmflows.ResponseProcessor;
import com.google.adk.models.LlmRequest;
import com.google.adk.models.LlmResponse;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.genai.types.Blob;
import com.google.genai.types.Content;
import com.google.genai.types.Part;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class CodeExecution {
    public static final RequestProcessor requestProcessor = new CodeExecutionRequestProcessor();
    public static final ResponseProcessor responseProcessor = new CodeExecutionResponseProcessor();
    private static final ImmutableMap<String, DataFileUtil> DATA_FILE_UTIL_MAP = ImmutableMap.of((Object)"text/csv", (Object)new DataFileUtil(".csv", "pd.read_csv('{filename}')"));
    private static final String DATA_FILE_HELPER_LIB = "\"\"\"\nimport pandas as pd\n\ndef explore_df(df: pd.DataFrame) -> None:\n  \"\"\"Prints some information about a pandas DataFrame.\"\"\"\n\n  with pd.option_context(\n      'display.max_columns', None, 'display.expand_frame_repr', False\n  ):\n    # Print the column names to never encounter KeyError when selecting one.\n    df_dtypes = df.dtypes\n\n    # Obtain information about data types and missing values.\n    df_nulls = (len(df) - df.isnull().sum()).apply(\n        lambda x: f'{x} / {df.shape[0]} non-null'\n    )\n\n    # Explore unique total values in columns using `.unique()`.\n    df_unique_count = df.apply(lambda x: len(x.unique()))\n\n    # Explore unique values in columns using `.unique()`.\n    df_unique = df.apply(lambda x: crop(str(list(x.unique()))))\n\n    df_info = pd.concat(\n        (\n            df_dtypes.rename('Dtype'),\n            df_nulls.rename('Non-Null Count'),\n            df_unique_count.rename('Unique Values Count'),\n            df_unique.rename('Unique Values'),\n        ),\n        axis=1,\n    )\n    df_info.index.name = 'Columns'\n    print(f\"\"\"Total rows: {df.shape[0]}\nTotal columns: {df.shape[1]}\n\n{df_info}\"\"\")\n\"\"\"";

    private CodeExecution() {
    }

    private static Flowable<Event> runPreProcessor(InvocationContext invocationContext, LlmRequest llmRequest) {
        BaseAgent baseAgent = invocationContext.agent();
        if (!(baseAgent instanceof LlmAgent)) {
            return Flowable.empty();
        }
        LlmAgent llmAgent = (LlmAgent)baseAgent;
        BaseCodeExecutor codeExecutor = llmAgent.codeExecutor();
        if (codeExecutor == null) {
            return Flowable.empty();
        }
        if (codeExecutor instanceof BuiltInCodeExecutor) {
            return Flowable.empty();
        }
        if (!codeExecutor.optimizeDataFile()) {
            return Flowable.empty();
        }
        CodeExecutorContext codeExecutorContext = new CodeExecutorContext(invocationContext.session().state());
        if (codeExecutorContext.getErrorCount(invocationContext.invocationId()) >= codeExecutor.errorRetryAttempts()) {
            return Flowable.empty();
        }
        List<CodeExecutionUtils.File> allInputFiles = CodeExecution.extractAndReplaceInlineFiles(codeExecutorContext, llmRequest);
        HashSet<String> processedFileNames = new HashSet<String>(codeExecutorContext.getProcessedFileNames());
        ImmutableList filesToProcess = (ImmutableList)allInputFiles.stream().filter(f -> !processedFileNames.contains(f.name())).collect(ImmutableList.toImmutableList());
        return Flowable.fromIterable((Iterable)filesToProcess).concatMap(file -> {
            Optional<String> codeStrOptional = CodeExecution.getDataFilePreprocessingCode(file);
            if (codeStrOptional.isEmpty()) {
                return Flowable.empty();
            }
            String codeStr = codeStrOptional.get();
            Content codeContent = Content.builder().role("model").parts(new Part[]{Part.fromText((String)String.format("Processing input file: `%s`", file.name())), CodeExecutionUtils.buildExecutableCodePart(codeStr)}).build();
            llmRequest.contents().add(codeContent);
            Event codeEvent = Event.builder().invocationId(invocationContext.invocationId()).author(llmAgent.name()).content(Optional.of(codeContent)).build();
            return Flowable.defer(() -> {
                CodeExecutionUtils.CodeExecutionResult codeExecutionResult = codeExecutor.executeCode(invocationContext, CodeExecutionUtils.CodeExecutionInput.builder().code(codeStr).inputFiles((List<CodeExecutionUtils.File>)ImmutableList.of((Object)file)).executionId(CodeExecution.getOrSetExecutionId(invocationContext, codeExecutorContext)).build());
                codeExecutorContext.updateCodeExecutionResult(invocationContext.invocationId(), codeStr, codeExecutionResult.stdout(), codeExecutionResult.stderr());
                codeExecutorContext.addProcessedFileNames((List<String>)ImmutableList.of((Object)file.name()));
                return CodeExecution.postProcessCodeExecutionResult(invocationContext, codeExecutorContext, codeExecutionResult).toFlowable();
            }).doOnNext(executionResultEvent -> llmRequest.contents().add(executionResultEvent.content().orElse(Content.builder().build()))).map(executionResultEvent -> ImmutableList.of((Object)codeEvent, (Object)executionResultEvent)).flatMap(Flowable::fromIterable);
        });
    }

    private static Flowable<Event> runPostProcessor(InvocationContext invocationContext, LlmResponse.Builder llmResponseBuilder) {
        LlmResponse llmResponse = llmResponseBuilder.build();
        BaseAgent baseAgent = invocationContext.agent();
        if (!(baseAgent instanceof LlmAgent)) {
            return Flowable.empty();
        }
        LlmAgent llmAgent = (LlmAgent)baseAgent;
        BaseCodeExecutor codeExecutor = llmAgent.codeExecutor();
        if (codeExecutor == null) {
            return Flowable.empty();
        }
        if (llmResponse.content().isEmpty()) {
            return Flowable.empty();
        }
        if (codeExecutor instanceof BuiltInCodeExecutor) {
            return Flowable.empty();
        }
        CodeExecutorContext codeExecutorContext = new CodeExecutorContext(invocationContext.session().state());
        if (codeExecutorContext.getErrorCount(invocationContext.invocationId()) >= codeExecutor.errorRetryAttempts()) {
            return Flowable.empty();
        }
        Content responseContent = llmResponse.content().get();
        Content.Builder responseContentBuilder = responseContent.toBuilder();
        Optional<String> codeStrOptional = CodeExecutionUtils.extractCodeAndTruncateContent(responseContentBuilder, codeExecutor.codeBlockDelimiters());
        if (codeStrOptional.isEmpty()) {
            return Flowable.empty();
        }
        String codeStr = codeStrOptional.get();
        responseContent = responseContentBuilder.build();
        llmResponseBuilder.content(Optional.empty());
        Event codeEvent = Event.builder().invocationId(invocationContext.invocationId()).author(llmAgent.name()).content(Optional.of(responseContent)).actions(EventActions.builder().build()).build();
        return Flowable.defer(() -> {
            CodeExecutionUtils.CodeExecutionResult codeExecutionResult = codeExecutor.executeCode(invocationContext, CodeExecutionUtils.CodeExecutionInput.builder().code(codeStr).inputFiles(codeExecutorContext.getInputFiles()).executionId(CodeExecution.getOrSetExecutionId(invocationContext, codeExecutorContext)).build());
            codeExecutorContext.updateCodeExecutionResult(invocationContext.invocationId(), codeStr, codeExecutionResult.stdout(), codeExecutionResult.stderr());
            return CodeExecution.postProcessCodeExecutionResult(invocationContext, codeExecutorContext, codeExecutionResult).toFlowable();
        }).map(executionResultEvent -> ImmutableList.of((Object)codeEvent, (Object)executionResultEvent)).flatMap(Flowable::fromIterable);
    }

    private static List<CodeExecutionUtils.File> extractAndReplaceInlineFiles(CodeExecutorContext codeExecutorContext, LlmRequest llmRequest) {
        ArrayList<CodeExecutionUtils.File> allInputFiles = new ArrayList<CodeExecutionUtils.File>(codeExecutorContext.getInputFiles());
        Set savedFileNames = allInputFiles.stream().map(CodeExecutionUtils.File::name).collect(Collectors.toCollection(HashSet::new));
        for (int i = 0; i < llmRequest.contents().size(); ++i) {
            Content content = llmRequest.contents().get(i);
            if (content.role().isEmpty() || !Objects.equals(content.role().get(), "user") || content.parts().isEmpty()) continue;
            ArrayList<Part> newParts = new ArrayList<Part>((Collection)content.parts().get());
            boolean modified = false;
            for (int j = 0; j < newParts.size(); ++j) {
                Part part = (Part)newParts.get(j);
                if (part.inlineData().isEmpty() || ((Blob)part.inlineData().get()).mimeType().isEmpty() || !DATA_FILE_UTIL_MAP.containsKey(((Blob)part.inlineData().get()).mimeType().get())) continue;
                modified = true;
                String mimeType = (String)((Blob)part.inlineData().get()).mimeType().get();
                String fileName = String.format("data_%d_%d", i + 1, j + 1) + ((DataFileUtil)DATA_FILE_UTIL_MAP.get((Object)mimeType)).extension();
                newParts.set(j, Part.fromText((String)String.format("\nAvailable file: `%s`\n", fileName)));
                CodeExecutionUtils.File file = CodeExecutionUtils.File.builder().name(fileName).content(new String(Base64.getEncoder().encode((byte[])((Blob)part.inlineData().get()).data().get()), StandardCharsets.UTF_8)).mimeType(mimeType).build();
                if (savedFileNames.contains(fileName)) continue;
                codeExecutorContext.addInputFiles((List<CodeExecutionUtils.File>)ImmutableList.of((Object)file));
                allInputFiles.add(file);
                savedFileNames.add(fileName);
            }
            if (!modified) continue;
            Content newContent = content.toBuilder().parts(newParts).build();
            llmRequest.contents().set(i, newContent);
        }
        return allInputFiles;
    }

    private static Optional<String> getOrSetExecutionId(InvocationContext invocationContext, CodeExecutorContext codeExecutorContext) {
        LlmAgent llmAgent;
        BaseAgent baseAgent = invocationContext.agent();
        if (!(baseAgent instanceof LlmAgent) || (llmAgent = (LlmAgent)baseAgent).codeExecutor() == null || !llmAgent.codeExecutor().stateful()) {
            return Optional.empty();
        }
        Optional<String> executionId = codeExecutorContext.getExecutionId();
        if (executionId.isEmpty()) {
            String newExecutionId = invocationContext.session().id();
            codeExecutorContext.setExecutionId(newExecutionId);
            return Optional.of(newExecutionId);
        }
        return executionId;
    }

    private static Single<Event> postProcessCodeExecutionResult(InvocationContext invocationContext, CodeExecutorContext codeExecutorContext, CodeExecutionUtils.CodeExecutionResult codeExecutionResult) {
        if (invocationContext.artifactService() == null) {
            return Single.error((Throwable)new IllegalStateException("Artifact service is not initialized."));
        }
        Content resultContent = Content.builder().role("model").parts(new Part[]{CodeExecutionUtils.buildCodeExecutionResultPart(codeExecutionResult)}).build();
        EventActions.Builder eventActionsBuilder = EventActions.builder().stateDelta(new ConcurrentHashMap<String, Object>(codeExecutorContext.getStateDelta()));
        if (codeExecutionResult.stderr() != null && !codeExecutionResult.stderr().isEmpty()) {
            codeExecutorContext.incrementErrorCount(invocationContext.invocationId());
        } else {
            codeExecutorContext.resetErrorCount(invocationContext.invocationId());
        }
        return Flowable.fromIterable(codeExecutionResult.outputFiles()).concatMapSingle(outputFile -> invocationContext.artifactService().saveArtifact(invocationContext.appName(), invocationContext.userId(), invocationContext.session().id(), outputFile.name(), Part.fromBytes((byte[])Base64.getDecoder().decode(outputFile.content()), (String)outputFile.mimeType()))).toList().map(versions -> {
            ConcurrentHashMap<String, Part> artifactDelta = new ConcurrentHashMap<String, Part>();
            for (int i = 0; i < versions.size(); ++i) {
                artifactDelta.put(((CodeExecutionUtils.File)codeExecutionResult.outputFiles().get(i)).name(), Part.fromText((String)String.valueOf(versions.get(i))));
            }
            eventActionsBuilder.artifactDelta(artifactDelta);
            return Event.builder().invocationId(invocationContext.invocationId()).author(invocationContext.agent().name()).content(Optional.of(resultContent)).actions(eventActionsBuilder.build()).build();
        });
    }

    private static Optional<String> getDataFilePreprocessingCode(CodeExecutionUtils.File file) {
        if (!DATA_FILE_UTIL_MAP.containsKey((Object)file.mimeType())) {
            return Optional.empty();
        }
        String varName = CodeExecution.getNormalizedFileName(file.name());
        String loaderCode = ((DataFileUtil)DATA_FILE_UTIL_MAP.get((Object)file.mimeType())).loaderCodeTemplate().replace("{filename}", file.name());
        return Optional.of(String.format("\"\"\"\n%s\n\n# Load the dataframe.\n%s = %s\n\n# Use `explore_df` to guide my analysis.\nexplore_df(%s)\n\"\"\"", DATA_FILE_HELPER_LIB, varName, loaderCode, varName));
    }

    private static String getNormalizedFileName(String fileName) {
        Object varName = Path.of(fileName, new String[0]).getFileName().toString();
        int dotIndex = ((String)varName).lastIndexOf(46);
        if (dotIndex != -1) {
            varName = ((String)varName).substring(0, dotIndex);
        }
        if (!((String)(varName = ((String)varName).replaceAll("[^a-zA-Z0-9_]", "_"))).isEmpty() && Character.isDigit(((String)varName).charAt(0))) {
            varName = "_" + (String)varName;
        }
        return varName;
    }

    private record DataFileUtil(String extension, String loaderCodeTemplate) {
    }

    private static class CodeExecutionRequestProcessor
    implements RequestProcessor {
        private CodeExecutionRequestProcessor() {
        }

        @Override
        public Single<RequestProcessor.RequestProcessingResult> processRequest(InvocationContext invocationContext, LlmRequest llmRequest) {
            LlmAgent llmAgent;
            BaseAgent baseAgent = invocationContext.agent();
            if (!(baseAgent instanceof LlmAgent) || (llmAgent = (LlmAgent)baseAgent).codeExecutor() == null) {
                return Single.just((Object)RequestProcessor.RequestProcessingResult.create(llmRequest, (Iterable<Event>)ImmutableList.of()));
            }
            BaseCodeExecutor baseCodeExecutor = llmAgent.codeExecutor();
            if (baseCodeExecutor instanceof BuiltInCodeExecutor) {
                BuiltInCodeExecutor builtInCodeExecutor = (BuiltInCodeExecutor)baseCodeExecutor;
                LlmRequest.Builder llmRequestBuilder = llmRequest.toBuilder();
                builtInCodeExecutor.processLlmRequest(llmRequestBuilder);
                LlmRequest updatedLlmRequest = llmRequestBuilder.build();
                return Single.just((Object)RequestProcessor.RequestProcessingResult.create(updatedLlmRequest, (Iterable<Event>)ImmutableList.of()));
            }
            Flowable<Event> preprocessorEvents = CodeExecution.runPreProcessor(invocationContext, llmRequest);
            if (llmAgent.codeExecutor() != null) {
                BaseCodeExecutor baseCodeExecutor2 = llmAgent.codeExecutor();
                ArrayList<Content> updatedContents = new ArrayList<Content>();
                for (Content content : llmRequest.contents()) {
                    ImmutableList delimiters = !baseCodeExecutor2.codeBlockDelimiters().isEmpty() ? baseCodeExecutor2.codeBlockDelimiters().get(0) : ImmutableList.of((Object)"", (Object)"");
                    updatedContents.add(CodeExecutionUtils.convertCodeExecutionParts(content, (List<String>)delimiters, baseCodeExecutor2.executionResultDelimiters()));
                }
                llmRequest = llmRequest.toBuilder().contents(updatedContents).build();
            }
            LlmRequest finalLlmRequest = llmRequest;
            return preprocessorEvents.toList().map(events -> RequestProcessor.RequestProcessingResult.create(finalLlmRequest, (Iterable<Event>)ImmutableList.copyOf((Collection)events)));
        }
    }

    private static class CodeExecutionResponseProcessor
    implements ResponseProcessor {
        private CodeExecutionResponseProcessor() {
        }

        @Override
        public Single<ResponseProcessor.ResponseProcessingResult> processResponse(InvocationContext invocationContext, LlmResponse llmResponse) {
            if (llmResponse.partial().orElse(false).booleanValue()) {
                return Single.just((Object)ResponseProcessor.ResponseProcessingResult.create(llmResponse, (Iterable<Event>)ImmutableList.of(), Optional.empty()));
            }
            LlmResponse.Builder llmResponseBuilder = llmResponse.toBuilder();
            return CodeExecution.runPostProcessor(invocationContext, llmResponseBuilder).toList().map(events -> ResponseProcessor.ResponseProcessingResult.create(llmResponseBuilder.build(), events, Optional.empty()));
        }
    }
}

