/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.models;

import com.google.adk.models.BaseLlm;
import com.google.adk.models.Model;
import java.util.Optional;

final class AutoValue_Model
extends Model {
    private final Optional<String> modelName;
    private final Optional<BaseLlm> model;

    private AutoValue_Model(Optional<String> modelName, Optional<BaseLlm> model) {
        this.modelName = modelName;
        this.model = model;
    }

    @Override
    public Optional<String> modelName() {
        return this.modelName;
    }

    @Override
    public Optional<BaseLlm> model() {
        return this.model;
    }

    public String toString() {
        return "Model{modelName=" + String.valueOf(this.modelName) + ", model=" + String.valueOf(this.model) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Model) {
            Model that = (Model)o;
            return this.modelName.equals(that.modelName()) && this.model.equals(that.model());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.modelName.hashCode();
        h$ *= 1000003;
        return h$ ^= this.model.hashCode();
    }

    @Override
    public Model.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Model.Builder {
        private Optional<String> modelName = Optional.empty();
        private Optional<BaseLlm> model = Optional.empty();

        Builder() {
        }

        Builder(Model source) {
            this.modelName = source.modelName();
            this.model = source.model();
        }

        @Override
        public Model.Builder modelName(String modelName) {
            this.modelName = Optional.of(modelName);
            return this;
        }

        @Override
        public Model.Builder model(BaseLlm model) {
            this.model = Optional.of(model);
            return this;
        }

        @Override
        public Model build() {
            return new AutoValue_Model(this.modelName, this.model);
        }
    }
}

