/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.plugins;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.CallbackContext;
import com.google.adk.agents.InvocationContext;
import com.google.adk.events.Event;
import com.google.adk.models.LlmRequest;
import com.google.adk.models.LlmResponse;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolContext;
import com.google.genai.types.Content;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import java.util.Map;

public abstract class BasePlugin {
    protected final String name;

    public BasePlugin(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Maybe<Content> onUserMessageCallback(InvocationContext invocationContext, Content userMessage) {
        return Maybe.empty();
    }

    public Maybe<Content> beforeRunCallback(InvocationContext invocationContext) {
        return Maybe.empty();
    }

    public Maybe<Event> onEventCallback(InvocationContext invocationContext, Event event) {
        return Maybe.empty();
    }

    public Completable afterRunCallback(InvocationContext invocationContext) {
        return Completable.complete();
    }

    public Maybe<Content> beforeAgentCallback(BaseAgent agent, CallbackContext callbackContext) {
        return Maybe.empty();
    }

    public Maybe<Content> afterAgentCallback(BaseAgent agent, CallbackContext callbackContext) {
        return Maybe.empty();
    }

    public Maybe<LlmResponse> beforeModelCallback(CallbackContext callbackContext, LlmRequest llmRequest) {
        return Maybe.empty();
    }

    public Maybe<LlmResponse> afterModelCallback(CallbackContext callbackContext, LlmResponse llmResponse) {
        return Maybe.empty();
    }

    public Maybe<LlmResponse> onModelErrorCallback(CallbackContext callbackContext, LlmRequest llmRequest, Throwable error) {
        return Maybe.empty();
    }

    public Maybe<Map<String, Object>> beforeToolCallback(BaseTool tool, Map<String, Object> toolArgs, ToolContext toolContext) {
        return Maybe.empty();
    }

    public Maybe<Map<String, Object>> afterToolCallback(BaseTool tool, Map<String, Object> toolArgs, ToolContext toolContext, Map<String, Object> result) {
        return Maybe.empty();
    }

    public Maybe<Map<String, Object>> onToolErrorCallback(BaseTool tool, Map<String, Object> toolArgs, ToolContext toolContext, Throwable error) {
        return Maybe.empty();
    }
}

