/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.tools.ToolContext;
import com.google.adk.tools.mcp.AbstractMcpTool;
import com.google.adk.tools.mcp.McpSessionManager;
import com.google.common.collect.ImmutableMap;
import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class McpAsyncTool
extends AbstractMcpTool<McpAsyncClient> {
    private static final Logger logger = LoggerFactory.getLogger(McpAsyncTool.class);

    public McpAsyncTool(McpSchema.Tool mcpTool, McpAsyncClient mcpSession, McpSessionManager mcpSessionManager) {
        super(mcpTool, mcpSession, mcpSessionManager, JsonBaseModel.getMapper());
    }

    public McpAsyncTool(McpSchema.Tool mcpTool, McpAsyncClient mcpSession, McpSessionManager mcpSessionManager, ObjectMapper objectMapper) {
        super(mcpTool, mcpSession, mcpSessionManager, objectMapper);
    }

    private Single<McpSchema.InitializeResult> reinitializeSession() {
        McpAsyncClient client = this.mcpSessionManager.createAsyncSession();
        return Single.fromCompletionStage((CompletionStage)client.initialize().doOnSuccess(initResult -> logger.debug("Initialize McpAsyncClient Result: {}", initResult)).doOnError(e -> logger.error("Initialize McpAsyncClient Failed: {}", (Object)e.getMessage(), e)).doOnNext(_initResult -> {
            this.mcpSession = client;
        }).toFuture());
    }

    @Override
    public Single<Map<String, Object>> runAsync(Map<String, Object> args, ToolContext toolContext) {
        return Single.defer(() -> Maybe.fromCompletionStage((CompletionStage)((McpAsyncClient)this.mcpSession).callTool(new McpSchema.CallToolRequest(this.name(), (Map)ImmutableMap.copyOf((Map)args))).toFuture()).map(callResult -> McpAsyncTool.wrapCallResult(this.objectMapper, this.name(), callResult)).switchIfEmpty((SingleSource)Single.fromCallable(() -> McpAsyncTool.wrapCallResult(this.objectMapper, this.name(), null)))).retryWhen(errors -> errors.delay(100L, TimeUnit.MILLISECONDS).take(3L).doOnNext(error -> logger.error("Retrying callTool due to: {}", (Object)error.getMessage(), error)).flatMapSingle(_ignore -> this.reinitializeSession()));
    }
}

