/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.agents.ConfigAgentUtils;
import com.google.adk.agents.ReadonlyContext;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.BaseToolset;
import com.google.adk.tools.mcp.McpSessionManager;
import com.google.adk.tools.mcp.McpTool;
import com.google.adk.tools.mcp.McpToolsetException;
import com.google.adk.tools.mcp.SseServerParameters;
import com.google.adk.tools.mcp.StdioServerParameters;
import com.google.adk.tools.mcp.StreamableHttpServerParameters;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.ServerParameters;
import io.modelcontextprotocol.spec.McpSchema;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpToolset
implements BaseToolset {
    private static final Logger logger = LoggerFactory.getLogger(McpToolset.class);
    private final McpSessionManager mcpSessionManager;
    private McpSyncClient mcpSession;
    private final ObjectMapper objectMapper;
    private final Optional<Object> toolFilter;
    private static final int MAX_RETRIES = 3;
    private static final long RETRY_DELAY_MILLIS = 100L;
    protected static final Class<? extends McpToolsetConfig> CONFIG_TYPE = McpToolsetConfig.class;

    public McpToolset(SseServerParameters connectionParams, ObjectMapper objectMapper, Optional<Object> toolFilter) {
        Objects.requireNonNull(connectionParams);
        Objects.requireNonNull(objectMapper);
        this.objectMapper = objectMapper;
        this.mcpSessionManager = new McpSessionManager(connectionParams);
        this.toolFilter = toolFilter;
    }

    public McpToolset(SseServerParameters connectionParams, ObjectMapper objectMapper) {
        this(connectionParams, objectMapper, Optional.empty());
    }

    public McpToolset(ServerParameters connectionParams, ObjectMapper objectMapper, Optional<Object> toolFilter) {
        Objects.requireNonNull(connectionParams);
        Objects.requireNonNull(objectMapper);
        this.objectMapper = objectMapper;
        this.mcpSessionManager = new McpSessionManager(connectionParams);
        this.toolFilter = toolFilter;
    }

    public McpToolset(ServerParameters connectionParams, ObjectMapper objectMapper) {
        this(connectionParams, objectMapper, Optional.empty());
    }

    public McpToolset(SseServerParameters connectionParams, Optional<Object> toolFilter) {
        this(connectionParams, JsonBaseModel.getMapper(), toolFilter);
    }

    public McpToolset(SseServerParameters connectionParams) {
        this(connectionParams, JsonBaseModel.getMapper(), Optional.empty());
    }

    public McpToolset(ServerParameters connectionParams, Optional<Object> toolFilter) {
        this(connectionParams, JsonBaseModel.getMapper(), toolFilter);
    }

    public McpToolset(ServerParameters connectionParams) {
        this(connectionParams, JsonBaseModel.getMapper(), Optional.empty());
    }

    public McpToolset(McpSessionManager mcpSessionManager, ObjectMapper objectMapper, Optional<Object> toolFilter) {
        Objects.requireNonNull(mcpSessionManager);
        Objects.requireNonNull(objectMapper);
        this.mcpSessionManager = mcpSessionManager;
        this.objectMapper = objectMapper;
        this.toolFilter = toolFilter;
    }

    public McpToolset(StreamableHttpServerParameters connectionParams, ObjectMapper objectMapper, Optional<Object> toolFilter) {
        Objects.requireNonNull(connectionParams);
        Objects.requireNonNull(objectMapper);
        this.objectMapper = objectMapper;
        this.mcpSessionManager = new McpSessionManager(connectionParams);
        this.toolFilter = toolFilter;
    }

    public McpToolset(StreamableHttpServerParameters connectionParams) {
        this(connectionParams, JsonBaseModel.getMapper(), Optional.empty());
    }

    @Override
    public Flowable<BaseTool> getTools(ReadonlyContext readonlyContext) {
        return Flowable.defer(() -> {
            if (this.mcpSession == null) {
                logger.info("MCP session is null, initializing.");
                this.mcpSession = this.mcpSessionManager.createSession();
            }
            McpSchema.ListToolsResult toolsResponse = this.mcpSession.listTools();
            return Flowable.fromStream(toolsResponse.tools().stream().map(tool -> new McpTool((McpSchema.Tool)tool, this.mcpSession, this.mcpSessionManager, this.objectMapper)).filter(tool -> this.isToolSelected((BaseTool)tool, this.toolFilter, Optional.ofNullable(readonlyContext))));
        }).retryWhen(errorObservable -> errorObservable.zipWith((Publisher)Flowable.range((int)1, (int)3), (error, retryCount) -> {
            if (error instanceof IllegalArgumentException) {
                logger.error("Invalid argument encountered during tool loading.", error);
                throw new McpToolsetException.McpToolLoadingException("Invalid argument encountered during tool loading.", (Throwable)error);
            }
            if (error instanceof RuntimeException) {
                logger.error("Unexpected error during tool loading, retry attempt " + retryCount, error);
                logger.info("Reinitializing MCP session before next retry for unexpected error.");
                this.mcpSession = null;
                if (retryCount < 3) {
                    return Flowable.timer((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                logger.error("Failed to load tools after multiple retries due to unexpected error.", error);
                throw new McpToolsetException.McpToolLoadingException("Failed to load tools after multiple retries due to unexpected error.", (Throwable)error);
            }
            return Flowable.error((Throwable)error);
        })).map(tools -> tools);
    }

    @Override
    public void close() {
        if (this.mcpSession != null) {
            try {
                this.mcpSession.close();
                logger.debug("MCP session closed successfully.");
            }
            catch (RuntimeException e) {
                logger.error("Failed to close MCP session", (Throwable)e);
            }
            finally {
                this.mcpSession = null;
            }
        }
    }

    public static McpToolset fromConfig(BaseTool.ToolConfig config, String configAbsPath) throws ConfigAgentUtils.ConfigurationException {
        if (config.args() == null) {
            throw new ConfigAgentUtils.ConfigurationException("Tool args is null for McpToolset");
        }
        ObjectMapper mapper = JsonBaseModel.getMapper();
        try {
            McpToolsetConfig mcpToolsetConfig = (McpToolsetConfig)mapper.convertValue((Object)config.args(), McpToolsetConfig.class);
            if (mcpToolsetConfig.stdioServerParams() != null == (mcpToolsetConfig.sseServerParams() != null)) {
                throw new ConfigAgentUtils.ConfigurationException("Exactly one of stdioServerParams or sseServerParams must be set for McpToolset");
            }
            Optional<Object> toolFilter = Optional.ofNullable(mcpToolsetConfig.toolFilter()).map(filter -> filter);
            if (mcpToolsetConfig.stdioServerParams() != null) {
                return new McpToolset(mcpToolsetConfig.stdioServerParams().toServerParameters(), mapper, toolFilter);
            }
            return new McpToolset(mcpToolsetConfig.sseServerParams(), mapper, toolFilter);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigAgentUtils.ConfigurationException("Failed to parse McpToolsetConfig from ToolArgsConfig", e);
        }
    }

    public static class McpToolsetConfig
    extends JsonBaseModel {
        private StdioServerParameters stdioServerParams;
        private SseServerParameters sseServerParams;
        private List<String> toolFilter;

        public StdioServerParameters stdioServerParams() {
            return this.stdioServerParams;
        }

        public void setStdioServerParams(StdioServerParameters stdioServerParams) {
            this.stdioServerParams = stdioServerParams;
        }

        public SseServerParameters sseServerParams() {
            return this.sseServerParams;
        }

        public void setSseServerParams(SseServerParameters sseServerParams) {
            this.sseServerParams = sseServerParams;
        }

        public List<String> toolFilter() {
            return this.toolFilter;
        }

        public void setToolFilter(List<String> toolFilter) {
            this.toolFilter = toolFilter;
        }
    }
}

