/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport;

import androidx.annotation.Nullable;
import com.google.android.datatransport.AutoValue_Event;
import com.google.android.datatransport.Priority;
import com.google.auto.value.AutoValue;

@AutoValue
public abstract class Event<T> {
    @Nullable
    public abstract Integer getCode();

    public abstract T getPayload();

    public abstract Priority getPriority();

    public static <T> Event<T> ofData(int code, T payload) {
        return new AutoValue_Event<T>(code, payload, Priority.DEFAULT);
    }

    public static <T> Event<T> ofData(T payload) {
        return new AutoValue_Event<T>(null, payload, Priority.DEFAULT);
    }

    public static <T> Event<T> ofTelemetry(int code, T value) {
        return new AutoValue_Event<T>(code, value, Priority.VERY_LOW);
    }

    public static <T> Event<T> ofTelemetry(T value) {
        return new AutoValue_Event<T>(null, value, Priority.VERY_LOW);
    }

    public static <T> Event<T> ofUrgent(int code, T value) {
        return new AutoValue_Event<T>(code, value, Priority.HIGHEST);
    }

    public static <T> Event<T> ofUrgent(T value) {
        return new AutoValue_Event<T>(null, value, Priority.HIGHEST);
    }
}

