/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport;

import androidx.annotation.Nullable;
import com.google.android.datatransport.AutoValue_Event;
import com.google.android.datatransport.Priority;
import com.google.android.datatransport.ProductData;
import com.google.auto.value.AutoValue;

@AutoValue
public abstract class Event<T> {
    @Nullable
    public abstract Integer getCode();

    public abstract T getPayload();

    public abstract Priority getPriority();

    @Nullable
    public abstract ProductData getProductData();

    public static <T> Event<T> ofData(int code, T payload, @Nullable ProductData productData) {
        return new AutoValue_Event<T>(code, payload, Priority.DEFAULT, productData);
    }

    public static <T> Event<T> ofData(int code, T payload) {
        return new AutoValue_Event<T>(code, payload, Priority.DEFAULT, null);
    }

    public static <T> Event<T> ofData(T payload, @Nullable ProductData productData) {
        return new AutoValue_Event<T>(null, payload, Priority.DEFAULT, productData);
    }

    public static <T> Event<T> ofData(T payload) {
        return new AutoValue_Event<T>(null, payload, Priority.DEFAULT, null);
    }

    public static <T> Event<T> ofTelemetry(int code, T value, @Nullable ProductData productData) {
        return new AutoValue_Event<T>(code, value, Priority.VERY_LOW, productData);
    }

    public static <T> Event<T> ofTelemetry(int code, T value) {
        return new AutoValue_Event<T>(code, value, Priority.VERY_LOW, null);
    }

    public static <T> Event<T> ofTelemetry(T value, @Nullable ProductData productData) {
        return new AutoValue_Event<T>(null, value, Priority.VERY_LOW, productData);
    }

    public static <T> Event<T> ofTelemetry(T value) {
        return new AutoValue_Event<T>(null, value, Priority.VERY_LOW, null);
    }

    public static <T> Event<T> ofUrgent(int code, T value, @Nullable ProductData productData) {
        return new AutoValue_Event<T>(code, value, Priority.HIGHEST, productData);
    }

    public static <T> Event<T> ofUrgent(int code, T value) {
        return new AutoValue_Event<T>(code, value, Priority.HIGHEST, null);
    }

    public static <T> Event<T> ofUrgent(T value, @Nullable ProductData productData) {
        return new AutoValue_Event<T>(null, value, Priority.HIGHEST, productData);
    }

    public static <T> Event<T> ofUrgent(T value) {
        return new AutoValue_Event<T>(null, value, Priority.HIGHEST, null);
    }
}

