/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.cct.internal;

import com.google.android.datatransport.cct.internal.AndroidClientInfo;
import com.google.android.datatransport.cct.internal.AutoValue_AndroidClientInfo;
import com.google.android.datatransport.cct.internal.AutoValue_BatchedLogRequest;
import com.google.android.datatransport.cct.internal.AutoValue_ClientInfo;
import com.google.android.datatransport.cct.internal.AutoValue_LogEvent;
import com.google.android.datatransport.cct.internal.AutoValue_LogRequest;
import com.google.android.datatransport.cct.internal.AutoValue_NetworkConnectionInfo;
import com.google.android.datatransport.cct.internal.BatchedLogRequest;
import com.google.android.datatransport.cct.internal.ClientInfo;
import com.google.android.datatransport.cct.internal.LogEvent;
import com.google.android.datatransport.cct.internal.LogRequest;
import com.google.android.datatransport.cct.internal.NetworkConnectionInfo;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.config.Configurator;
import com.google.firebase.encoders.config.EncoderConfig;
import java.io.IOException;

public final class AutoBatchedLogRequestEncoder
implements Configurator {
    public static final int CODEGEN_VERSION = 1;
    public static final Configurator CONFIG = new AutoBatchedLogRequestEncoder();

    private AutoBatchedLogRequestEncoder() {
    }

    public void configure(EncoderConfig<?> cfg) {
        cfg.registerEncoder(BatchedLogRequest.class, (ObjectEncoder)BatchedLogRequestEncoder.INSTANCE);
        cfg.registerEncoder(AutoValue_BatchedLogRequest.class, (ObjectEncoder)BatchedLogRequestEncoder.INSTANCE);
        cfg.registerEncoder(LogRequest.class, (ObjectEncoder)LogRequestEncoder.INSTANCE);
        cfg.registerEncoder(AutoValue_LogRequest.class, (ObjectEncoder)LogRequestEncoder.INSTANCE);
        cfg.registerEncoder(ClientInfo.class, (ObjectEncoder)ClientInfoEncoder.INSTANCE);
        cfg.registerEncoder(AutoValue_ClientInfo.class, (ObjectEncoder)ClientInfoEncoder.INSTANCE);
        cfg.registerEncoder(AndroidClientInfo.class, (ObjectEncoder)AndroidClientInfoEncoder.INSTANCE);
        cfg.registerEncoder(AutoValue_AndroidClientInfo.class, (ObjectEncoder)AndroidClientInfoEncoder.INSTANCE);
        cfg.registerEncoder(LogEvent.class, (ObjectEncoder)LogEventEncoder.INSTANCE);
        cfg.registerEncoder(AutoValue_LogEvent.class, (ObjectEncoder)LogEventEncoder.INSTANCE);
        cfg.registerEncoder(NetworkConnectionInfo.class, (ObjectEncoder)NetworkConnectionInfoEncoder.INSTANCE);
        cfg.registerEncoder(AutoValue_NetworkConnectionInfo.class, (ObjectEncoder)NetworkConnectionInfoEncoder.INSTANCE);
    }

    private static final class NetworkConnectionInfoEncoder
    implements ObjectEncoder<NetworkConnectionInfo> {
        static final NetworkConnectionInfoEncoder INSTANCE = new NetworkConnectionInfoEncoder();

        private NetworkConnectionInfoEncoder() {
        }

        public void encode(NetworkConnectionInfo value, ObjectEncoderContext ctx) throws IOException {
            ctx.add("networkType", (Object)value.getNetworkType());
            ctx.add("mobileSubtype", (Object)value.getMobileSubtype());
        }
    }

    private static final class LogEventEncoder
    implements ObjectEncoder<LogEvent> {
        static final LogEventEncoder INSTANCE = new LogEventEncoder();

        private LogEventEncoder() {
        }

        public void encode(LogEvent value, ObjectEncoderContext ctx) throws IOException {
            ctx.add("eventTimeMs", value.getEventTimeMs());
            ctx.add("eventCode", (Object)value.getEventCode());
            ctx.add("eventUptimeMs", value.getEventUptimeMs());
            ctx.add("sourceExtension", (Object)value.getSourceExtension());
            ctx.add("sourceExtensionJsonProto3", (Object)value.getSourceExtensionJsonProto3());
            ctx.add("timezoneOffsetSeconds", value.getTimezoneOffsetSeconds());
            ctx.add("networkConnectionInfo", (Object)value.getNetworkConnectionInfo());
        }
    }

    private static final class AndroidClientInfoEncoder
    implements ObjectEncoder<AndroidClientInfo> {
        static final AndroidClientInfoEncoder INSTANCE = new AndroidClientInfoEncoder();

        private AndroidClientInfoEncoder() {
        }

        public void encode(AndroidClientInfo value, ObjectEncoderContext ctx) throws IOException {
            ctx.add("sdkVersion", (Object)value.getSdkVersion());
            ctx.add("model", (Object)value.getModel());
            ctx.add("hardware", (Object)value.getHardware());
            ctx.add("device", (Object)value.getDevice());
            ctx.add("product", (Object)value.getProduct());
            ctx.add("osBuild", (Object)value.getOsBuild());
            ctx.add("manufacturer", (Object)value.getManufacturer());
            ctx.add("fingerprint", (Object)value.getFingerprint());
            ctx.add("locale", (Object)value.getLocale());
            ctx.add("country", (Object)value.getCountry());
            ctx.add("mccMnc", (Object)value.getMccMnc());
            ctx.add("applicationBuild", (Object)value.getApplicationBuild());
        }
    }

    private static final class ClientInfoEncoder
    implements ObjectEncoder<ClientInfo> {
        static final ClientInfoEncoder INSTANCE = new ClientInfoEncoder();

        private ClientInfoEncoder() {
        }

        public void encode(ClientInfo value, ObjectEncoderContext ctx) throws IOException {
            ctx.add("clientType", (Object)value.getClientType());
            ctx.add("androidClientInfo", (Object)value.getAndroidClientInfo());
        }
    }

    private static final class LogRequestEncoder
    implements ObjectEncoder<LogRequest> {
        static final LogRequestEncoder INSTANCE = new LogRequestEncoder();

        private LogRequestEncoder() {
        }

        public void encode(LogRequest value, ObjectEncoderContext ctx) throws IOException {
            ctx.add("requestTimeMs", value.getRequestTimeMs());
            ctx.add("requestUptimeMs", value.getRequestUptimeMs());
            ctx.add("clientInfo", (Object)value.getClientInfo());
            ctx.add("logSource", (Object)value.getLogSource());
            ctx.add("logSourceName", (Object)value.getLogSourceName());
            ctx.add("logEvent", value.getLogEvents());
            ctx.add("qosTier", (Object)value.getQosTier());
        }
    }

    private static final class BatchedLogRequestEncoder
    implements ObjectEncoder<BatchedLogRequest> {
        static final BatchedLogRequestEncoder INSTANCE = new BatchedLogRequestEncoder();

        private BatchedLogRequestEncoder() {
        }

        public void encode(BatchedLogRequest value, ObjectEncoderContext ctx) throws IOException {
            ctx.add("logRequest", value.getLogRequests());
        }
    }
}

