/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.cct.internal;

import android.util.SparseArray;
import androidx.annotation.Nullable;

public enum QosTier {
    DEFAULT(0),
    UNMETERED_ONLY(1),
    UNMETERED_OR_DAILY(2),
    FAST_IF_RADIO_AWAKE(3),
    NEVER(4),
    UNRECOGNIZED(-1);

    private final int value;
    private static final SparseArray<QosTier> valueMap;

    private QosTier(int value) {
        this.value = value;
    }

    public final int getNumber() {
        return this.value;
    }

    @Nullable
    public static QosTier forNumber(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return UNMETERED_ONLY;
            }
            case 2: {
                return UNMETERED_OR_DAILY;
            }
            case 3: {
                return FAST_IF_RADIO_AWAKE;
            }
            case 4: {
                return NEVER;
            }
        }
        return null;
    }

    static {
        valueMap = new SparseArray();
        valueMap.put(0, (Object)DEFAULT);
        valueMap.put(1, (Object)UNMETERED_ONLY);
        valueMap.put(2, (Object)UNMETERED_OR_DAILY);
        valueMap.put(3, (Object)FAST_IF_RADIO_AWAKE);
        valueMap.put(4, (Object)NEVER);
        valueMap.put(-1, (Object)UNRECOGNIZED);
    }
}

