/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime;

import android.support.annotation.Nullable;
import com.google.android.datatransport.runtime.AutoValue_EventInternal;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AutoValue
public abstract class EventInternal {
    public abstract String getTransportName();

    @Nullable
    public abstract Integer getCode();

    public abstract byte[] getPayload();

    public abstract long getEventMillis();

    public abstract long getUptimeMillis();

    protected abstract Map<String, String> getAutoMetadata();

    public final Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.getAutoMetadata());
    }

    public final String getOrDefault(String key, String defaultValue) {
        String value = this.getAutoMetadata().get(key);
        return value == null ? defaultValue : value;
    }

    public final int getInteger(String key) {
        String value = this.getAutoMetadata().get(key);
        return value == null ? 0 : Integer.valueOf(value);
    }

    public final long getLong(String key) {
        String value = this.getAutoMetadata().get(key);
        return value == null ? 0L : Long.valueOf(value);
    }

    public final String get(String key) {
        String value = this.getAutoMetadata().get(key);
        return value == null ? "" : value;
    }

    public Builder toBuilder() {
        return new AutoValue_EventInternal.Builder().setTransportName(this.getTransportName()).setCode(this.getCode()).setPayload(this.getPayload()).setEventMillis(this.getEventMillis()).setUptimeMillis(this.getUptimeMillis()).setAutoMetadata(new HashMap<String, String>(this.getAutoMetadata()));
    }

    public static Builder builder() {
        return new AutoValue_EventInternal.Builder().setAutoMetadata(new HashMap<String, String>());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTransportName(String var1);

        public abstract Builder setCode(Integer var1);

        public abstract Builder setPayload(byte[] var1);

        public abstract Builder setEventMillis(long var1);

        public abstract Builder setUptimeMillis(long var1);

        protected abstract Builder setAutoMetadata(Map<String, String> var1);

        protected abstract Map<String, String> getAutoMetadata();

        public final Builder addMetadata(String key, String value) {
            this.getAutoMetadata().put(key, value);
            return this;
        }

        public final Builder addMetadata(String key, long value) {
            this.getAutoMetadata().put(key, String.valueOf(value));
            return this;
        }

        public final Builder addMetadata(String key, int value) {
            this.getAutoMetadata().put(key, String.valueOf(value));
            return this;
        }

        public abstract EventInternal build();
    }
}

