/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling;

import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.TransportRuntime;
import com.google.android.datatransport.runtime.backends.BackendRegistry;
import com.google.android.datatransport.runtime.backends.TransportBackend;
import com.google.android.datatransport.runtime.scheduling.DefaultScheduler$$Lambda$1;
import com.google.android.datatransport.runtime.scheduling.DefaultScheduler$$Lambda$2;
import com.google.android.datatransport.runtime.scheduling.Scheduler;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.WorkScheduler;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStore;
import com.google.android.datatransport.runtime.synchronization.SynchronizationGuard;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.inject.Inject;

public class DefaultScheduler
implements Scheduler {
    private static final Logger LOGGER = Logger.getLogger(TransportRuntime.class.getName());
    private final WorkScheduler workScheduler;
    private final Executor executor;
    private final BackendRegistry backendRegistry;
    private final EventStore eventStore;
    private final SynchronizationGuard guard;

    @Inject
    DefaultScheduler(Executor executor, BackendRegistry backendRegistry, WorkScheduler workScheduler, EventStore eventStore, SynchronizationGuard guard) {
        this.executor = executor;
        this.backendRegistry = backendRegistry;
        this.workScheduler = workScheduler;
        this.eventStore = eventStore;
        this.guard = guard;
    }

    @Override
    public void schedule(TransportContext transportContext, EventInternal event) {
        this.executor.execute(DefaultScheduler$$Lambda$1.lambdaFactory$(this, transportContext, event));
    }

    static /* synthetic */ void lambda$schedule$1(DefaultScheduler this_, TransportContext transportContext, EventInternal event) {
        TransportBackend transportBackend = this_.backendRegistry.get(transportContext.getBackendName());
        if (transportBackend == null) {
            LOGGER.warning(String.format("Transport backend '%s' is not registered", transportContext.getBackendName()));
            return;
        }
        EventInternal decoratedEvent = transportBackend.decorate(event);
        this_.guard.runCriticalSection(DefaultScheduler$$Lambda$2.lambdaFactory$(this_, transportContext, decoratedEvent));
    }

    static /* synthetic */ Object lambda$schedule$0(DefaultScheduler this_, TransportContext transportContext, EventInternal decoratedEvent) {
        this_.eventStore.persist(transportContext, decoratedEvent);
        this_.workScheduler.schedule(transportContext, 1);
        return null;
    }
}

