/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.jobscheduling;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.os.PersistableBundle;
import android.support.annotation.RequiresApi;
import android.support.annotation.VisibleForTesting;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.JobInfoSchedulerService;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.SchedulerConfig;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.WorkScheduler;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStore;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;

@RequiresApi(api=21)
public class JobInfoScheduler
implements WorkScheduler {
    static final String ATTEMPT_NUMBER = "attemptNumber";
    static final String BACKEND_NAME = "backendName";
    static final String EVENT_PRIORITY = "priority";
    private final Context context;
    private final EventStore eventStore;
    private final SchedulerConfig config;

    public JobInfoScheduler(Context applicationContext, EventStore eventStore, SchedulerConfig config) {
        this.context = applicationContext;
        this.eventStore = eventStore;
        this.config = config;
    }

    @VisibleForTesting
    int getJobId(TransportContext transportContext) {
        Adler32 checksum = new Adler32();
        checksum.update(this.context.getPackageName().getBytes());
        checksum.update(transportContext.getBackendName().getBytes());
        checksum.update(ByteBuffer.allocate(4).putInt(transportContext.getPriority().ordinal()).array());
        return (int)checksum.getValue();
    }

    private boolean isJobServiceOn(JobScheduler scheduler, int jobId, int attemptNumber) {
        for (JobInfo jobInfo : scheduler.getAllPendingJobs()) {
            int existingAttemptNumber = jobInfo.getExtras().getInt(ATTEMPT_NUMBER);
            if (jobInfo.getId() != jobId) continue;
            return existingAttemptNumber >= attemptNumber;
        }
        return false;
    }

    @Override
    public void schedule(TransportContext transportContext, int attemptNumber) {
        int jobId;
        ComponentName serviceComponent = new ComponentName(this.context, JobInfoSchedulerService.class);
        JobScheduler jobScheduler = (JobScheduler)this.context.getSystemService("jobscheduler");
        if (this.isJobServiceOn(jobScheduler, jobId = this.getJobId(transportContext), attemptNumber)) {
            return;
        }
        JobInfo.Builder builder = this.config.configureJob(new JobInfo.Builder(jobId, serviceComponent), transportContext.getPriority(), this.eventStore.getNextCallTime(transportContext), attemptNumber);
        PersistableBundle bundle = new PersistableBundle();
        bundle.putInt(ATTEMPT_NUMBER, attemptNumber);
        bundle.putString(BACKEND_NAME, transportContext.getBackendName());
        bundle.putInt(EVENT_PRIORITY, transportContext.getPriority().ordinal());
        builder.setExtras(bundle);
        jobScheduler.schedule(builder.build());
    }
}

