/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.TransportFactory;
import com.google.android.datatransport.TransportScheduleCallback;
import com.google.android.datatransport.runtime.DaggerTransportRuntimeComponent;
import com.google.android.datatransport.runtime.Destination;
import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.SendRequest;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.TransportFactoryImpl;
import com.google.android.datatransport.runtime.TransportInternal;
import com.google.android.datatransport.runtime.TransportRuntimeComponent;
import com.google.android.datatransport.runtime.scheduling.Scheduler;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.WorkInitializer;
import com.google.android.datatransport.runtime.time.Clock;
import com.google.android.datatransport.runtime.time.Monotonic;
import com.google.android.datatransport.runtime.time.WallTime;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TransportRuntime
implements TransportInternal {
    private static volatile TransportRuntimeComponent instance = null;
    private final Clock eventClock;
    private final Clock uptimeClock;
    private final Scheduler scheduler;
    private final Uploader uploader;

    @Inject
    TransportRuntime(@WallTime Clock eventClock, @Monotonic Clock uptimeClock, Scheduler scheduler, Uploader uploader, WorkInitializer initializer) {
        this.eventClock = eventClock;
        this.uptimeClock = uptimeClock;
        this.scheduler = scheduler;
        this.uploader = uploader;
        initializer.ensureContextsScheduled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize(Context applicationContext) {
        if (instance != null) return;
        Class<TransportRuntime> clazz = TransportRuntime.class;
        synchronized (TransportRuntime.class) {
            if (instance != null) return;
            instance = DaggerTransportRuntimeComponent.builder().setApplicationContext(applicationContext).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static TransportRuntime getInstance() {
        TransportRuntimeComponent localRef = instance;
        if (localRef == null) {
            throw new IllegalStateException("Not initialized!");
        }
        return localRef.getTransportRuntime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    static void withInstance(TransportRuntimeComponent component, Callable<Void> callable) throws Throwable {
        Class<TransportRuntime> clazz = TransportRuntime.class;
        synchronized (TransportRuntime.class) {
            TransportRuntimeComponent original = instance;
            instance = component;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            try {
                callable.call();
            }
            finally {
                clazz = TransportRuntime.class;
                synchronized (TransportRuntime.class) {
                    instance = original;
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                }
            }
            return;
        }
    }

    @Deprecated
    public TransportFactory newFactory(String backendName) {
        return new TransportFactoryImpl(TransportContext.builder().setBackendName(backendName).build(), this);
    }

    public TransportFactory newFactory(Destination destination) {
        return new TransportFactoryImpl(TransportContext.builder().setBackendName(destination.getName()).setExtras(destination.getExtras()).build(), this);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Uploader getUploader() {
        return this.uploader;
    }

    @Override
    public void send(SendRequest request, TransportScheduleCallback callback) {
        this.scheduler.schedule(request.getTransportContext().withPriority(request.getEvent().getPriority()), this.convert(request), callback);
    }

    private EventInternal convert(SendRequest request) {
        return EventInternal.builder().setEventMillis(this.eventClock.getTime()).setUptimeMillis(this.uptimeClock.getTime()).setTransportName(request.getTransportName()).setPayload(request.getPayload()).setCode(request.getEvent().getCode()).build();
    }
}

