package com.google.android.datatransport.runtime.firebase.transport;

import com.google.firebase.encoders.proto.Protobuf;

public final class StorageMetrics {
  private static final StorageMetrics DEFAULT_INSTANCE = new Builder().build();

  private final long current_cache_size_bytes_;

  private final long max_cache_size_bytes_;

  StorageMetrics(long current_cache_size_bytes_, long max_cache_size_bytes_) {
    this.current_cache_size_bytes_ = current_cache_size_bytes_;
    this.max_cache_size_bytes_ = max_cache_size_bytes_;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  @Protobuf(
      tag = 1
  )
  public long getCurrentCacheSizeBytes() {
    return current_cache_size_bytes_;
  }

  @Protobuf(
      tag = 2
  )
  public long getMaxCacheSizeBytes() {
    return max_cache_size_bytes_;
  }

  public static StorageMetrics getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  public static final class Builder {
    private long current_cache_size_bytes_;

    private long max_cache_size_bytes_;

    Builder() {
      this.current_cache_size_bytes_ = 0;
      this.max_cache_size_bytes_ = 0;
    }

    public StorageMetrics build() {
      return new StorageMetrics(current_cache_size_bytes_, max_cache_size_bytes_);
    }

    public Builder setCurrentCacheSizeBytes(long current_cache_size_bytes_) {
      this.current_cache_size_bytes_ = current_cache_size_bytes_;
      return this;
    }

    public Builder setMaxCacheSizeBytes(long max_cache_size_bytes_) {
      this.max_cache_size_bytes_ = max_cache_size_bytes_;
      return this;
    }
  }
}
