package com.google.android.datatransport.runtime.firebase.transport;

import com.google.firebase.encoders.proto.ProtoEnum;
import com.google.firebase.encoders.proto.Protobuf;
import java.lang.Override;

public final class LogEventDropped {
  private static final LogEventDropped DEFAULT_INSTANCE = new Builder().build();

  private final long events_dropped_count_;

  private final Reason reason_;

  LogEventDropped(long events_dropped_count_, Reason reason_) {
    this.events_dropped_count_ = events_dropped_count_;
    this.reason_ = reason_;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  @Protobuf(
      tag = 1
  )
  public long getEventsDroppedCount() {
    return events_dropped_count_;
  }

  @Protobuf(
      tag = 3
  )
  public Reason getReason() {
    return reason_;
  }

  public static LogEventDropped getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  public static final class Builder {
    private long events_dropped_count_;

    private Reason reason_;

    Builder() {
      this.events_dropped_count_ = 0;
      this.reason_ = com.google.android.datatransport.runtime.firebase.transport.LogEventDropped.Reason.REASON_UNKNOWN;
    }

    public LogEventDropped build() {
      return new LogEventDropped(events_dropped_count_, reason_);
    }

    public Builder setEventsDroppedCount(long events_dropped_count_) {
      this.events_dropped_count_ = events_dropped_count_;
      return this;
    }

    public Builder setReason(Reason reason_) {
      this.reason_ = reason_;
      return this;
    }
  }

  public enum Reason implements ProtoEnum {
    REASON_UNKNOWN(0),

    MESSAGE_TOO_OLD(1),

    CACHE_FULL(2),

    PAYLOAD_TOO_BIG(3),

    MAX_RETRIES_REACHED(4),

    INVALID_PAYLOD(5),

    SERVER_ERROR(6);

    private final int number_;

    private Reason(int number_) {
      this.number_ = number_;
    }

    @Override
    public int getNumber() {
      return number_;
    }
  }
}
