/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling;

import com.google.android.datatransport.TransportScheduleCallback;
import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.TransportRuntime;
import com.google.android.datatransport.runtime.backends.BackendRegistry;
import com.google.android.datatransport.runtime.backends.TransportBackend;
import com.google.android.datatransport.runtime.scheduling.Scheduler;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.WorkScheduler;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStore;
import com.google.android.datatransport.runtime.synchronization.SynchronizationGuard;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.inject.Inject;

public class DefaultScheduler
implements Scheduler {
    private static final Logger LOGGER = Logger.getLogger(TransportRuntime.class.getName());
    private final WorkScheduler workScheduler;
    private final Executor executor;
    private final BackendRegistry backendRegistry;
    private final EventStore eventStore;
    private final SynchronizationGuard guard;

    @Inject
    public DefaultScheduler(Executor executor, BackendRegistry backendRegistry, WorkScheduler workScheduler, EventStore eventStore, SynchronizationGuard guard) {
        this.executor = executor;
        this.backendRegistry = backendRegistry;
        this.workScheduler = workScheduler;
        this.eventStore = eventStore;
        this.guard = guard;
    }

    @Override
    public void schedule(TransportContext transportContext, EventInternal event, TransportScheduleCallback callback) {
        this.executor.execute(() -> {
            try {
                TransportBackend transportBackend = this.backendRegistry.get(transportContext.getBackendName());
                if (transportBackend == null) {
                    String errorMsg = String.format("Transport backend '%s' is not registered", transportContext.getBackendName());
                    LOGGER.warning(errorMsg);
                    callback.onSchedule((Exception)new IllegalArgumentException(errorMsg));
                    return;
                }
                EventInternal decoratedEvent = transportBackend.decorate(event);
                this.guard.runCriticalSection(() -> {
                    this.eventStore.persist(transportContext, decoratedEvent);
                    this.workScheduler.schedule(transportContext, 1);
                    return null;
                });
                callback.onSchedule(null);
            }
            catch (Exception e) {
                LOGGER.warning("Error scheduling event " + e.getMessage());
                callback.onSchedule(e);
            }
        });
    }
}

