/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.jobscheduling;

import android.app.job.JobInfo;
import androidx.annotation.RequiresApi;
import com.google.android.datatransport.Priority;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.AutoValue_SchedulerConfig;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.AutoValue_SchedulerConfig_ConfigValue;
import com.google.android.datatransport.runtime.time.Clock;
import com.google.auto.value.AutoValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@AutoValue
public abstract class SchedulerConfig {
    private static final long TWENTY_FOUR_HOURS = 86400000L;
    private static final long THIRTY_SECONDS = 30000L;
    private static final long ONE_SECOND = 1000L;
    private static final long BACKOFF_LOG_BASE = 10000L;

    public static SchedulerConfig getDefault(Clock clock) {
        return SchedulerConfig.builder().addConfig(Priority.DEFAULT, ConfigValue.builder().setDelta(30000L).setMaxAllowedDelay(86400000L).build()).addConfig(Priority.HIGHEST, ConfigValue.builder().setDelta(1000L).setMaxAllowedDelay(86400000L).build()).addConfig(Priority.VERY_LOW, ConfigValue.builder().setDelta(86400000L).setMaxAllowedDelay(86400000L).setFlags(SchedulerConfig.immutableSetOf(Flag.DEVICE_IDLE)).build()).setClock(clock).build();
    }

    abstract Clock getClock();

    abstract Map<Priority, ConfigValue> getValues();

    public static Builder builder() {
        return new Builder();
    }

    static SchedulerConfig create(Clock clock, Map<Priority, ConfigValue> values) {
        return new AutoValue_SchedulerConfig(clock, values);
    }

    public long getScheduleDelay(Priority priority, long minTimestamp, int attemptNumber, boolean skipDelta) {
        long timeDiff = minTimestamp - this.getClock().getTime();
        ConfigValue config = this.getValues().get(priority);
        long delta = skipDelta ? 1L : config.getDelta();
        long delay = Math.max(this.adjustedExponentialBackoff(attemptNumber, delta), timeDiff);
        return Math.min(delay, config.getMaxAllowedDelay());
    }

    public long getScheduleDelay(Priority priority, long minTimestamp, int attemptNumber) {
        return this.getScheduleDelay(priority, minTimestamp, attemptNumber, false);
    }

    private long adjustedExponentialBackoff(int attemptNumber, long delta) {
        int attemptCoefficient = attemptNumber - 1;
        long deltaOr2 = delta > 1L ? delta : 2L;
        double logValue = Math.log(10000.0) / Math.log(deltaOr2 * (long)attemptCoefficient);
        double logRegularized = Math.max(1.0, logValue);
        return (long)(Math.pow(3.0, attemptCoefficient) * (double)delta * logRegularized);
    }

    @RequiresApi(api=21)
    public JobInfo.Builder configureJob(JobInfo.Builder builder, Priority priority, long minimumTimestamp, int attemptNumber, boolean skipDelta) {
        long latency = this.getScheduleDelay(priority, minimumTimestamp, attemptNumber, skipDelta);
        builder.setMinimumLatency(latency);
        this.populateFlags(builder, this.getValues().get(priority).getFlags());
        return builder;
    }

    @RequiresApi(api=21)
    public JobInfo.Builder configureJob(JobInfo.Builder builder, Priority priority, long minimumTimestamp, int attemptNumber) {
        return this.configureJob(builder, priority, minimumTimestamp, attemptNumber, false);
    }

    @RequiresApi(api=21)
    private void populateFlags(JobInfo.Builder builder, Set<Flag> flags) {
        if (flags.contains((Object)Flag.NETWORK_UNMETERED)) {
            builder.setRequiredNetworkType(2);
        } else {
            builder.setRequiredNetworkType(1);
        }
        if (flags.contains((Object)Flag.DEVICE_CHARGING)) {
            builder.setRequiresCharging(true);
        }
        if (flags.contains((Object)Flag.DEVICE_IDLE)) {
            builder.setRequiresDeviceIdle(true);
        }
    }

    public Set<Flag> getFlags(Priority priority) {
        return this.getValues().get(priority).getFlags();
    }

    private static <T> Set<T> immutableSetOf(T ... values) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(values)));
    }

    public static class Builder {
        private Clock clock;
        private Map<Priority, ConfigValue> values = new HashMap<Priority, ConfigValue>();

        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder addConfig(Priority priority, ConfigValue value) {
            this.values.put(priority, value);
            return this;
        }

        public SchedulerConfig build() {
            if (this.clock == null) {
                throw new NullPointerException("missing required property: clock");
            }
            if (this.values.keySet().size() < Priority.values().length) {
                throw new IllegalStateException("Not all priorities have been configured");
            }
            Map<Priority, ConfigValue> values = this.values;
            this.values = new HashMap<Priority, ConfigValue>();
            return SchedulerConfig.create(this.clock, values);
        }
    }

    @AutoValue
    public static abstract class ConfigValue {
        abstract long getDelta();

        abstract long getMaxAllowedDelay();

        abstract Set<Flag> getFlags();

        public static Builder builder() {
            return new AutoValue_SchedulerConfig_ConfigValue.Builder().setFlags(Collections.emptySet());
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setDelta(long var1);

            public abstract Builder setMaxAllowedDelay(long var1);

            public abstract Builder setFlags(Set<Flag> var1);

            public abstract ConfigValue build();
        }
    }

    public static enum Flag {
        NETWORK_UNMETERED,
        DEVICE_IDLE,
        DEVICE_CHARGING;

    }
}

