/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;

public class DefaultControlDispatcher
implements ControlDispatcher {
    public static final int DEFAULT_FAST_FORWARD_MS = 15000;
    public static final int DEFAULT_REWIND_MS = 5000;
    private static final int MAX_POSITION_FOR_SEEK_TO_PREVIOUS = 3000;
    private final Timeline.Window window;
    private long rewindIncrementMs;
    private long fastForwardIncrementMs;

    public DefaultControlDispatcher() {
        this(15000L, 5000L);
    }

    public DefaultControlDispatcher(long fastForwardIncrementMs, long rewindIncrementMs) {
        this.fastForwardIncrementMs = fastForwardIncrementMs;
        this.rewindIncrementMs = rewindIncrementMs;
        this.window = new Timeline.Window();
    }

    @Override
    public boolean dispatchPrepare(Player player) {
        player.prepare();
        return true;
    }

    @Override
    public boolean dispatchSetPlayWhenReady(Player player, boolean playWhenReady) {
        player.setPlayWhenReady(playWhenReady);
        return true;
    }

    @Override
    public boolean dispatchSeekTo(Player player, int windowIndex, long positionMs) {
        player.seekTo(windowIndex, positionMs);
        return true;
    }

    @Override
    public boolean dispatchPrevious(Player player) {
        boolean isUnseekableLiveStream;
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty() || player.isPlayingAd()) {
            return true;
        }
        int windowIndex = player.getCurrentWindowIndex();
        timeline.getWindow(windowIndex, this.window);
        int previousWindowIndex = player.getPreviousWindowIndex();
        boolean bl = isUnseekableLiveStream = this.window.isLive() && !this.window.isSeekable;
        if (previousWindowIndex != -1 && (player.getCurrentPosition() <= 3000L || isUnseekableLiveStream)) {
            player.seekTo(previousWindowIndex, -9223372036854775807L);
        } else if (!isUnseekableLiveStream) {
            player.seekTo(windowIndex, 0L);
        }
        return true;
    }

    @Override
    public boolean dispatchNext(Player player) {
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty() || player.isPlayingAd()) {
            return true;
        }
        int windowIndex = player.getCurrentWindowIndex();
        timeline.getWindow(windowIndex, this.window);
        int nextWindowIndex = player.getNextWindowIndex();
        if (nextWindowIndex != -1) {
            player.seekTo(nextWindowIndex, -9223372036854775807L);
        } else if (this.window.isLive() && this.window.isDynamic) {
            player.seekTo(windowIndex, -9223372036854775807L);
        }
        return true;
    }

    @Override
    public boolean dispatchRewind(Player player) {
        if (this.isRewindEnabled() && player.isCurrentWindowSeekable()) {
            DefaultControlDispatcher.seekToOffset(player, -this.rewindIncrementMs);
        }
        return true;
    }

    @Override
    public boolean dispatchFastForward(Player player) {
        if (this.isFastForwardEnabled() && player.isCurrentWindowSeekable()) {
            DefaultControlDispatcher.seekToOffset(player, this.fastForwardIncrementMs);
        }
        return true;
    }

    @Override
    public boolean dispatchSetRepeatMode(Player player, int repeatMode) {
        player.setRepeatMode(repeatMode);
        return true;
    }

    @Override
    public boolean dispatchSetShuffleModeEnabled(Player player, boolean shuffleModeEnabled) {
        player.setShuffleModeEnabled(shuffleModeEnabled);
        return true;
    }

    @Override
    public boolean dispatchStop(Player player, boolean reset) {
        player.stop(reset);
        return true;
    }

    @Override
    public boolean dispatchSetPlaybackParameters(Player player, PlaybackParameters playbackParameters) {
        player.setPlaybackParameters(playbackParameters);
        return true;
    }

    @Override
    public boolean isRewindEnabled() {
        return this.rewindIncrementMs > 0L;
    }

    @Override
    public boolean isFastForwardEnabled() {
        return this.fastForwardIncrementMs > 0L;
    }

    public long getRewindIncrementMs() {
        return this.rewindIncrementMs;
    }

    public long getFastForwardIncrementMs() {
        return this.fastForwardIncrementMs;
    }

    @Deprecated
    public void setRewindIncrementMs(long rewindMs) {
        this.rewindIncrementMs = rewindMs;
    }

    @Deprecated
    public void setFastForwardIncrementMs(long fastForwardMs) {
        this.fastForwardIncrementMs = fastForwardMs;
    }

    private static void seekToOffset(Player player, long offsetMs) {
        long positionMs = player.getCurrentPosition() + offsetMs;
        long durationMs = player.getDuration();
        if (durationMs != -9223372036854775807L) {
            positionMs = Math.min(positionMs, durationMs);
        }
        positionMs = Math.max(positionMs, 0L);
        player.seekTo(player.getCurrentWindowIndex(), positionMs);
    }
}

