/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Ascii;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface HttpDataSource
extends DataSource {
    public static final Predicate<String> REJECT_PAYWALL_TYPES = contentType -> {
        if (contentType == null) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)(contentType = Ascii.toLowerCase((String)contentType))) && (!contentType.contains("text") || contentType.contains("text/vtt")) && !contentType.contains("html") && !contentType.contains("xml");
    };

    @Override
    public long open(DataSpec var1) throws HttpDataSourceException;

    @Override
    public void close() throws HttpDataSourceException;

    @Override
    public int read(byte[] var1, int var2, int var3) throws HttpDataSourceException;

    public void setRequestProperty(String var1, String var2);

    public void clearRequestProperty(String var1);

    public void clearAllRequestProperties();

    public int getResponseCode();

    @Override
    public Map<String, List<String>> getResponseHeaders();

    public static final class InvalidResponseCodeException
    extends HttpDataSourceException {
        public final int responseCode;
        @Nullable
        public final String responseMessage;
        public final Map<String, List<String>> headerFields;
        public final byte[] responseBody;

        @Deprecated
        public InvalidResponseCodeException(int responseCode, Map<String, List<String>> headerFields, DataSpec dataSpec) {
            this(responseCode, null, headerFields, dataSpec, Util.EMPTY_BYTE_ARRAY);
        }

        @Deprecated
        public InvalidResponseCodeException(int responseCode, @Nullable String responseMessage, Map<String, List<String>> headerFields, DataSpec dataSpec) {
            this(responseCode, responseMessage, headerFields, dataSpec, Util.EMPTY_BYTE_ARRAY);
        }

        public InvalidResponseCodeException(int responseCode, @Nullable String responseMessage, Map<String, List<String>> headerFields, DataSpec dataSpec, byte[] responseBody) {
            super(new StringBuilder(26).append("Response code: ").append(responseCode).toString(), dataSpec, 1);
            this.responseCode = responseCode;
            this.responseMessage = responseMessage;
            this.headerFields = headerFields;
            this.responseBody = responseBody;
        }
    }

    public static final class InvalidContentTypeException
    extends HttpDataSourceException {
        public final String contentType;

        public InvalidContentTypeException(String contentType, DataSpec dataSpec) {
            String string = String.valueOf(contentType);
            super(string.length() != 0 ? "Invalid content type: ".concat(string) : new String("Invalid content type: "), dataSpec, 1);
            this.contentType = contentType;
        }
    }

    public static final class CleartextNotPermittedException
    extends HttpDataSourceException {
        public CleartextNotPermittedException(IOException cause, DataSpec dataSpec) {
            super("Cleartext HTTP traffic not permitted. See https://exoplayer.dev/issues/cleartext-not-permitted", cause, dataSpec, 1);
        }
    }

    public static class HttpDataSourceException
    extends IOException {
        public static final int TYPE_OPEN = 1;
        public static final int TYPE_READ = 2;
        public static final int TYPE_CLOSE = 3;
        public final int type;
        public final DataSpec dataSpec;

        public HttpDataSourceException(DataSpec dataSpec, int type) {
            this.dataSpec = dataSpec;
            this.type = type;
        }

        public HttpDataSourceException(String message, DataSpec dataSpec, int type) {
            super(message);
            this.dataSpec = dataSpec;
            this.type = type;
        }

        public HttpDataSourceException(IOException cause, DataSpec dataSpec, int type) {
            super(cause);
            this.dataSpec = dataSpec;
            this.type = type;
        }

        public HttpDataSourceException(String message, IOException cause, DataSpec dataSpec, int type) {
            super(message, cause);
            this.dataSpec = dataSpec;
            this.type = type;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Type {
        }
    }

    public static abstract class BaseFactory
    implements Factory {
        private final RequestProperties defaultRequestProperties = new RequestProperties();

        @Override
        public final HttpDataSource createDataSource() {
            return this.createDataSourceInternal(this.defaultRequestProperties);
        }

        @Override
        @Deprecated
        public final RequestProperties getDefaultRequestProperties() {
            return this.defaultRequestProperties;
        }

        @Override
        public final Factory setDefaultRequestProperties(Map<String, String> defaultRequestProperties) {
            this.defaultRequestProperties.clearAndSet(defaultRequestProperties);
            return this;
        }

        protected abstract HttpDataSource createDataSourceInternal(RequestProperties var1);
    }

    public static final class RequestProperties {
        private final Map<String, String> requestProperties = new HashMap<String, String>();
        @Nullable
        private Map<String, String> requestPropertiesSnapshot;

        public synchronized void set(String name, String value) {
            this.requestPropertiesSnapshot = null;
            this.requestProperties.put(name, value);
        }

        public synchronized void set(Map<String, String> properties) {
            this.requestPropertiesSnapshot = null;
            this.requestProperties.putAll(properties);
        }

        public synchronized void clearAndSet(Map<String, String> properties) {
            this.requestPropertiesSnapshot = null;
            this.requestProperties.clear();
            this.requestProperties.putAll(properties);
        }

        public synchronized void remove(String name) {
            this.requestPropertiesSnapshot = null;
            this.requestProperties.remove(name);
        }

        public synchronized void clear() {
            this.requestPropertiesSnapshot = null;
            this.requestProperties.clear();
        }

        public synchronized Map<String, String> getSnapshot() {
            if (this.requestPropertiesSnapshot == null) {
                this.requestPropertiesSnapshot = Collections.unmodifiableMap(new HashMap<String, String>(this.requestProperties));
            }
            return this.requestPropertiesSnapshot;
        }
    }

    public static interface Factory
    extends DataSource.Factory {
        @Override
        public HttpDataSource createDataSource();

        @Deprecated
        public RequestProperties getDefaultRequestProperties();

        public Factory setDefaultRequestProperties(Map<String, String> var1);
    }
}

