/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.audio.AacUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Ascii;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MimeTypes {
    public static final String BASE_TYPE_VIDEO = "video";
    public static final String BASE_TYPE_AUDIO = "audio";
    public static final String BASE_TYPE_TEXT = "text";
    public static final String BASE_TYPE_IMAGE = "image";
    public static final String BASE_TYPE_APPLICATION = "application";
    public static final String VIDEO_MP4 = "video/mp4";
    public static final String VIDEO_MATROSKA = "video/x-matroska";
    public static final String VIDEO_WEBM = "video/webm";
    public static final String VIDEO_H263 = "video/3gpp";
    public static final String VIDEO_H264 = "video/avc";
    public static final String VIDEO_H265 = "video/hevc";
    public static final String VIDEO_VP8 = "video/x-vnd.on2.vp8";
    public static final String VIDEO_VP9 = "video/x-vnd.on2.vp9";
    public static final String VIDEO_AV1 = "video/av01";
    public static final String VIDEO_MP2T = "video/mp2t";
    public static final String VIDEO_MP4V = "video/mp4v-es";
    public static final String VIDEO_MPEG = "video/mpeg";
    public static final String VIDEO_PS = "video/mp2p";
    public static final String VIDEO_MPEG2 = "video/mpeg2";
    public static final String VIDEO_VC1 = "video/wvc1";
    public static final String VIDEO_DIVX = "video/divx";
    public static final String VIDEO_FLV = "video/x-flv";
    public static final String VIDEO_DOLBY_VISION = "video/dolby-vision";
    public static final String VIDEO_OGG = "video/ogg";
    public static final String VIDEO_UNKNOWN = "video/x-unknown";
    public static final String AUDIO_MP4 = "audio/mp4";
    public static final String AUDIO_AAC = "audio/mp4a-latm";
    public static final String AUDIO_MATROSKA = "audio/x-matroska";
    public static final String AUDIO_WEBM = "audio/webm";
    public static final String AUDIO_MPEG = "audio/mpeg";
    public static final String AUDIO_MPEG_L1 = "audio/mpeg-L1";
    public static final String AUDIO_MPEG_L2 = "audio/mpeg-L2";
    public static final String AUDIO_MPEGH_MHA1 = "audio/mha1";
    public static final String AUDIO_MPEGH_MHM1 = "audio/mhm1";
    public static final String AUDIO_RAW = "audio/raw";
    public static final String AUDIO_ALAW = "audio/g711-alaw";
    public static final String AUDIO_MLAW = "audio/g711-mlaw";
    public static final String AUDIO_AC3 = "audio/ac3";
    public static final String AUDIO_E_AC3 = "audio/eac3";
    public static final String AUDIO_E_AC3_JOC = "audio/eac3-joc";
    public static final String AUDIO_AC4 = "audio/ac4";
    public static final String AUDIO_TRUEHD = "audio/true-hd";
    public static final String AUDIO_DTS = "audio/vnd.dts";
    public static final String AUDIO_DTS_HD = "audio/vnd.dts.hd";
    public static final String AUDIO_DTS_EXPRESS = "audio/vnd.dts.hd;profile=lbr";
    public static final String AUDIO_VORBIS = "audio/vorbis";
    public static final String AUDIO_OPUS = "audio/opus";
    public static final String AUDIO_AMR = "audio/amr";
    public static final String AUDIO_AMR_NB = "audio/3gpp";
    public static final String AUDIO_AMR_WB = "audio/amr-wb";
    public static final String AUDIO_FLAC = "audio/flac";
    public static final String AUDIO_ALAC = "audio/alac";
    public static final String AUDIO_MSGSM = "audio/gsm";
    public static final String AUDIO_OGG = "audio/ogg";
    public static final String AUDIO_WAV = "audio/wav";
    public static final String AUDIO_UNKNOWN = "audio/x-unknown";
    public static final String TEXT_VTT = "text/vtt";
    public static final String TEXT_SSA = "text/x-ssa";
    public static final String APPLICATION_MP4 = "application/mp4";
    public static final String APPLICATION_WEBM = "application/webm";
    public static final String APPLICATION_MATROSKA = "application/x-matroska";
    public static final String APPLICATION_MPD = "application/dash+xml";
    public static final String APPLICATION_M3U8 = "application/x-mpegURL";
    public static final String APPLICATION_SS = "application/vnd.ms-sstr+xml";
    public static final String APPLICATION_ID3 = "application/id3";
    public static final String APPLICATION_CEA608 = "application/cea-608";
    public static final String APPLICATION_CEA708 = "application/cea-708";
    public static final String APPLICATION_SUBRIP = "application/x-subrip";
    public static final String APPLICATION_TTML = "application/ttml+xml";
    public static final String APPLICATION_TX3G = "application/x-quicktime-tx3g";
    public static final String APPLICATION_MP4VTT = "application/x-mp4-vtt";
    public static final String APPLICATION_MP4CEA608 = "application/x-mp4-cea-608";
    public static final String APPLICATION_RAWCC = "application/x-rawcc";
    public static final String APPLICATION_VOBSUB = "application/vobsub";
    public static final String APPLICATION_PGS = "application/pgs";
    public static final String APPLICATION_SCTE35 = "application/x-scte35";
    public static final String APPLICATION_CAMERA_MOTION = "application/x-camera-motion";
    public static final String APPLICATION_EMSG = "application/x-emsg";
    public static final String APPLICATION_DVBSUBS = "application/dvbsubs";
    public static final String APPLICATION_EXIF = "application/x-exif";
    public static final String APPLICATION_ICY = "application/x-icy";
    public static final String APPLICATION_AIT = "application/vnd.dvb.ait";
    public static final String APPLICATION_RTSP = "application/x-rtsp";
    public static final String IMAGE_JPEG = "image/jpeg";
    private static final ArrayList<CustomMimeType> customMimeTypes = new ArrayList();
    private static final Pattern MP4A_RFC_6381_CODEC_PATTERN = Pattern.compile("^mp4a\\.([a-zA-Z0-9]{2})(?:\\.([0-9]{1,2}))?$");

    public static void registerCustomMimeType(String mimeType, String codecPrefix, int trackType) {
        CustomMimeType customMimeType = new CustomMimeType(mimeType, codecPrefix, trackType);
        int customMimeTypeCount = customMimeTypes.size();
        for (int i = 0; i < customMimeTypeCount; ++i) {
            if (!mimeType.equals(MimeTypes.customMimeTypes.get((int)i).mimeType)) continue;
            customMimeTypes.remove(i);
            break;
        }
        customMimeTypes.add(customMimeType);
    }

    public static boolean isAudio(@Nullable String mimeType) {
        return BASE_TYPE_AUDIO.equals(MimeTypes.getTopLevelType(mimeType));
    }

    public static boolean isVideo(@Nullable String mimeType) {
        return BASE_TYPE_VIDEO.equals(MimeTypes.getTopLevelType(mimeType));
    }

    public static boolean isText(@Nullable String mimeType) {
        return BASE_TYPE_TEXT.equals(MimeTypes.getTopLevelType(mimeType)) || APPLICATION_CEA608.equals(mimeType) || APPLICATION_CEA708.equals(mimeType) || APPLICATION_MP4CEA608.equals(mimeType) || APPLICATION_SUBRIP.equals(mimeType) || APPLICATION_TTML.equals(mimeType) || APPLICATION_TX3G.equals(mimeType) || APPLICATION_MP4VTT.equals(mimeType) || APPLICATION_RAWCC.equals(mimeType) || APPLICATION_VOBSUB.equals(mimeType) || APPLICATION_PGS.equals(mimeType) || APPLICATION_DVBSUBS.equals(mimeType);
    }

    public static boolean allSamplesAreSyncSamples(@Nullable String mimeType, @Nullable String codec) {
        if (mimeType == null) {
            return false;
        }
        switch (mimeType) {
            case "audio/mpeg": 
            case "audio/mpeg-L1": 
            case "audio/mpeg-L2": 
            case "audio/raw": 
            case "audio/g711-alaw": 
            case "audio/g711-mlaw": 
            case "audio/flac": 
            case "audio/ac3": 
            case "audio/eac3": 
            case "audio/eac3-joc": {
                return true;
            }
            case "audio/mp4a-latm": {
                if (codec == null) {
                    return false;
                }
                Mp4aObjectType objectType = MimeTypes.getObjectTypeFromMp4aRFC6381CodecString(codec);
                if (objectType == null) {
                    return false;
                }
                int encoding = AacUtil.getEncodingForAudioObjectType(objectType.audioObjectTypeIndication);
                return encoding != 0 && encoding != 16;
            }
        }
        return false;
    }

    @Nullable
    public static String getVideoMediaMimeType(@Nullable String codecs) {
        String[] codecList;
        if (codecs == null) {
            return null;
        }
        for (String codec : codecList = Util.splitCodecs(codecs)) {
            String mimeType = MimeTypes.getMediaMimeType(codec);
            if (mimeType == null || !MimeTypes.isVideo(mimeType)) continue;
            return mimeType;
        }
        return null;
    }

    public static boolean containsCodecsCorrespondingToMimeType(@Nullable String codecs, String mimeType) {
        return MimeTypes.getCodecsCorrespondingToMimeType(codecs, mimeType) != null;
    }

    @Nullable
    public static String getCodecsCorrespondingToMimeType(@Nullable String codecs, @Nullable String mimeType) {
        if (codecs == null || mimeType == null) {
            return null;
        }
        String[] codecList = Util.splitCodecs(codecs);
        StringBuilder builder = new StringBuilder();
        for (String codec : codecList) {
            if (!mimeType.equals(MimeTypes.getMediaMimeType(codec))) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(codec);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    @Nullable
    public static String getAudioMediaMimeType(@Nullable String codecs) {
        String[] codecList;
        if (codecs == null) {
            return null;
        }
        for (String codec : codecList = Util.splitCodecs(codecs)) {
            String mimeType = MimeTypes.getMediaMimeType(codec);
            if (mimeType == null || !MimeTypes.isAudio(mimeType)) continue;
            return mimeType;
        }
        return null;
    }

    @Nullable
    public static String getTextMediaMimeType(@Nullable String codecs) {
        String[] codecList;
        if (codecs == null) {
            return null;
        }
        for (String codec : codecList = Util.splitCodecs(codecs)) {
            String mimeType = MimeTypes.getMediaMimeType(codec);
            if (mimeType == null || !MimeTypes.isText(mimeType)) continue;
            return mimeType;
        }
        return null;
    }

    @Nullable
    public static String getMediaMimeType(@Nullable String codec) {
        if (codec == null) {
            return null;
        }
        if ((codec = Ascii.toLowerCase((String)codec.trim())).startsWith("avc1") || codec.startsWith("avc3")) {
            return VIDEO_H264;
        }
        if (codec.startsWith("hev1") || codec.startsWith("hvc1")) {
            return VIDEO_H265;
        }
        if (codec.startsWith("dvav") || codec.startsWith("dva1") || codec.startsWith("dvhe") || codec.startsWith("dvh1")) {
            return VIDEO_DOLBY_VISION;
        }
        if (codec.startsWith("av01")) {
            return VIDEO_AV1;
        }
        if (codec.startsWith("vp9") || codec.startsWith("vp09")) {
            return VIDEO_VP9;
        }
        if (codec.startsWith("vp8") || codec.startsWith("vp08")) {
            return VIDEO_VP8;
        }
        if (codec.startsWith("mp4a")) {
            Mp4aObjectType objectType;
            String mimeType = null;
            if (codec.startsWith("mp4a.") && (objectType = MimeTypes.getObjectTypeFromMp4aRFC6381CodecString(codec)) != null) {
                mimeType = MimeTypes.getMimeTypeFromMp4ObjectType(objectType.objectTypeIndication);
            }
            return mimeType == null ? AUDIO_AAC : mimeType;
        }
        if (codec.startsWith("mha1")) {
            return AUDIO_MPEGH_MHA1;
        }
        if (codec.startsWith("mhm1")) {
            return AUDIO_MPEGH_MHM1;
        }
        if (codec.startsWith("ac-3") || codec.startsWith("dac3")) {
            return AUDIO_AC3;
        }
        if (codec.startsWith("ec-3") || codec.startsWith("dec3")) {
            return AUDIO_E_AC3;
        }
        if (codec.startsWith("ec+3")) {
            return AUDIO_E_AC3_JOC;
        }
        if (codec.startsWith("ac-4") || codec.startsWith("dac4")) {
            return AUDIO_AC4;
        }
        if (codec.startsWith("dtsc") || codec.startsWith("dtse")) {
            return AUDIO_DTS;
        }
        if (codec.startsWith("dtsh") || codec.startsWith("dtsl")) {
            return AUDIO_DTS_HD;
        }
        if (codec.startsWith("opus")) {
            return AUDIO_OPUS;
        }
        if (codec.startsWith("vorbis")) {
            return AUDIO_VORBIS;
        }
        if (codec.startsWith("flac")) {
            return AUDIO_FLAC;
        }
        if (codec.startsWith("stpp")) {
            return APPLICATION_TTML;
        }
        if (codec.startsWith("wvtt")) {
            return TEXT_VTT;
        }
        if (codec.contains("cea708")) {
            return APPLICATION_CEA708;
        }
        if (codec.contains("eia608") || codec.contains("cea608")) {
            return APPLICATION_CEA608;
        }
        return MimeTypes.getCustomMimeTypeForCodec(codec);
    }

    @Nullable
    public static String getMimeTypeFromMp4ObjectType(int objectType) {
        switch (objectType) {
            case 32: {
                return VIDEO_MP4V;
            }
            case 33: {
                return VIDEO_H264;
            }
            case 35: {
                return VIDEO_H265;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                return VIDEO_MPEG2;
            }
            case 106: {
                return VIDEO_MPEG;
            }
            case 105: 
            case 107: {
                return AUDIO_MPEG;
            }
            case 163: {
                return VIDEO_VC1;
            }
            case 177: {
                return VIDEO_VP9;
            }
            case 64: 
            case 102: 
            case 103: 
            case 104: {
                return AUDIO_AAC;
            }
            case 165: {
                return AUDIO_AC3;
            }
            case 166: {
                return AUDIO_E_AC3;
            }
            case 169: 
            case 172: {
                return AUDIO_DTS;
            }
            case 170: 
            case 171: {
                return AUDIO_DTS_HD;
            }
            case 173: {
                return AUDIO_OPUS;
            }
            case 174: {
                return AUDIO_AC4;
            }
        }
        return null;
    }

    public static int getTrackType(@Nullable String mimeType) {
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return -1;
        }
        if (MimeTypes.isAudio(mimeType)) {
            return 1;
        }
        if (MimeTypes.isVideo(mimeType)) {
            return 2;
        }
        if (MimeTypes.isText(mimeType)) {
            return 3;
        }
        if (APPLICATION_ID3.equals(mimeType) || APPLICATION_EMSG.equals(mimeType) || APPLICATION_SCTE35.equals(mimeType)) {
            return 5;
        }
        if (APPLICATION_CAMERA_MOTION.equals(mimeType)) {
            return 6;
        }
        return MimeTypes.getTrackTypeForCustomMimeType(mimeType);
    }

    public static int getEncoding(String mimeType, @Nullable String codec) {
        switch (mimeType) {
            case "audio/mpeg": {
                return 9;
            }
            case "audio/mp4a-latm": {
                if (codec == null) {
                    return 0;
                }
                Mp4aObjectType objectType = MimeTypes.getObjectTypeFromMp4aRFC6381CodecString(codec);
                if (objectType == null) {
                    return 0;
                }
                return AacUtil.getEncodingForAudioObjectType(objectType.audioObjectTypeIndication);
            }
            case "audio/ac3": {
                return 5;
            }
            case "audio/eac3": {
                return 6;
            }
            case "audio/eac3-joc": {
                return 18;
            }
            case "audio/ac4": {
                return 17;
            }
            case "audio/vnd.dts": {
                return 7;
            }
            case "audio/vnd.dts.hd": {
                return 8;
            }
            case "audio/true-hd": {
                return 14;
            }
        }
        return 0;
    }

    public static int getTrackTypeOfCodec(String codec) {
        return MimeTypes.getTrackType(MimeTypes.getMediaMimeType(codec));
    }

    public static String normalizeMimeType(String mimeType) {
        switch (mimeType) {
            case "audio/x-flac": {
                return AUDIO_FLAC;
            }
            case "audio/mp3": {
                return AUDIO_MPEG;
            }
            case "audio/x-wav": {
                return AUDIO_WAV;
            }
        }
        return mimeType;
    }

    public static boolean isMatroska(@Nullable String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.startsWith(VIDEO_WEBM) || mimeType.startsWith(AUDIO_WEBM) || mimeType.startsWith(APPLICATION_WEBM) || mimeType.startsWith(VIDEO_MATROSKA) || mimeType.startsWith(AUDIO_MATROSKA) || mimeType.startsWith(APPLICATION_MATROSKA);
    }

    @Nullable
    private static String getTopLevelType(@Nullable String mimeType) {
        if (mimeType == null) {
            return null;
        }
        int indexOfSlash = mimeType.indexOf(47);
        if (indexOfSlash == -1) {
            return null;
        }
        return mimeType.substring(0, indexOfSlash);
    }

    @Nullable
    private static String getCustomMimeTypeForCodec(String codec) {
        int customMimeTypeCount = customMimeTypes.size();
        for (int i = 0; i < customMimeTypeCount; ++i) {
            CustomMimeType customMimeType = customMimeTypes.get(i);
            if (!codec.startsWith(customMimeType.codecPrefix)) continue;
            return customMimeType.mimeType;
        }
        return null;
    }

    private static int getTrackTypeForCustomMimeType(String mimeType) {
        int customMimeTypeCount = customMimeTypes.size();
        for (int i = 0; i < customMimeTypeCount; ++i) {
            CustomMimeType customMimeType = customMimeTypes.get(i);
            if (!mimeType.equals(customMimeType.mimeType)) continue;
            return customMimeType.trackType;
        }
        return -1;
    }

    private MimeTypes() {
    }

    @VisibleForTesting
    @Nullable
    static Mp4aObjectType getObjectTypeFromMp4aRFC6381CodecString(String codec) {
        int objectTypeIndication;
        Matcher matcher = MP4A_RFC_6381_CODEC_PATTERN.matcher(codec);
        if (!matcher.matches()) {
            return null;
        }
        String objectTypeIndicationHex = Assertions.checkNotNull(matcher.group(1));
        String audioObjectTypeIndicationDec = matcher.group(2);
        int audioObjectTypeIndication = 0;
        try {
            objectTypeIndication = Integer.parseInt(objectTypeIndicationHex, 16);
            if (audioObjectTypeIndicationDec != null) {
                audioObjectTypeIndication = Integer.parseInt(audioObjectTypeIndicationDec);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new Mp4aObjectType(objectTypeIndication, audioObjectTypeIndication);
    }

    private static final class CustomMimeType {
        public final String mimeType;
        public final String codecPrefix;
        public final int trackType;

        public CustomMimeType(String mimeType, String codecPrefix, int trackType) {
            this.mimeType = mimeType;
            this.codecPrefix = codecPrefix;
            this.trackType = trackType;
        }
    }

    @VisibleForTesting
    static final class Mp4aObjectType {
        public final int objectTypeIndication;
        public final int audioObjectTypeIndication;

        public Mp4aObjectType(int objectTypeIndication, int audioObjectTypeIndication) {
            this.objectTypeIndication = objectTypeIndication;
            this.audioObjectTypeIndication = audioObjectTypeIndication;
        }
    }
}

