/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.os.Bundle;
import android.os.IBinder;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@Deprecated
public final class BundleUtil {
    private static final String TAG = "BundleUtil";
    @Nullable
    private static Method getIBinderMethod;
    @Nullable
    private static Method putIBinderMethod;

    @Nullable
    public static IBinder getBinder(Bundle bundle, @Nullable String key) {
        if (Util.SDK_INT >= 18) {
            return bundle.getBinder(key);
        }
        return BundleUtil.getBinderByReflection(bundle, key);
    }

    public static void putBinder(Bundle bundle, @Nullable String key, @Nullable IBinder binder) {
        if (Util.SDK_INT >= 18) {
            bundle.putBinder(key, binder);
        } else {
            BundleUtil.putBinderByReflection(bundle, key, binder);
        }
    }

    @Nullable
    private static IBinder getBinderByReflection(Bundle bundle, @Nullable String key) {
        Method getIBinder = getIBinderMethod;
        if (getIBinder == null) {
            try {
                getIBinderMethod = Bundle.class.getMethod("getIBinder", String.class);
                getIBinderMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Log.i(TAG, "Failed to retrieve getIBinder method", e);
                return null;
            }
            getIBinder = getIBinderMethod;
        }
        try {
            return (IBinder)getIBinder.invoke((Object)bundle, key);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Log.i(TAG, "Failed to invoke getIBinder via reflection", e);
            return null;
        }
    }

    private static void putBinderByReflection(Bundle bundle, @Nullable String key, @Nullable IBinder binder) {
        Method putIBinder = putIBinderMethod;
        if (putIBinder == null) {
            try {
                putIBinderMethod = Bundle.class.getMethod("putIBinder", String.class, IBinder.class);
                putIBinderMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Log.i(TAG, "Failed to retrieve putIBinder method", e);
                return;
            }
            putIBinder = putIBinderMethod;
        }
        try {
            putIBinder.invoke((Object)bundle, key, binder);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Log.i(TAG, "Failed to invoke putIBinder via reflection", e);
        }
    }

    private BundleUtil() {
    }
}

