/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DefaultAllocator;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;

public class DefaultLoadControl
implements LoadControl {
    public static final int DEFAULT_MIN_BUFFER_MS = 50000;
    public static final int DEFAULT_MAX_BUFFER_MS = 50000;
    public static final int DEFAULT_BUFFER_FOR_PLAYBACK_MS = 2500;
    public static final int DEFAULT_BUFFER_FOR_PLAYBACK_AFTER_REBUFFER_MS = 5000;
    public static final int DEFAULT_TARGET_BUFFER_BYTES = -1;
    public static final boolean DEFAULT_PRIORITIZE_TIME_OVER_SIZE_THRESHOLDS = false;
    public static final int DEFAULT_BACK_BUFFER_DURATION_MS = 0;
    public static final boolean DEFAULT_RETAIN_BACK_BUFFER_FROM_KEYFRAME = false;
    public static final int DEFAULT_VIDEO_BUFFER_SIZE = 0x7D00000;
    public static final int DEFAULT_AUDIO_BUFFER_SIZE = 0xC80000;
    public static final int DEFAULT_TEXT_BUFFER_SIZE = 131072;
    public static final int DEFAULT_METADATA_BUFFER_SIZE = 131072;
    public static final int DEFAULT_CAMERA_MOTION_BUFFER_SIZE = 131072;
    public static final int DEFAULT_MUXED_BUFFER_SIZE = 144310272;
    public static final int DEFAULT_MIN_BUFFER_SIZE = 0xC80000;
    private final DefaultAllocator allocator;
    private final long minBufferUs;
    private final long maxBufferUs;
    private final long bufferForPlaybackUs;
    private final long bufferForPlaybackAfterRebufferUs;
    private final int targetBufferBytesOverwrite;
    private final boolean prioritizeTimeOverSizeThresholds;
    private final long backBufferDurationUs;
    private final boolean retainBackBufferFromKeyframe;
    private int targetBufferBytes;
    private boolean isLoading;

    public DefaultLoadControl() {
        this(new DefaultAllocator(true, 65536), 50000, 50000, 2500, 5000, -1, false, 0, false);
    }

    protected DefaultLoadControl(DefaultAllocator allocator, int minBufferMs, int maxBufferMs, int bufferForPlaybackMs, int bufferForPlaybackAfterRebufferMs, int targetBufferBytes, boolean prioritizeTimeOverSizeThresholds, int backBufferDurationMs, boolean retainBackBufferFromKeyframe) {
        DefaultLoadControl.assertGreaterOrEqual(bufferForPlaybackMs, 0, "bufferForPlaybackMs", "0");
        DefaultLoadControl.assertGreaterOrEqual(bufferForPlaybackAfterRebufferMs, 0, "bufferForPlaybackAfterRebufferMs", "0");
        DefaultLoadControl.assertGreaterOrEqual(minBufferMs, bufferForPlaybackMs, "minBufferMs", "bufferForPlaybackMs");
        DefaultLoadControl.assertGreaterOrEqual(minBufferMs, bufferForPlaybackAfterRebufferMs, "minBufferMs", "bufferForPlaybackAfterRebufferMs");
        DefaultLoadControl.assertGreaterOrEqual(maxBufferMs, minBufferMs, "maxBufferMs", "minBufferMs");
        DefaultLoadControl.assertGreaterOrEqual(backBufferDurationMs, 0, "backBufferDurationMs", "0");
        this.allocator = allocator;
        this.minBufferUs = C.msToUs((long)minBufferMs);
        this.maxBufferUs = C.msToUs((long)maxBufferMs);
        this.bufferForPlaybackUs = C.msToUs((long)bufferForPlaybackMs);
        this.bufferForPlaybackAfterRebufferUs = C.msToUs((long)bufferForPlaybackAfterRebufferMs);
        this.targetBufferBytesOverwrite = targetBufferBytes;
        this.targetBufferBytes = this.targetBufferBytesOverwrite != -1 ? this.targetBufferBytesOverwrite : 0xC80000;
        this.prioritizeTimeOverSizeThresholds = prioritizeTimeOverSizeThresholds;
        this.backBufferDurationUs = C.msToUs((long)backBufferDurationMs);
        this.retainBackBufferFromKeyframe = retainBackBufferFromKeyframe;
    }

    @Override
    public void onPrepared() {
        this.reset(false);
    }

    @Override
    public void onTracksSelected(Renderer[] renderers, TrackGroupArray trackGroups, ExoTrackSelection[] trackSelections) {
        this.targetBufferBytes = this.targetBufferBytesOverwrite == -1 ? this.calculateTargetBufferBytes(renderers, trackSelections) : this.targetBufferBytesOverwrite;
        this.allocator.setTargetBufferSize(this.targetBufferBytes);
    }

    @Override
    public void onStopped() {
        this.reset(true);
    }

    @Override
    public void onReleased() {
        this.reset(true);
    }

    @Override
    public Allocator getAllocator() {
        return this.allocator;
    }

    @Override
    public long getBackBufferDurationUs() {
        return this.backBufferDurationUs;
    }

    @Override
    public boolean retainBackBufferFromKeyframe() {
        return this.retainBackBufferFromKeyframe;
    }

    @Override
    public boolean shouldContinueLoading(long playbackPositionUs, long bufferedDurationUs, float playbackSpeed) {
        boolean targetBufferSizeReached = this.allocator.getTotalBytesAllocated() >= this.targetBufferBytes;
        long minBufferUs = this.minBufferUs;
        if (playbackSpeed > 1.0f) {
            long mediaDurationMinBufferUs = Util.getMediaDurationForPlayoutDuration((long)minBufferUs, (float)playbackSpeed);
            minBufferUs = Math.min(mediaDurationMinBufferUs, this.maxBufferUs);
        }
        if (bufferedDurationUs < (minBufferUs = Math.max(minBufferUs, 500000L))) {
            boolean bl = this.isLoading = this.prioritizeTimeOverSizeThresholds || !targetBufferSizeReached;
            if (!this.isLoading && bufferedDurationUs < 500000L) {
                Log.w((String)"DefaultLoadControl", (String)"Target buffer size reached with less than 500ms of buffered media data.");
            }
        } else if (bufferedDurationUs >= this.maxBufferUs || targetBufferSizeReached) {
            this.isLoading = false;
        }
        return this.isLoading;
    }

    @Override
    public boolean shouldStartPlayback(long bufferedDurationUs, float playbackSpeed, boolean rebuffering, long targetLiveOffsetUs) {
        long minBufferDurationUs;
        bufferedDurationUs = Util.getPlayoutDurationForMediaDuration((long)bufferedDurationUs, (float)playbackSpeed);
        long l = minBufferDurationUs = rebuffering ? this.bufferForPlaybackAfterRebufferUs : this.bufferForPlaybackUs;
        if (targetLiveOffsetUs != -9223372036854775807L) {
            minBufferDurationUs = Math.min(targetLiveOffsetUs / 2L, minBufferDurationUs);
        }
        return minBufferDurationUs <= 0L || bufferedDurationUs >= minBufferDurationUs || !this.prioritizeTimeOverSizeThresholds && this.allocator.getTotalBytesAllocated() >= this.targetBufferBytes;
    }

    protected int calculateTargetBufferBytes(Renderer[] renderers, ExoTrackSelection[] trackSelectionArray) {
        int targetBufferSize = 0;
        for (int i = 0; i < renderers.length; ++i) {
            if (trackSelectionArray[i] == null) continue;
            targetBufferSize += DefaultLoadControl.getDefaultBufferSize(renderers[i].getTrackType());
        }
        return Math.max(0xC80000, targetBufferSize);
    }

    private void reset(boolean resetAllocator) {
        this.targetBufferBytes = this.targetBufferBytesOverwrite == -1 ? 0xC80000 : this.targetBufferBytesOverwrite;
        this.isLoading = false;
        if (resetAllocator) {
            this.allocator.reset();
        }
    }

    private static int getDefaultBufferSize(int trackType) {
        switch (trackType) {
            case 0: {
                return 144310272;
            }
            case 1: {
                return 0xC80000;
            }
            case 2: {
                return 0x7D00000;
            }
            case 3: {
                return 131072;
            }
            case 5: {
                return 131072;
            }
            case 6: {
                return 131072;
            }
            case 7: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    private static void assertGreaterOrEqual(int value1, int value2, String name1, String name2) {
        Assertions.checkArgument((value1 >= value2 ? 1 : 0) != 0, (Object)new StringBuilder(21 + String.valueOf(name1).length() + String.valueOf(name2).length()).append(name1).append(" cannot be less than ").append(name2).toString());
    }

    public static final class Builder {
        @Nullable
        private DefaultAllocator allocator;
        private int minBufferMs = 50000;
        private int maxBufferMs = 50000;
        private int bufferForPlaybackMs = 2500;
        private int bufferForPlaybackAfterRebufferMs = 5000;
        private int targetBufferBytes = -1;
        private boolean prioritizeTimeOverSizeThresholds = false;
        private int backBufferDurationMs = 0;
        private boolean retainBackBufferFromKeyframe = false;
        private boolean buildCalled;

        public Builder setAllocator(DefaultAllocator allocator) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.allocator = allocator;
            return this;
        }

        public Builder setBufferDurationsMs(int minBufferMs, int maxBufferMs, int bufferForPlaybackMs, int bufferForPlaybackAfterRebufferMs) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            DefaultLoadControl.assertGreaterOrEqual(bufferForPlaybackMs, 0, "bufferForPlaybackMs", "0");
            DefaultLoadControl.assertGreaterOrEqual(bufferForPlaybackAfterRebufferMs, 0, "bufferForPlaybackAfterRebufferMs", "0");
            DefaultLoadControl.assertGreaterOrEqual(minBufferMs, bufferForPlaybackMs, "minBufferMs", "bufferForPlaybackMs");
            DefaultLoadControl.assertGreaterOrEqual(minBufferMs, bufferForPlaybackAfterRebufferMs, "minBufferMs", "bufferForPlaybackAfterRebufferMs");
            DefaultLoadControl.assertGreaterOrEqual(maxBufferMs, minBufferMs, "maxBufferMs", "minBufferMs");
            this.minBufferMs = minBufferMs;
            this.maxBufferMs = maxBufferMs;
            this.bufferForPlaybackMs = bufferForPlaybackMs;
            this.bufferForPlaybackAfterRebufferMs = bufferForPlaybackAfterRebufferMs;
            return this;
        }

        public Builder setTargetBufferBytes(int targetBufferBytes) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.targetBufferBytes = targetBufferBytes;
            return this;
        }

        public Builder setPrioritizeTimeOverSizeThresholds(boolean prioritizeTimeOverSizeThresholds) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.prioritizeTimeOverSizeThresholds = prioritizeTimeOverSizeThresholds;
            return this;
        }

        public Builder setBackBuffer(int backBufferDurationMs, boolean retainBackBufferFromKeyframe) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            DefaultLoadControl.assertGreaterOrEqual(backBufferDurationMs, 0, "backBufferDurationMs", "0");
            this.backBufferDurationMs = backBufferDurationMs;
            this.retainBackBufferFromKeyframe = retainBackBufferFromKeyframe;
            return this;
        }

        @Deprecated
        public DefaultLoadControl createDefaultLoadControl() {
            return this.build();
        }

        public DefaultLoadControl build() {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.buildCalled = true;
            if (this.allocator == null) {
                this.allocator = new DefaultAllocator(true, 65536);
            }
            return new DefaultLoadControl(this.allocator, this.minBufferMs, this.maxBufferMs, this.bufferForPlaybackMs, this.bufferForPlaybackAfterRebufferMs, this.targetBufferBytes, this.prioritizeTimeOverSizeThresholds, this.backBufferDurationMs, this.retainBackBufferFromKeyframe);
        }
    }
}

